/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestRollingUpgrade;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeRollingUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeRollingUpgrade.class);
    private static final short REPL_FACTOR = 1;
    private static final int BLOCK_SIZE = 0x100000;
    private static final long FILE_SIZE = 0x100000L;
    private static final long SEED = 464384013L;
    @TempDir
    public java.nio.file.Path baseDir;
    Configuration conf;
    MiniDFSCluster cluster = null;
    DistributedFileSystem fs = null;
    DataNode dn0 = null;
    NameNode nn = null;
    String blockPoolId = null;

    private void startCluster() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.blocksize", 0x100000);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.nn = this.cluster.getNameNode(0);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.nn);
        this.dn0 = this.cluster.getDataNodes().get(0);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.dn0);
        this.blockPoolId = this.cluster.getNameNode(0).getNamesystem().getBlockPoolId();
    }

    private void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        this.fs = null;
        this.nn = null;
        this.dn0 = null;
        this.blockPoolId = null;
    }

    private void triggerHeartBeats() throws Exception {
        this.cluster.triggerHeartbeats();
        Thread.sleep(5000L);
    }

    private File getBlockForFile(Path path, boolean exists) throws IOException {
        LocatedBlocks blocks = this.nn.getRpcServer().getBlockLocations(path.toString(), 0L, Long.MAX_VALUE);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blocks.getLocatedBlocks().size(), (String)"The test helper functions assume that each file has a single block");
        ExtendedBlock block = ((LocatedBlock)blocks.getLocatedBlocks().get(0)).getBlock();
        BlockLocalPathInfo bInfo = this.dn0.getFSDataset().getBlockLocalPathInfo(block);
        File blockFile = new File(bInfo.getBlockPath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)exists, (Object)blockFile.exists());
        return blockFile;
    }

    private File getTrashFileForBlock(File blockFile, boolean exists) {
        ReplicaInfo info = (ReplicaInfo)Mockito.mock(ReplicaInfo.class);
        Mockito.when((Object)info.getBlockURI()).thenReturn((Object)blockFile.toURI());
        File trashFile = new File(this.dn0.getStorage().getTrashDirectoryForReplica(this.blockPoolId, info));
        org.junit.jupiter.api.Assertions.assertEquals((Object)exists, (Object)trashFile.exists());
        return trashFile;
    }

    private void deleteAndEnsureInTrash(Path pathToDelete, File blockFile, File trashFile) throws Exception {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)blockFile.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)trashFile.exists());
        LOG.info("Deleting file " + pathToDelete + " during rolling upgrade");
        this.fs.delete(pathToDelete, false);
        assert (!this.fs.exists(pathToDelete));
        this.triggerHeartBeats();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)trashFile.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)blockFile.exists());
    }

    private boolean isTrashRootPresent() {
        BlockPoolSliceStorage bps = this.dn0.getStorage().getBPStorage(this.blockPoolId);
        return bps.trashEnabled();
    }

    private void ensureTrashRestored(File blockFile, File trashFile) throws Exception {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)blockFile.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)trashFile.exists());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
    }

    private boolean isBlockFileInPrevious(File blockFile) {
        Pattern blockFilePattern = Pattern.compile(String.format("^(.*%1$scurrent%1$s.*%1$s)(current)(%1$s.*)$", Pattern.quote(File.separator)));
        Matcher matcher = blockFilePattern.matcher(blockFile.toString());
        String previousFileName = matcher.replaceFirst("$1previous$3");
        return new File(previousFileName).exists();
    }

    private void startRollingUpgrade() throws Exception {
        LOG.info("Starting rolling upgrade");
        this.fs.setSafeMode(SafeModeAction.ENTER);
        DFSAdmin dfsadmin = new DFSAdmin(this.conf);
        TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "prepare");
        this.triggerHeartBeats();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.dn0.getFSDataset().trashEnabled(this.blockPoolId));
    }

    private void finalizeRollingUpgrade() throws Exception {
        LOG.info("Finalizing rolling upgrade");
        DFSAdmin dfsadmin = new DFSAdmin(this.conf);
        TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "finalize");
        this.triggerHeartBeats();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.dn0.getFSDataset().trashEnabled(this.blockPoolId));
        BlockPoolSliceStorage bps = this.dn0.getStorage().getBPStorage(this.blockPoolId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)bps.trashEnabled());
    }

    private void rollbackRollingUpgrade() throws Exception {
        LOG.info("Starting rollback of the rolling upgrade");
        MiniDFSCluster.DataNodeProperties dnprop = this.cluster.stopDataNode(0);
        dnprop.setDnArgs("-rollback");
        this.cluster.shutdownNameNodes();
        this.cluster.restartNameNode("-rollingupgrade", "rollback");
        this.cluster.restartDataNode(dnprop);
        this.cluster.waitActive();
        this.nn = this.cluster.getNameNode(0);
        this.dn0 = this.cluster.getDataNodes().get(0);
        this.triggerHeartBeats();
        LOG.info("The cluster is active after rollback");
    }

    @Test
    @Timeout(value=600L)
    public void testDatanodeRollingUpgradeWithFinalize() throws Exception {
        try {
            this.startCluster();
            this.rollingUpgradeAndFinalize();
            this.rollingUpgradeAndFinalize();
        }
        finally {
            this.shutdownCluster();
        }
    }

    @Test
    @Timeout(value=600L)
    public void testDatanodeRUwithRegularUpgrade() throws Exception {
        try {
            this.startCluster();
            this.rollingUpgradeAndFinalize();
            MiniDFSCluster.DataNodeProperties dn = this.cluster.stopDataNode(0);
            this.cluster.restartNameNode(0, true, "-upgrade");
            this.cluster.restartDataNode(dn, true);
            this.cluster.waitActive();
            this.fs = this.cluster.getFileSystem(0);
            Path testFile3 = new Path("/" + GenericTestUtils.getMethodName() + ".03.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, testFile3, 0x100000L, (short)1, 464384013L);
            this.cluster.getFileSystem().finalizeUpgrade();
        }
        finally {
            this.shutdownCluster();
        }
    }

    private void rollingUpgradeAndFinalize() throws IOException, Exception {
        Path testFile1 = new Path("/" + GenericTestUtils.getMethodName() + ".01.dat");
        Path testFile2 = new Path("/" + GenericTestUtils.getMethodName() + ".02.dat");
        DFSTestUtil.createFile((FileSystem)this.fs, testFile1, 0x100000L, (short)1, 464384013L);
        DFSTestUtil.createFile((FileSystem)this.fs, testFile2, 0x100000L, (short)1, 464384013L);
        this.startRollingUpgrade();
        File blockFile = this.getBlockForFile(testFile2, true);
        File trashFile = this.getTrashFileForBlock(blockFile, false);
        this.cluster.triggerBlockReports();
        this.deleteAndEnsureInTrash(testFile2, blockFile, trashFile);
        this.finalizeRollingUpgrade();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
        assert (!this.fs.exists(testFile2));
        assert (this.fs.exists(testFile1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=600L)
    public void testDatanodeRollingUpgradeWithRollback() throws Exception {
        try {
            this.startCluster();
            Path testFile1 = new Path("/" + GenericTestUtils.getMethodName() + ".01.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, testFile1, 0x100000L, (short)1, 464384013L);
            String fileContents1 = DFSTestUtil.readFile((FileSystem)this.fs, testFile1);
            this.startRollingUpgrade();
            File blockFile = this.getBlockForFile(testFile1, true);
            File trashFile = this.getTrashFileForBlock(blockFile, false);
            this.deleteAndEnsureInTrash(testFile1, blockFile, trashFile);
            this.rollbackRollingUpgrade();
            this.ensureTrashRestored(blockFile, trashFile);
            assert (this.fs.exists(testFile1));
            String fileContents2 = DFSTestUtil.readFile((FileSystem)this.fs, testFile1);
            Assertions.assertThat((String)fileContents1).isEqualTo((Object)fileContents2);
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=600L)
    public void testDatanodePeersXceiver() throws Exception {
        try {
            this.startCluster();
            String testFile1 = "/" + GenericTestUtils.getMethodName() + ".01.dat";
            String testFile2 = "/" + GenericTestUtils.getMethodName() + ".02.dat";
            String testFile3 = "/" + GenericTestUtils.getMethodName() + ".03.dat";
            DFSClient client1 = new DFSClient(DFSUtilClient.getNNAddress((Configuration)this.conf), this.conf);
            DFSClient client2 = new DFSClient(DFSUtilClient.getNNAddress((Configuration)this.conf), this.conf);
            DFSClient client3 = new DFSClient(DFSUtilClient.getNNAddress((Configuration)this.conf), this.conf);
            DFSOutputStream s1 = (DFSOutputStream)client1.create(testFile1, true);
            DFSOutputStream s2 = (DFSOutputStream)client2.create(testFile2, true);
            DFSOutputStream s3 = (DFSOutputStream)client3.create(testFile3, true);
            byte[] toWrite = new byte[0x800000];
            Random rb = new Random(1111L);
            rb.nextBytes(toWrite);
            s1.write(toWrite, 0, 0x800000);
            s1.flush();
            s2.write(toWrite, 0, 0x800000);
            s2.flush();
            s3.write(toWrite, 0, 0x800000);
            s3.flush();
            org.junit.jupiter.api.Assertions.assertTrue((this.dn0.getXferServer().getNumPeersXceiver() == this.dn0.getXferServer().getNumPeersXceiver() ? 1 : 0) != 0);
            s1.close();
            s2.close();
            s3.close();
            org.junit.jupiter.api.Assertions.assertTrue((this.dn0.getXferServer().getNumPeersXceiver() == this.dn0.getXferServer().getNumPeersXceiver() ? 1 : 0) != 0);
            client1.close();
            client2.close();
            client3.close();
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testWithLayoutChangeAndFinalize() throws Exception {
        long seed = 1611526157L;
        try {
            this.startCluster();
            Path[] paths = new Path[3];
            File[] blockFiles = new File[3];
            for (int i = 0; i < 2; ++i) {
                paths[i] = new Path("/" + GenericTestUtils.getMethodName() + "." + i + ".dat");
                DFSTestUtil.createFile((FileSystem)this.fs, paths[i], 0x100000L, (short)2, 1611526157L);
            }
            this.startRollingUpgrade();
            blockFiles[0] = this.getBlockForFile(paths[0], true);
            File trashFile0 = this.getTrashFileForBlock(blockFiles[0], false);
            this.deleteAndEnsureInTrash(paths[0], blockFiles[0], trashFile0);
            LOG.info("Shutting down the Datanode");
            MiniDFSCluster.DataNodeProperties dnprop = this.cluster.stopDataNode(0);
            TestDataNodeRollingUpgrade.addDataNodeLayoutVersion(DataNodeLayoutVersion.getCurrentLayoutVersion() - 1);
            LOG.info("Restarting the DataNode");
            this.cluster.restartDataNode(dnprop, true);
            this.cluster.waitActive();
            this.dn0 = this.cluster.getDataNodes().get(0);
            LOG.info("The DN has been restarted");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)trashFile0.exists());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.dn0.getStorage().getBPStorage(this.blockPoolId).isTrashAllowed(blockFiles[0]));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
            blockFiles[1] = this.getBlockForFile(paths[1], true);
            this.fs.delete(paths[1], false);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[1]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
            this.finalizeRollingUpgrade();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isBlockFileInPrevious(blockFiles[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isBlockFileInPrevious(blockFiles[1]));
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testWithLayoutChangeAndRollback() throws Exception {
        long seed = 1611526157L;
        try {
            int i;
            this.startCluster();
            Path[] paths = new Path[3];
            File[] blockFiles = new File[3];
            for (int i2 = 0; i2 < 2; ++i2) {
                paths[i2] = new Path("/" + GenericTestUtils.getMethodName() + "." + i2 + ".dat");
                DFSTestUtil.createFile((FileSystem)this.fs, paths[i2], 0x100000L, (short)1, 1611526157L);
            }
            this.startRollingUpgrade();
            blockFiles[0] = this.getBlockForFile(paths[0], true);
            File trashFile0 = this.getTrashFileForBlock(blockFiles[0], false);
            this.deleteAndEnsureInTrash(paths[0], blockFiles[0], trashFile0);
            LOG.info("Shutting down the Datanode");
            MiniDFSCluster.DataNodeProperties dnprop = this.cluster.stopDataNode(0);
            TestDataNodeRollingUpgrade.addDataNodeLayoutVersion(DataNodeLayoutVersion.getCurrentLayoutVersion() - 1);
            LOG.info("Restarting the DataNode");
            this.cluster.restartDataNode(dnprop, true);
            this.cluster.waitActive();
            this.dn0 = this.cluster.getDataNodes().get(0);
            LOG.info("The DN has been restarted");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)trashFile0.exists());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.dn0.getStorage().getBPStorage(this.blockPoolId).isTrashAllowed(blockFiles[0]));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[0]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
            blockFiles[1] = this.getBlockForFile(paths[1], true);
            this.fs.delete(paths[1], false);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.isBlockFileInPrevious(blockFiles[1]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
            paths[2] = new Path("/" + GenericTestUtils.getMethodName() + ".2.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, paths[2], 0x100000L, (short)1, 1611526157L);
            blockFiles[2] = this.getBlockForFile(paths[2], true);
            this.fs.delete(paths[2], false);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isBlockFileInPrevious(blockFiles[2]));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
            this.rollbackRollingUpgrade();
            for (i = 0; i < 2; ++i) {
                byte[] actual = DFSTestUtil.readFileBuffer((FileSystem)this.fs, paths[i]);
                byte[] calculated = DFSTestUtil.calculateFileContentsFromSeed(1611526157L, 0x100000);
                org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])actual, (byte[])calculated);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isTrashRootPresent());
            for (i = 0; i < 3; ++i) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)this.isBlockFileInPrevious(blockFiles[i]));
            }
        }
        finally {
            this.shutdownCluster();
        }
    }

    static void addDataNodeLayoutVersion(int lv) {
        org.junit.jupiter.api.Assertions.assertTrue((lv < DataNodeLayoutVersion.getCurrentLayoutVersion() ? 1 : 0) != 0);
        DataNodeLayoutVersion.setCurrentLayoutVersionForTesting((int)lv);
        LayoutVersion.FeatureInfo featureInfo = new LayoutVersion.FeatureInfo(lv, lv + 1, "Test Layout for TestDataNodeRollingUpgrade", false, new LayoutVersion.LayoutFeature[0]);
        LayoutVersion.updateMap((Map)DataNodeLayoutVersion.FEATURES, (LayoutVersion.LayoutFeature[])new LayoutVersion.LayoutFeature[]{() -> featureInfo});
    }
}

