/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeMultipleRegistrations {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeMultipleRegistrations.class);
    Configuration conf;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2NNRegistration() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).build();
        try {
            cluster.waitActive();
            NameNode nn1 = cluster.getNameNode(0);
            NameNode nn2 = cluster.getNameNode(1);
            Assertions.assertNotNull((Object)nn1, (String)"cannot create nn1");
            Assertions.assertNotNull((Object)nn2, (String)"cannot create nn2");
            String bpid1 = FSImageTestUtil.getFSImage(nn1).getBlockPoolID();
            String bpid2 = FSImageTestUtil.getFSImage(nn2).getBlockPoolID();
            String cid1 = FSImageTestUtil.getFSImage(nn1).getClusterID();
            String cid2 = FSImageTestUtil.getFSImage(nn2).getClusterID();
            int lv1 = FSImageTestUtil.getFSImage(nn1).getLayoutVersion();
            int lv2 = FSImageTestUtil.getFSImage(nn2).getLayoutVersion();
            int ns1 = FSImageTestUtil.getFSImage(nn1).getNamespaceID();
            int ns2 = FSImageTestUtil.getFSImage(nn2).getNamespaceID();
            Assertions.assertNotSame((Object)ns1, (Object)ns2, (String)"namespace ids should be different");
            LOG.info("nn1: lv=" + lv1 + ";cid=" + cid1 + ";bpid=" + bpid1 + ";uri=" + nn1.getNameNodeAddress());
            LOG.info("nn2: lv=" + lv2 + ";cid=" + cid2 + ";bpid=" + bpid2 + ";uri=" + nn2.getNameNodeAddress());
            DataNode dn = cluster.getDataNodes().get(0);
            Map volInfos = dn.data.getVolumeInfoMap();
            Assertions.assertTrue((volInfos.size() > 0 ? 1 : 0) != 0, (String)"No volumes in the fsdataset");
            int i = 0;
            for (Map.Entry e : volInfos.entrySet()) {
                LOG.info("vol " + i++ + ") " + (String)e.getKey() + ": " + e.getValue());
            }
            Assertions.assertEquals((int)cluster.getFsDatasetTestUtils(0).getDefaultNumOfDataDirs(), (int)volInfos.size(), (String)"number of volumes is wrong");
            for (BPOfferService bpos : dn.getAllBpOs()) {
                LOG.info("BP: " + bpos);
            }
            BPOfferService bpos1 = (BPOfferService)dn.getAllBpOs().get(0);
            BPOfferService bpos2 = (BPOfferService)dn.getAllBpOs().get(1);
            if (TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos1).equals(nn2.getNameNodeAddress())) {
                BPOfferService tmp = bpos1;
                bpos1 = bpos2;
                bpos2 = tmp;
            }
            Assertions.assertEquals((Object)TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos1), (Object)nn1.getNameNodeAddress(), (String)"wrong nn address");
            Assertions.assertEquals((Object)TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos2), (Object)nn2.getNameNodeAddress(), (String)"wrong nn address");
            Assertions.assertEquals((Object)bpos1.getBlockPoolId(), (Object)bpid1, (String)"wrong bpid");
            Assertions.assertEquals((Object)bpos2.getBlockPoolId(), (Object)bpid2, (String)"wrong bpid");
            Assertions.assertEquals((Object)dn.getClusterId(), (Object)cid1, (String)"wrong cid");
            Assertions.assertEquals((Object)cid2, (Object)cid1, (String)"cid should be same");
            Assertions.assertEquals((int)bpos1.bpNSInfo.namespaceID, (int)ns1, (String)"namespace should be same");
            Assertions.assertEquals((int)bpos2.bpNSInfo.namespaceID, (int)ns2, (String)"namespace should be same");
        }
        finally {
            cluster.shutdown();
        }
    }

    private static InetSocketAddress getNNSocketAddress(BPOfferService bpos) {
        List actors = bpos.getBPServiceActors();
        Assertions.assertEquals((int)1, (int)actors.size());
        return ((BPServiceActor)actors.get(0)).getNNSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFedSingleNN() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nameNodePort(9927).build();
        try {
            NameNode nn1 = cluster.getNameNode();
            Assertions.assertNotNull((Object)nn1, (String)"cannot create nn1");
            String bpid1 = FSImageTestUtil.getFSImage(nn1).getBlockPoolID();
            String cid1 = FSImageTestUtil.getFSImage(nn1).getClusterID();
            int lv1 = FSImageTestUtil.getFSImage(nn1).getLayoutVersion();
            LOG.info("nn1: lv=" + lv1 + ";cid=" + cid1 + ";bpid=" + bpid1 + ";uri=" + nn1.getNameNodeAddress());
            DataNode dn = cluster.getDataNodes().get(0);
            Map volInfos = dn.data.getVolumeInfoMap();
            Assertions.assertTrue((volInfos.size() > 0 ? 1 : 0) != 0, (String)"No volumes in the fsdataset");
            int i = 0;
            for (Map.Entry e : volInfos.entrySet()) {
                LOG.info("vol " + i++ + ") " + (String)e.getKey() + ": " + e.getValue());
            }
            Assertions.assertEquals((int)cluster.getFsDatasetTestUtils(0).getDefaultNumOfDataDirs(), (int)volInfos.size(), (String)"number of volumes is wrong");
            for (BPOfferService bpos : dn.getAllBpOs()) {
                LOG.info("reg: bpid=; name=" + bpos.bpRegistration + "; sid=" + bpos.bpRegistration.getDatanodeUuid() + "; nna=" + TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos));
            }
            BPOfferService bpos1 = (BPOfferService)dn.getAllBpOs().get(0);
            bpos1.triggerBlockReportForTests();
            Assertions.assertEquals((Object)TestDataNodeMultipleRegistrations.getNNSocketAddress(bpos1), (Object)nn1.getNameNodeAddress(), (String)"wrong nn address");
            Assertions.assertEquals((Object)bpos1.getBlockPoolId(), (Object)bpid1, (String)"wrong bpid");
            Assertions.assertEquals((Object)dn.getClusterId(), (Object)cid1, (String)"wrong cid");
            cluster.shutdown();
            Assertions.assertEquals((int)0, (int)dn.getAllBpOs().size());
            cluster = null;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterIdMismatch() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).build();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            List bposs = dn.getAllBpOs();
            LOG.info("dn bpos len (should be 2):" + bposs.size());
            Assertions.assertEquals((int)bposs.size(), (int)2, (String)"should've registered with two namenodes");
            cluster.addNameNode(this.conf, 9938);
            Thread.sleep(500L);
            bposs = dn.getAllBpOs();
            LOG.info("dn bpos len (should be 3):" + bposs.size());
            Assertions.assertEquals((int)bposs.size(), (int)3, (String)"should've registered with three namenodes");
            HdfsServerConstants.StartupOption.FORMAT.setClusterId("DifferentCID");
            cluster.addNameNode(this.conf, 9948);
            NameNode nn4 = cluster.getNameNode(3);
            Assertions.assertNotNull((Object)nn4, (String)"cannot create nn4");
            Thread.sleep(500L);
            bposs = dn.getAllBpOs();
            LOG.info("dn bpos len (still should be 3):" + bposs.size());
            Assertions.assertEquals((int)3, (int)bposs.size(), (String)"should've registered with three namenodes");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testClusterIdMismatchAtStartupWithHA() throws Exception {
        MiniDFSNNTopology top = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn0")).addNN(new MiniDFSNNTopology.NNConf("nn1"))).addNameservice(new MiniDFSNNTopology.NSConf("ns2").addNN(new MiniDFSNNTopology.NNConf("nn2").setClusterId("bad-cid")).addNN(new MiniDFSNNTopology.NNConf("nn3").setClusterId("bad-cid")));
        top.setFederation(true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(top).numDataNodes(0).build();
        try {
            cluster.startDataNodes(this.conf, 1, true, null, null);
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            Assertions.assertTrue((boolean)dn.isDatanodeUp(), (String)"Datanode should be running");
            Assertions.assertEquals((int)1, (int)dn.getAllBpOs().size(), (String)"Only one BPOfferService should be running");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDNWithInvalidStorageWithHA() throws Exception {
        MiniDFSNNTopology top = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn0").setClusterId("cluster-1")).addNN(new MiniDFSNNTopology.NNConf("nn1").setClusterId("cluster-1")));
        top.setFederation(true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(top).numDataNodes(0).build();
        try {
            cluster.startDataNodes(this.conf, 1, true, null, null);
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            Assertions.assertTrue((boolean)dn.isDatanodeUp(), (String)"Datanode should be running");
            Assertions.assertEquals((int)1, (int)dn.getAllBpOs().size(), (String)"BPOfferService should be running");
            MiniDFSCluster.DataNodeProperties dnProp = cluster.stopDataNode(0);
            cluster.getNameNode(0).stop();
            cluster.getNameNode(1).stop();
            Configuration nn1 = cluster.getConfiguration(0);
            Configuration nn2 = cluster.getConfiguration(1);
            HdfsServerConstants.StartupOption.FORMAT.setClusterId("cluster-2");
            DFSTestUtil.formatNameNode(nn1);
            MiniDFSCluster.copyNameDirs(FSNamesystem.getNamespaceDirs((Configuration)nn1), FSNamesystem.getNamespaceDirs((Configuration)nn2), nn2);
            cluster.restartNameNode(0, false, new String[0]);
            cluster.restartNameNode(1, false, new String[0]);
            cluster.restartDataNode(dnProp);
            final DataNode restartedDn = cluster.getDataNodes().get(0);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    for (BPOfferService bp : restartedDn.getAllBpOs()) {
                        for (BPServiceActor ba : bp.getBPServiceActors()) {
                            if (ba.getRunningState().equals(BPServiceActor.RunningState.FAILED.name())) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }, (long)500L, (long)20000L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniDFSClusterWithMultipleNN() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).build();
        try {
            cluster.waitActive();
            Assertions.assertEquals((int)2, (int)cluster.getNumNameNodes(), (String)"(1)Should be 2 namenodes");
            cluster.addNameNode((Configuration)conf, 0);
            Assertions.assertEquals((int)3, (int)cluster.getNumNameNodes(), (String)"(1)Should be 3 namenodes");
        }
        catch (IOException ioe) {
            Assertions.fail((String)("Failed to add NN to cluster:" + StringUtils.stringifyException((Throwable)ioe)));
        }
        finally {
            cluster.shutdown();
        }
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(1)).build();
        try {
            Assertions.assertNotNull((Object)cluster);
            cluster.waitActive();
            Assertions.assertEquals((int)1, (int)cluster.getNumNameNodes(), (String)"(2)Should be 1 namenodes");
            cluster.addNameNode((Configuration)conf, 0);
            Assertions.assertEquals((int)2, (int)cluster.getNumNameNodes(), (String)"(2)Should be 2 namenodes");
        }
        catch (IOException ioe) {
            Assertions.fail((String)("Failed to add NN to cluster:" + StringUtils.stringifyException((Throwable)ioe)));
        }
        finally {
            cluster.shutdown();
        }
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            Assertions.assertNotNull((Object)cluster);
            Assertions.assertEquals((int)1, (int)cluster.getNumNameNodes(), (String)"(2)Should be 1 namenodes");
            cluster.addNameNode((Configuration)conf, 9929);
            Assertions.fail((String)"shouldn't be able to add another NN to non federated cluster");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("cannot add namenode"));
            Assertions.assertEquals((int)1, (int)cluster.getNumNameNodes(), (String)"(3)Should be 1 namenodes");
        }
        finally {
            cluster.shutdown();
        }
    }
}

