/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Time;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeHotSwapVolumes {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeHotSwapVolumes.class);
    private static final int BLOCK_SIZE = 512;
    private static final int DEFAULT_STORAGES_PER_DATANODE = 2;
    private MiniDFSCluster cluster;
    private Configuration conf;

    @AfterEach
    public void tearDown() {
        this.shutdown();
    }

    private void startDFSCluster(int numNameNodes, int numDataNodes) throws IOException {
        this.startDFSCluster(numNameNodes, numDataNodes, 2);
    }

    private void startDFSCluster(int numNameNodes, int numDataNodes, int storagePerDataNode) throws IOException {
        this.shutdown();
        this.conf = this.setConfiguration(new Configuration());
        MiniDFSNNTopology nnTopology = MiniDFSNNTopology.simpleFederatedTopology(numNameNodes);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(nnTopology).numDataNodes(numDataNodes).storagesPerDatanode(storagePerDataNode).build();
        this.cluster.waitActive();
    }

    private Configuration setConfiguration(Configuration config) {
        config.setLong("dfs.blocksize", 512L);
        config.setLong("dfs.blocksize", 512L);
        config.setLong("dfs.namenode.fs-limits.min-block-size", 1L);
        config.setInt("dfs.heartbeat.interval", 1);
        config.setInt("dfs.df.interval", 1000);
        config.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        config.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        config.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
        return config;
    }

    private void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void createFile(Path path, int numBlocks) throws IOException, InterruptedException, TimeoutException {
        boolean replicateFactor = true;
        this.createFile(path, numBlocks, (short)1);
    }

    private void createFile(Path path, int numBlocks, short replicateFactor) throws IOException, InterruptedException, TimeoutException {
        this.createFile(0, path, numBlocks, replicateFactor);
    }

    private void createFile(int fsIdx, Path path, int numBlocks) throws IOException, InterruptedException, TimeoutException {
        boolean replicateFactor = true;
        this.createFile(fsIdx, path, numBlocks, (short)1);
    }

    private void createFile(int fsIdx, Path path, int numBlocks, short replicateFactor) throws IOException, TimeoutException, InterruptedException {
        boolean seed = false;
        DistributedFileSystem fs = this.cluster.getFileSystem(fsIdx);
        DFSTestUtil.createFile((FileSystem)fs, path, 512 * numBlocks, replicateFactor, 0L);
        DFSTestUtil.waitReplication((FileSystem)fs, path, replicateFactor);
    }

    private static void verifyFileLength(FileSystem fs, Path path, int numBlocks) throws IOException {
        FileStatus status = fs.getFileStatus(path);
        org.junit.jupiter.api.Assertions.assertEquals((long)(numBlocks * 512), (long)status.getLen());
    }

    private static int getNumReplicas(FileSystem fs, Path file, int blockIdx) throws IOException {
        BlockLocation[] locs = fs.getFileBlockLocations(file, 0L, Long.MAX_VALUE);
        return locs.length < blockIdx + 1 ? 0 : locs[blockIdx].getNames().length;
    }

    private static void waitReplication(FileSystem fs, Path file, int blockIdx, int numReplicas) throws IOException, TimeoutException, InterruptedException {
        for (int attempts = 50; attempts > 0; --attempts) {
            int actualReplicas = TestDataNodeHotSwapVolumes.getNumReplicas(fs, file, blockIdx);
            if (actualReplicas == numReplicas) {
                return;
            }
            System.out.printf("Block %d of file %s has %d replicas (desired %d).\n", blockIdx, file.toString(), actualReplicas, numReplicas);
            Thread.sleep(100L);
        }
        throw new TimeoutException("Timed out waiting the " + blockIdx + "-th block of " + file + " to have " + numReplicas + " replicas.");
    }

    private static List<String> getDataDirs(DataNode datanode) {
        return new ArrayList<String>(datanode.getConf().getTrimmedStringCollection("dfs.datanode.data.dir"));
    }

    private static void triggerDeleteReport(DataNode datanode) throws IOException {
        datanode.scheduleAllBlockReport(0L);
        DataNodeTestUtils.triggerDeletionReport(datanode);
    }

    @Test
    public void testParseChangedVolumes() throws IOException {
        this.startDFSCluster(1, 1);
        DataNode dn = this.cluster.getDataNodes().get(0);
        Configuration conf = dn.getConf();
        String oldPaths = conf.get("dfs.datanode.data.dir");
        ArrayList<StorageLocation> oldLocations = new ArrayList<StorageLocation>();
        for (String path : oldPaths.split(",")) {
            oldLocations.add(StorageLocation.parse((String)path));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldLocations.isEmpty());
        String newPaths = new File(((StorageLocation)oldLocations.get(0)).getUri()).getAbsolutePath() + ",/foo/path1,/foo/path2";
        DataNode.ChangedVolumes changedVolumes = dn.parseChangedVolumes(newPaths);
        List newVolumes = changedVolumes.newLocations;
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)newVolumes.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new File("/foo/path1").getAbsolutePath(), (Object)new File(((StorageLocation)newVolumes.get(0)).getUri()).getAbsolutePath());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new File("/foo/path2").getAbsolutePath(), (Object)new File(((StorageLocation)newVolumes.get(1)).getUri()).getAbsolutePath());
        List removedVolumes = changedVolumes.deactivateLocations;
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)removedVolumes.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((StorageLocation)oldLocations.get(1)).getNormalizedUri(), (Object)((StorageLocation)removedVolumes.get(0)).getNormalizedUri());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)changedVolumes.unchangedLocations.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((StorageLocation)oldLocations.get(0)).getNormalizedUri(), (Object)((StorageLocation)changedVolumes.unchangedLocations.get(0)).getNormalizedUri());
    }

    @Test
    public void testParseChangedVolumesFailures() throws IOException {
        this.startDFSCluster(1, 1);
        DataNode dn = this.cluster.getDataNodes().get(0);
        try {
            dn.parseChangedVolumes("");
            org.junit.jupiter.api.Assertions.fail((String)"Should throw IOException: empty inputs.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"No directory is specified.", (Throwable)e);
        }
    }

    @Test
    public void testParseStorageTypeChanges() throws IOException {
        this.startDFSCluster(1, 1);
        DataNode dn = this.cluster.getDataNodes().get(0);
        Configuration conf = dn.getConf();
        List oldLocations = DataNode.getStorageLocations((Configuration)conf);
        String newLoc = String.format("[%s]%s", StorageType.SSD, ((StorageLocation)oldLocations.get(1)).getUri());
        String newDataDirs = ((StorageLocation)oldLocations.get(0)).toString() + "," + newLoc;
        try {
            dn.parseChangedVolumes(newDataDirs);
            org.junit.jupiter.api.Assertions.fail((String)"should throw IOE because storage type changes.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Changing storage type is not allowed", (Throwable)e);
        }
    }

    private void addVolumes(int numNewVolumes) throws InterruptedException, IOException, ReconfigurationException {
        this.addVolumes(numNewVolumes, new CountDownLatch(0));
    }

    private void addVolumes(int numNewVolumes, CountDownLatch waitLatch) throws ReconfigurationException, IOException, InterruptedException {
        File volumeDir;
        DataNode dn = this.cluster.getDataNodes().get(0);
        Configuration conf = dn.getConf();
        String oldDataDir = conf.get("dfs.datanode.data.dir");
        ArrayList<File> newVolumeDirs = new ArrayList<File>();
        StringBuilder newDataDirBuf = new StringBuilder(oldDataDir);
        int startIdx = oldDataDir.split(",").length + 1;
        while ((volumeDir = this.cluster.getInstanceStorageDir(0, startIdx)).exists()) {
            ++startIdx;
        }
        for (int i = startIdx; i < startIdx + numNewVolumes; ++i) {
            File volumeDir2 = this.cluster.getInstanceStorageDir(0, i);
            newVolumeDirs.add(volumeDir2);
            volumeDir2.mkdirs();
            newDataDirBuf.append(",");
            newDataDirBuf.append(StorageLocation.parse((String)volumeDir2.toString()).toString());
        }
        String newDataDir = newDataDirBuf.toString();
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", newDataDir)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)conf.get("dfs.datanode.data.dir"));
        waitLatch.await();
        String[] effectiveDataDirs = conf.get("dfs.datanode.data.dir").split(",");
        String[] expectDataDirs = newDataDir.split(",");
        org.junit.jupiter.api.Assertions.assertEquals((int)expectDataDirs.length, (int)effectiveDataDirs.length);
        ArrayList<StorageLocation> expectedStorageLocations = new ArrayList<StorageLocation>();
        ArrayList<StorageLocation> effectiveStorageLocations = new ArrayList<StorageLocation>();
        for (int i = 0; i < expectDataDirs.length; ++i) {
            StorageLocation expectLocation = StorageLocation.parse((String)expectDataDirs[i]);
            StorageLocation effectiveLocation = StorageLocation.parse((String)effectiveDataDirs[i]);
            expectedStorageLocations.add(expectLocation);
            effectiveStorageLocations.add(effectiveLocation);
        }
        Comparator<StorageLocation> comparator = new Comparator<StorageLocation>(){

            @Override
            public int compare(StorageLocation o1, StorageLocation o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
        Collections.sort(expectedStorageLocations, comparator);
        Collections.sort(effectiveStorageLocations, comparator);
        org.junit.jupiter.api.Assertions.assertEquals(expectedStorageLocations, effectiveStorageLocations, (String)"Effective volumes doesnt match expected");
        for (File volumeDir3 : newVolumeDirs) {
            File curDir = new File(volumeDir3, "current");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)curDir.exists());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)curDir.isDirectory());
        }
    }

    private List<List<Integer>> getNumBlocksReport(int namesystemIdx) {
        ArrayList<List<Integer>> results = new ArrayList<List<Integer>>();
        String bpid = this.cluster.getNamesystem(namesystemIdx).getBlockPoolId();
        List<Map<DatanodeStorage, BlockListAsLongs>> blockReports = this.cluster.getAllBlockReports(bpid);
        for (Map<DatanodeStorage, BlockListAsLongs> datanodeReport : blockReports) {
            ArrayList<Integer> numBlocksPerDN = new ArrayList<Integer>();
            for (BlockListAsLongs blocks : datanodeReport.values()) {
                numBlocksPerDN.add(blocks.getNumberOfBlocks());
            }
            results.add(numBlocksPerDN);
        }
        return results;
    }

    @Test
    @Timeout(value=60L)
    public void testAddOneNewVolume() throws IOException, ReconfigurationException, InterruptedException, TimeoutException {
        this.startDFSCluster(1, 1);
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        int numBlocks = 10;
        this.addVolumes(1);
        Path testFile = new Path("/test");
        this.createFile(testFile, 10);
        List<Map<DatanodeStorage, BlockListAsLongs>> blockReports = this.cluster.getAllBlockReports(bpid);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)blockReports.get(0).size());
        int minNumBlocks = Integer.MAX_VALUE;
        int maxNumBlocks = Integer.MIN_VALUE;
        for (BlockListAsLongs blockList : blockReports.get(0).values()) {
            minNumBlocks = Math.min(minNumBlocks, blockList.getNumberOfBlocks());
            maxNumBlocks = Math.max(maxNumBlocks, blockList.getNumberOfBlocks());
        }
        org.junit.jupiter.api.Assertions.assertTrue((Math.abs(maxNumBlocks - minNumBlocks) <= 1 ? 1 : 0) != 0);
        TestDataNodeHotSwapVolumes.verifyFileLength((FileSystem)this.cluster.getFileSystem(), testFile, 10);
    }

    @Test
    @Timeout(value=60L)
    public void testReAddVolumeWithBlocks() throws IOException, ReconfigurationException, InterruptedException, TimeoutException {
        this.startDFSCluster(1, 1);
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        int numBlocks = 10;
        Path testFile = new Path("/test");
        this.createFile(testFile, 10);
        List<Map<DatanodeStorage, BlockListAsLongs>> blockReports = this.cluster.getAllBlockReports(bpid);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)blockReports.get(0).size());
        DataNode dn = this.cluster.getDataNodes().get(0);
        List<String> oldDirs = TestDataNodeHotSwapVolumes.getDataDirs(dn);
        String newDirs = (String)oldDirs.iterator().next();
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", newDirs)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
        TestDataNodeHotSwapVolumes.assertFileLocksReleased(new ArrayList<String>(oldDirs).subList(1, oldDirs.size()));
        this.createFile(new Path("/test2"), 10);
        dn.scheduleAllBlockReport(0L);
        blockReports = this.cluster.getAllBlockReports(bpid);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.get(0).size());
        for (BlockListAsLongs blockList : blockReports.get(0).values()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)blockList.getNumberOfBlocks());
        }
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", String.join((CharSequence)",", oldDirs))).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
        dn.scheduleAllBlockReport(0L);
        blockReports = this.cluster.getAllBlockReports(bpid);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)blockReports.get(0).size());
        int minNumBlocks = Integer.MAX_VALUE;
        int maxNumBlocks = Integer.MIN_VALUE;
        for (BlockListAsLongs blockList : blockReports.get(0).values()) {
            minNumBlocks = Math.min(minNumBlocks, blockList.getNumberOfBlocks());
            maxNumBlocks = Math.max(maxNumBlocks, blockList.getNumberOfBlocks());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)minNumBlocks);
        org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)maxNumBlocks);
    }

    @Test
    @Timeout(value=60L)
    public void testAddVolumesDuringWrite() throws IOException, InterruptedException, TimeoutException, ReconfigurationException {
        this.startDFSCluster(1, 1);
        int numVolumes = this.cluster.getStoragesPerDatanode();
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        Path testFile = new Path("/test");
        int initialBlockCount = numVolumes * 2;
        this.createFile(testFile, initialBlockCount);
        int newVolumeCount = 5;
        this.addVolumes(newVolumeCount);
        numVolumes += newVolumeCount;
        int additionalBlockCount = 9;
        int totalBlockCount = initialBlockCount + additionalBlockCount;
        DFSTestUtil.appendFile((FileSystem)this.cluster.getFileSystem(), testFile, 512 * additionalBlockCount);
        TestDataNodeHotSwapVolumes.verifyFileLength((FileSystem)this.cluster.getFileSystem(), testFile, totalBlockCount);
        List<Integer> expectedNumBlocks = Arrays.asList(1, 1, 1, 1, 1, 4, 4);
        List<Map<DatanodeStorage, BlockListAsLongs>> blockReports = this.cluster.getAllBlockReports(bpid);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)numVolumes, (int)blockReports.get(0).size());
        Map<DatanodeStorage, BlockListAsLongs> dnReport = blockReports.get(0);
        ArrayList<Integer> actualNumBlocks = new ArrayList<Integer>();
        for (BlockListAsLongs blockList : dnReport.values()) {
            actualNumBlocks.add(blockList.getNumberOfBlocks());
        }
        Collections.sort(actualNumBlocks);
        org.junit.jupiter.api.Assertions.assertEquals(expectedNumBlocks, actualNumBlocks);
    }

    @Test
    @Timeout(value=180L)
    public void testAddVolumesConcurrently() throws IOException, InterruptedException, TimeoutException, ReconfigurationException {
        this.startDFSCluster(1, 1, 10);
        int numVolumes = this.cluster.getStoragesPerDatanode();
        String blockPoolId = this.cluster.getNamesystem().getBlockPoolId();
        Path testFile = new Path("/test");
        int initialBlockCount = numVolumes * 2;
        this.createFile(testFile, initialBlockCount);
        final DataNode dn = this.cluster.getDataNodes().get(0);
        FsDatasetSpi data = dn.data;
        dn.data = (FsDatasetSpi)Mockito.spy((Object)data);
        int newVolumeCount = 40;
        final List<Thread> addVolumeDelayedThreads = Collections.synchronizedList(new ArrayList());
        final AtomicBoolean addVolumeError = new AtomicBoolean(false);
        final AtomicBoolean listStorageError = new AtomicBoolean(false);
        final CountDownLatch addVolumeCompletionLatch = new CountDownLatch(40);
        Thread listStorageThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (addVolumeCompletionLatch.getCount() != 40L) {
                    int i = 0;
                    while (i++ < 1000) {
                        try {
                            dn.getStorage().listStorageDirectories();
                        }
                        catch (Exception e) {
                            listStorageError.set(true);
                            LOG.error("Error listing storage: " + e);
                        }
                    }
                }
            }
        });
        listStorageThread.start();
        ((FsDatasetSpi)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(final InvocationOnMock invocationOnMock) throws Throwable {
                final Random r = new Random();
                Thread addVolThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            r.setSeed(Time.now());
                            if (r.nextInt(10) > 4) {
                                int s = r.nextInt(10) + 1;
                                Thread.sleep(s * 100);
                            }
                            invocationOnMock.callRealMethod();
                        }
                        catch (Throwable throwable) {
                            addVolumeError.set(true);
                            LOG.error("Error adding volume: " + throwable);
                        }
                        finally {
                            addVolumeCompletionLatch.countDown();
                        }
                    }
                });
                addVolumeDelayedThreads.add(addVolThread);
                addVolThread.start();
                return null;
            }
        }).when((Object)dn.data)).addVolume((StorageLocation)ArgumentMatchers.any(StorageLocation.class), (List)ArgumentMatchers.any(List.class));
        this.addVolumes(40, addVolumeCompletionLatch);
        numVolumes += 40;
        for (Thread t : addVolumeDelayedThreads) {
            t.join();
        }
        listStorageThread.join();
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)addVolumeError.get(), (String)"Error adding volumes!");
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)listStorageError.get(), (String)"Error listing storage!");
        int additionalBlockCount = 9;
        int totalBlockCount = initialBlockCount + additionalBlockCount;
        DFSTestUtil.appendFile((FileSystem)this.cluster.getFileSystem(), testFile, 512 * additionalBlockCount);
        TestDataNodeHotSwapVolumes.verifyFileLength((FileSystem)this.cluster.getFileSystem(), testFile, totalBlockCount);
        List<Map<DatanodeStorage, BlockListAsLongs>> blockReports = this.cluster.getAllBlockReports(blockPoolId);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)numVolumes, (int)blockReports.get(0).size());
    }

    @Test
    @Timeout(value=60L)
    public void testAddVolumesToFederationNN() throws IOException, TimeoutException, InterruptedException, ReconfigurationException {
        int numNameNodes = 2;
        boolean numDataNodes = true;
        this.startDFSCluster(2, 1);
        Path testFile = new Path("/test");
        this.createFile(0, testFile, 4);
        this.createFile(1, testFile, 4);
        int numNewVolumes = 2;
        this.addVolumes(2);
        DFSTestUtil.appendFile((FileSystem)this.cluster.getFileSystem(0), testFile, 4096);
        List<List<Integer>> actualNumBlocks = this.getNumBlocksReport(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)this.cluster.getDataNodes().size(), (int)actualNumBlocks.size());
        List<Integer> blocksOnFirstDN = actualNumBlocks.get(0);
        Collections.sort(blocksOnFirstDN);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(2, 2, 4, 4), blocksOnFirstDN);
        actualNumBlocks = this.getNumBlocksReport(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)actualNumBlocks.get(0).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)Collections.frequency((Collection)actualNumBlocks.get(0), 0));
    }

    @Test
    @Timeout(value=60L)
    public void testRemoveOneVolume() throws ReconfigurationException, InterruptedException, TimeoutException, IOException {
        this.startDFSCluster(1, 1);
        boolean replFactor = true;
        Path testFile = new Path("/test");
        this.createFile(testFile, 10, (short)1);
        DataNode dn = this.cluster.getDataNodes().get(0);
        List<String> oldDirs = TestDataNodeHotSwapVolumes.getDataDirs(dn);
        String newDirs = (String)oldDirs.iterator().next();
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", newDirs)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
        TestDataNodeHotSwapVolumes.assertFileLocksReleased(new ArrayList<String>(oldDirs).subList(1, oldDirs.size()));
        dn.scheduleAllBlockReport(0L);
        try {
            DFSTestUtil.readFile((FileSystem)this.cluster.getFileSystem(), testFile);
            org.junit.jupiter.api.Assertions.fail((String)"Expect to throw BlockMissingException.");
        }
        catch (BlockMissingException e) {
            GenericTestUtils.assertExceptionContains((String)"Could not obtain block", (Throwable)e);
        }
        Path newFile = new Path("/newFile");
        this.createFile(newFile, 6);
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        List<Map<DatanodeStorage, BlockListAsLongs>> blockReports = this.cluster.getAllBlockReports(bpid);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)blockReports.size());
        BlockListAsLongs blocksForVolume1 = blockReports.get(0).values().iterator().next();
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)blocksForVolume1.getNumberOfBlocks());
    }

    @Test
    @Timeout(value=60L)
    public void testReplicatingAfterRemoveVolume() throws InterruptedException, TimeoutException, IOException, ReconfigurationException {
        String dirWithBlock;
        this.startDFSCluster(1, 2);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        int replFactor = 2;
        Path testFile = new Path("/test");
        this.createFile(testFile, 4, (short)2);
        DataNode dn = this.cluster.getDataNodes().get(0);
        List<String> oldDirs = TestDataNodeHotSwapVolumes.getDataDirs(dn);
        ExtendedBlock block = DFSTestUtil.getAllBlocks((FileSystem)fs, testFile).get(1).getBlock();
        FsVolumeSpi volumeWithBlock = dn.getFSDataset().getVolume(block);
        String newDirs = dirWithBlock = "[" + volumeWithBlock.getStorageType() + "]" + volumeWithBlock.getStorageLocation().getUri();
        for (String dir : oldDirs) {
            if (dirWithBlock.startsWith(dir)) continue;
            newDirs = dir;
            break;
        }
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", newDirs)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
        oldDirs.remove(newDirs);
        TestDataNodeHotSwapVolumes.assertFileLocksReleased(oldDirs);
        TestDataNodeHotSwapVolumes.triggerDeleteReport(dn);
        TestDataNodeHotSwapVolumes.waitReplication((FileSystem)fs, testFile, 1, 1);
        DFSTestUtil.waitReplication((FileSystem)fs, testFile, (short)2);
    }

    @Test
    public void testAddVolumeFailures() throws IOException {
        Object messages;
        this.startDFSCluster(1, 1);
        String dataDir = this.cluster.getDataDirectory();
        DataNode dn = this.cluster.getDataNodes().get(0);
        ArrayList newDirs = Lists.newArrayList();
        int NUM_NEW_DIRS = 4;
        for (int i = 0; i < 4; ++i) {
            File newVolume = new File(dataDir, "new_vol" + i);
            newDirs.add(newVolume.toString());
            if (i % 2 != 0) continue;
            newVolume.createNewFile();
        }
        String newValue = dn.getConf().get("dfs.datanode.data.dir") + "," + Joiner.on((String)",").join((Iterable)newDirs);
        try {
            dn.reconfigurePropertyImpl("dfs.datanode.data.dir", newValue);
            org.junit.jupiter.api.Assertions.fail((String)"Expect to throw IOException.");
        }
        catch (ReconfigurationException e) {
            String errorMessage = e.getCause().getMessage();
            messages = errorMessage.split("\\r?\\n");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((String[])messages).length);
            Assertions.assertThat((String)messages[0]).contains(new CharSequence[]{"new_vol0"});
            Assertions.assertThat((String)messages[1]).contains(new CharSequence[]{"new_vol2"});
        }
        FsDatasetSpi dataset = dn.getFSDataset();
        FsDatasetSpi.FsVolumeReferences volumes = dataset.getFsVolumeReferences();
        messages = null;
        try {
            for (FsVolumeSpi volume : volumes) {
                Assertions.assertThat((String)new File(volume.getStorageLocation().getUri()).toString()).isNotIn(new Object[]{newDirs.get(0), newDirs.get(2)});
            }
        }
        catch (Throwable throwable) {
            messages = throwable;
            throw throwable;
        }
        finally {
            if (volumes != null) {
                if (messages != null) {
                    try {
                        volumes.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)messages).addSuppressed(throwable);
                    }
                } else {
                    volumes.close();
                }
            }
        }
        DataStorage storage = dn.getStorage();
        for (int i = 0; i < storage.getNumStorageDirs(); ++i) {
            Storage.StorageDirectory sd = storage.getStorageDir(i);
            Assertions.assertThat((String)sd.getRoot().toString()).isNotIn(new Object[]{newDirs.get(0), newDirs.get(2)});
        }
        String[] effectiveVolumes = dn.getConf().get("dfs.datanode.data.dir").split(",");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)effectiveVolumes.length);
        for (String ev : effectiveVolumes) {
            Assertions.assertThat((String)new File(StorageLocation.parse((String)ev).getUri()).getCanonicalPath()).isNotIn(new Object[]{newDirs.get(0), newDirs.get(2)});
        }
    }

    private static void assertFileLocksReleased(Collection<String> dirs) throws IOException {
        for (String dir : dirs) {
            try {
                FsDatasetTestUtil.assertFileLockReleased(dir);
            }
            catch (IOException e) {
                LOG.warn("{}", (Throwable)e);
            }
        }
    }

    @Test
    @Timeout(value=600L)
    public void testRemoveVolumeBeingWritten() throws InterruptedException, TimeoutException, ReconfigurationException, IOException, BrokenBarrierException {
        for (int i = 0; i < 3; ++i) {
            this.testRemoveVolumeBeingWrittenForDatanode(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRemoveVolumeBeingWrittenForDatanode(int dataNodeIdx) throws IOException, ReconfigurationException, TimeoutException, InterruptedException, BrokenBarrierException {
        Serializable exceptions;
        Object block;
        this.startDFSCluster(1, 4);
        int REPLICATION = 3;
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSClient client = fs.getClient();
        Path testFile = new Path("/test");
        FSDataOutputStream out = fs.create(testFile, (short)3);
        Random rb = new Random(0L);
        byte[] writeBuf = new byte[256];
        rb.nextBytes(writeBuf);
        out.write(writeBuf);
        out.hflush();
        BlockLocation[] blocks = fs.getFileBlockLocations(testFile, 0L, 512L);
        String[] dataNodeNames = blocks[0].getNames();
        String dataNodeName = dataNodeNames[dataNodeIdx];
        int xferPort = Integer.parseInt(dataNodeName.split(":")[1]);
        DataNode dn = null;
        for (DataNode dataNode : this.cluster.getDataNodes()) {
            if (dataNode.getXferPort() != xferPort) continue;
            dn = dataNode;
            break;
        }
        org.junit.jupiter.api.Assertions.assertNotNull(dn);
        final CyclicBarrier barrier = new CyclicBarrier(4);
        final AtomicBoolean done = new AtomicBoolean(false);
        DataNodeFaultInjector newInjector = new DataNodeFaultInjector(){

            public void logDelaySendingAckToUpstream(String upstreamAddr, long delayMs) throws IOException {
                try {
                    if (!done.get()) {
                        barrier.await();
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new IOException(e);
                }
            }
        };
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        try {
            DataNodeFaultInjector.set((DataNodeFaultInjector)newInjector);
            List<String> oldDirs = TestDataNodeHotSwapVolumes.getDataDirs(dn);
            LocatedBlocks lbs = client.getLocatedBlocks("/test", 0L);
            block = lbs.get(0);
            FsVolumeImpl volume = (FsVolumeImpl)dn.getFSDataset().getVolume(block.getBlock());
            String newDirs = oldDirs.stream().filter(d -> !d.contains(volume.getStorageLocation().toString())).collect(Collectors.joining(","));
            exceptions = new ArrayList();
            DataNode dataNode = dn;
            CyclicBarrier reconfigBarrier = new CyclicBarrier(2);
            Thread reconfigThread = new Thread(() -> {
                try {
                    reconfigBarrier.await();
                    barrier.await();
                    ((AbstractStringAssert)Assertions.assertThat((String)dataNode.reconfigurePropertyImpl("dfs.datanode.data.dir", newDirs)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dataNode.getConf().get("dfs.datanode.data.dir"));
                    done.set(true);
                }
                catch (InterruptedException | BrokenBarrierException | ReconfigurationException e) {
                    exceptions.add(new IOException(e));
                }
            });
            reconfigThread.start();
            rb.nextBytes(writeBuf);
            out.write(writeBuf);
            reconfigBarrier.await();
            out.hflush();
            out.close();
            reconfigThread.join();
            if (!exceptions.isEmpty()) {
                throw MultipleIOException.createIOException(exceptions);
            }
        }
        finally {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
        FsDatasetSpi fsDatasetSpi = dn.getFSDataset();
        FsDatasetSpi.FsVolumeReferences fsVolumeReferences = fsDatasetSpi.getFsVolumeReferences();
        block = null;
        try {
            for (int i = 0; i < fsVolumeReferences.size(); ++i) {
                System.out.println("Vol: " + fsVolumeReferences.get(i).getBaseURI().toString());
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)fsVolumeReferences.size(), (String)"Volume remove wasn't successful.");
        }
        catch (Throwable i) {
            block = i;
            throw i;
        }
        finally {
            if (fsVolumeReferences != null) {
                if (block != null) {
                    try {
                        fsVolumeReferences.close();
                    }
                    catch (Throwable i) {
                        ((Throwable)block).addSuppressed(i);
                    }
                } else {
                    fsVolumeReferences.close();
                }
            }
        }
        DFSTestUtil.waitReplication((FileSystem)fs, testFile, (short)3);
        byte[] content = DFSTestUtil.readFileBuffer((FileSystem)fs, testFile);
        org.junit.jupiter.api.Assertions.assertEquals((int)512, (int)content.length);
        for (int i = 0; i < 10; ++i) {
            Path file = new Path("/after-" + i);
            FSDataOutputStream fout = fs.create(file, (short)3);
            exceptions = null;
            try {
                rb.nextBytes(writeBuf);
                fout.write(writeBuf);
                continue;
            }
            catch (Throwable dataNode) {
                exceptions = dataNode;
                throw dataNode;
            }
            finally {
                if (fout != null) {
                    if (exceptions != null) {
                        try {
                            fout.close();
                        }
                        catch (Throwable dataNode) {
                            ((Throwable)exceptions).addSuppressed(dataNode);
                        }
                    } else {
                        fout.close();
                    }
                }
            }
        }
        try (FsDatasetSpi.FsVolumeReferences fsVolumeReferences2 = fsDatasetSpi.getFsVolumeReferences();){
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)fsVolumeReferences2.size(), (String)"Volume remove wasn't successful.");
            FsVolumeSpi volume = fsVolumeReferences2.get(0);
            String bpid = this.cluster.getNamesystem().getBlockPoolId();
            FsVolumeSpi.BlockIterator blkIter = volume.newBlockIterator(bpid, "test");
            int blockCount = 0;
            while (!blkIter.atEnd()) {
                blkIter.nextBlock();
                ++blockCount;
            }
            org.junit.jupiter.api.Assertions.assertTrue((blockCount > 1 ? 1 : 0) != 0, (String)String.format("DataNode(%d) should have more than 1 blocks", dataNodeIdx));
        }
    }

    @Test
    @Timeout(value=60L)
    public void testAddBackRemovedVolume() throws IOException, TimeoutException, InterruptedException, ReconfigurationException {
        this.startDFSCluster(1, 2);
        this.createFile(new Path("/test"), 32);
        DataNode dn = this.cluster.getDataNodes().get(0);
        Configuration conf = dn.getConf();
        String oldDataDir = conf.get("dfs.datanode.data.dir");
        String keepDataDir = oldDataDir.split(",")[0];
        String removeDataDir = oldDataDir.split(",")[1];
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", keepDataDir)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
        for (int i = 0; i < this.cluster.getNumNameNodes(); ++i) {
            String bpid = this.cluster.getNamesystem(i).getBlockPoolId();
            BlockPoolSliceStorage bpsStorage = dn.getStorage().getBPStorage(bpid);
            for (int j = 0; j < bpsStorage.getNumStorageDirs(); ++j) {
                Storage.StorageDirectory sd = bpsStorage.getStorageDir(j);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)sd.getRoot().getAbsolutePath().startsWith(new File(removeDataDir).getAbsolutePath()));
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)dn.getStorage().getBPStorage(bpid).getNumStorageDirs(), (int)1);
        }
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", oldDataDir)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
    }

    @Test
    @Timeout(value=60L)
    public void testDirectlyReloadAfterCheckDiskError() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.startDFSCluster(1, 2);
        this.createFile(new Path("/test"), 32, (short)2);
        DataNode dn = this.cluster.getDataNodes().get(0);
        String oldDataDir = dn.getConf().get("dfs.datanode.data.dir");
        File dirToFail = this.cluster.getInstanceStorageDir(0, 0);
        FsVolumeImpl failedVolume = DataNodeTestUtils.getVolume(dn, dirToFail);
        org.junit.jupiter.api.Assertions.assertTrue((failedVolume != null ? 1 : 0) != 0, (String)("No FsVolume was found for " + dirToFail));
        long used = failedVolume.getDfsUsed();
        DataNodeTestUtils.injectDataDirFailure(dirToFail);
        DataNodeTestUtils.waitForDiskError(dn, (FsVolumeSpi)failedVolume);
        this.createFile(new Path("/test1"), 32, (short)2);
        org.junit.jupiter.api.Assertions.assertEquals((long)used, (long)failedVolume.getDfsUsed());
        DataNodeTestUtils.restoreDataDirFromFailure(dirToFail);
        LOG.info("reconfiguring DN ");
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", oldDataDir)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
        this.createFile(new Path("/test2"), 32, (short)2);
        FsVolumeImpl restoredVolume = DataNodeTestUtils.getVolume(dn, dirToFail);
        org.junit.jupiter.api.Assertions.assertTrue((restoredVolume != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((restoredVolume != failedVolume ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((restoredVolume.getDfsUsed() > used ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=100L)
    public void testFullBlockReportAfterRemovingVolumes() throws IOException, ReconfigurationException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 512L);
        conf.setLong("dfs.blockreport.intervalMsec", 10800000L);
        conf.setLong("dfs.heartbeat.interval", 1080L);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        this.cluster.waitActive();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeProtocolClientSideTranslatorPB spy = InternalDataNodeTestUtils.spyOnBposToNN(dn, this.cluster.getNameNode());
        File dataDirToKeep = this.cluster.getInstanceStorageDir(0, 0);
        ((AbstractStringAssert)Assertions.assertThat((String)dn.reconfigurePropertyImpl("dfs.datanode.data.dir", dataDirToKeep.toString())).as("DN did not update its own config", new Object[0])).isEqualTo((Object)dn.getConf().get("dfs.datanode.data.dir"));
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((long)60000L).times(1))).blockReport((DatanodeRegistration)ArgumentMatchers.any(DatanodeRegistration.class), ArgumentMatchers.anyString(), (StorageBlockReport[])ArgumentMatchers.any(StorageBlockReport[].class), (BlockReportContext)ArgumentMatchers.any(BlockReportContext.class));
    }

    @Test
    @Timeout(value=60L)
    public void testAddVolumeWithVolumeOnSameMount() throws IOException {
        this.shutdown();
        this.conf = this.setConfiguration(new Configuration());
        this.conf.setBoolean("dfs.datanode.same-disk-tiering.enabled", true);
        this.conf.setDouble("dfs.datanode.reserve-for-archive.default.percentage", 0.4);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storagesPerDatanode(2).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        DataNode dn = this.cluster.getDataNodes().get(0);
        List<String> dirs = TestDataNodeHotSwapVolumes.getDataDirs(dn);
        dirs.add(dirs.get(1) + "_2");
        try {
            String[] newVal = dn.reconfigurePropertyImpl("dfs.datanode.data.dir", String.join((CharSequence)",", dirs)).split(",");
            org.junit.jupiter.api.Assertions.fail((String)"Adding mount should fail.");
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getCause().getLocalizedMessage().contains("already has volume"));
        }
    }
}

