/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDataNodeExit {
    private static final long WAIT_TIME_IN_MILLIS = 10L;
    Configuration conf;
    MiniDFSCluster cluster = null;

    @BeforeEach
    public void setUp() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.blocksize", 100);
        this.conf.setInt("dfs.bytes-per-checksum", 100);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(3)).build();
        for (int i = 0; i < 3; ++i) {
            this.cluster.waitActive(i);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void stopBPServiceThreads(int numStopThreads, DataNode dn) throws Exception {
        List bpoList = dn.getAllBpOs();
        int expected = dn.getBpOsCount() - numStopThreads;
        int index = numStopThreads - 1;
        while (index >= 0) {
            ((BPOfferService)bpoList.get(index--)).stop();
        }
        for (int iterations = 3000; dn.getBpOsCount() != expected && iterations > 0; --iterations) {
            Thread.sleep(10L);
        }
        Assertions.assertEquals((int)expected, (int)dn.getBpOsCount(), (String)"Mismatch in number of BPServices running");
    }

    @Test
    public void testBPServiceState() {
        ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
        for (DataNode dataNode : dataNodes) {
            List bposList = dataNode.getAllBpOs();
            for (BPOfferService bpOfferService : bposList) {
                Assertions.assertTrue((boolean)bpOfferService.isAlive());
            }
        }
    }

    @Test
    public void testBPServiceExit() throws Exception {
        DataNode dn = this.cluster.getDataNodes().get(0);
        this.stopBPServiceThreads(1, dn);
        Assertions.assertTrue((boolean)dn.isDatanodeUp(), (String)"DataNode should not exit");
        this.stopBPServiceThreads(2, dn);
        Assertions.assertFalse((boolean)dn.isDatanodeUp(), (String)"DataNode should exit");
    }

    @Test
    public void testSendOOBToPeers() throws Exception {
        DataNode dn = this.cluster.getDataNodes().get(0);
        DataXceiverServer spyXserver = (DataXceiverServer)Mockito.spy((Object)dn.getXferServer());
        NullPointerException npe = new NullPointerException();
        ((DataXceiverServer)Mockito.doThrow((Throwable[])new Throwable[]{npe}).when((Object)spyXserver)).sendOOBToPeers();
        dn.xserver = spyXserver;
        try {
            dn.shutdown();
        }
        catch (Exception e) {
            Assertions.fail((String)("DataNode shutdown should not have thrown exception " + e));
        }
    }
}

