/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.TestBlockRecovery;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.TestName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBlockRecovery2 {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockRecovery2.class);
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private DataNode dn;
    private Configuration conf;
    private boolean tearDownDone;
    private static final String CLUSTER_ID = "testClusterID";
    private static final String POOL_ID = "BP-TEST";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    @RegisterExtension
    public TestName methodName = new TestName();

    @BeforeEach
    public void startUp() throws IOException {
        this.tearDownDone = false;
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.datanode.data.dir", DATA_DIR);
        this.conf.set("dfs.datanode.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        this.conf.setInt("ipc.client.connect.max.retries", 0);
        FileSystem.setDefaultUri((Configuration)this.conf, (String)("hdfs://" + NN_ADDR.getHostName() + ":" + NN_ADDR.getPort()));
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        File dataDir = new File(DATA_DIR);
        FileUtil.fullyDelete((File)dataDir);
        dataDir.mkdirs();
        StorageLocation location = StorageLocation.parse((String)dataDir.getPath());
        locations.add(location);
        final DatanodeProtocolClientSideTranslatorPB namenode = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer(invocation -> (DatanodeRegistration)invocation.getArguments()[0]).when((Object)namenode)).registerDatanode((DatanodeRegistration)Mockito.any(DatanodeRegistration.class));
        Mockito.when((Object)namenode.versionRequest()).thenReturn((Object)new NamespaceInfo(1, CLUSTER_ID, POOL_ID, 1L));
        Mockito.when((Object)namenode.sendHeartbeat((DatanodeRegistration)Mockito.any(), (StorageReport[])Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(), (SlowDiskReports)Mockito.any())).thenReturn((Object)new HeartbeatResponse(new DatanodeCommand[0], new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L), null, ThreadLocalRandom.current().nextLong() | 1L));
        this.dn = new DataNode(this.conf, locations, null, null){

            DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
                Assertions.assertEquals((Object)NN_ADDR, (Object)nnAddr);
                return namenode;
            }
        };
        ((BPOfferService)this.dn.getAllBpOs().get(0)).triggerHeartbeatForTests();
        this.waitForActiveNN();
    }

    private void waitForActiveNN() {
        try {
            GenericTestUtils.waitFor(() -> ((BPOfferService)this.dn.getAllBpOs().get(0)).getActiveNN() != null, (long)1000L, (long)15000L);
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to get active NN", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn("InterruptedException while waiting to see active NN", (Throwable)e);
        }
        Assertions.assertNotNull((Object)((BPOfferService)this.dn.getAllBpOs().get(0)).getActiveNN(), (String)"Failed to get ActiveNN");
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (!this.tearDownDone && this.dn != null) {
            try {
                this.dn.shutdown();
            }
            catch (Exception e) {
                LOG.error("Cannot close: ", (Throwable)e);
            }
            finally {
                File dir = new File(DATA_DIR);
                if (dir.exists()) {
                    Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)dir), (String)"Cannot delete data-node dirs");
                }
            }
            this.tearDownDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testRaceBetweenReplicaRecoveryAndFinalizeBlock() throws Exception {
        this.tearDown();
        HdfsConfiguration configuration = new HdfsConfiguration();
        configuration.setLong("dfs.datanode.xceiver.stop.timeout.millis", 5000L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)configuration).numDataNodes(1).build();
        try {
            cluster.waitClusterUp();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/test");
            FSDataOutputStream out = fs.create(path);
            out.writeBytes("data");
            out.hsync();
            List<LocatedBlock> blocks = DFSTestUtil.getAllBlocks(fs.open(path));
            LocatedBlock block = blocks.get(0);
            DataNode dataNode = cluster.getDataNodes().get(0);
            AtomicBoolean recoveryInitResult = new AtomicBoolean(true);
            Thread recoveryThread = new Thread(() -> {
                try {
                    DatanodeInfoWithStorage[] locations = block.getLocations();
                    BlockRecoveryCommand.RecoveringBlock recoveringBlock = new BlockRecoveryCommand.RecoveringBlock(block.getBlock(), (DatanodeInfo[])locations, block.getBlock().getGenerationStamp() + 1L);
                    Thread.sleep(2000L);
                    dataNode.initReplicaRecovery(recoveringBlock);
                }
                catch (Exception e) {
                    LOG.error("Something went wrong.", (Throwable)e);
                    recoveryInitResult.set(false);
                }
            });
            recoveryThread.start();
            try {
                out.close();
            }
            catch (IOException e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("are bad. Aborting..."), (String)"Writing should fail");
            }
            finally {
                recoveryThread.join();
            }
            Assertions.assertTrue((boolean)recoveryInitResult.get(), (String)"Recovery should be initiated successfully");
            dataNode.updateReplicaUnderRecovery(block.getBlock(), block.getBlock().getGenerationStamp() + 1L, block.getBlock().getBlockId(), block.getBlockSize());
        }
        finally {
            if (null != cluster) {
                cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=300L)
    public void testRecoveryTimeout() throws Exception {
        this.tearDown();
        final Random r = new Random();
        GenericTestUtils.SleepAnswer delayer = new GenericTestUtils.SleepAnswer(3000){
            private final AtomicBoolean callRealMethod;
            {
                super(x0);
                this.callRealMethod = new AtomicBoolean();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object answer(InvocationOnMock invocation) throws Throwable {
                boolean interrupted = false;
                try {
                    Thread.sleep(r.nextInt(3000) + 6000);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                try {
                    if (this.callRealMethod.get()) {
                        Object object = invocation.callRealMethod();
                        return object;
                    }
                    this.callRealMethod.set(true);
                    Object var3_5 = null;
                    return var3_5;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        TestBlockRecovery.testRecoveryWithDatanodeDelayed(delayer);
    }

    @Test
    @Timeout(value=300L)
    public void testRecoverySlowerThanHeartbeat() throws Exception {
        this.tearDown();
        GenericTestUtils.SleepAnswer delayer = new GenericTestUtils.SleepAnswer(3000, 6000);
        TestBlockRecovery.testRecoveryWithDatanodeDelayed(delayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testEcRecoverBlocks() throws Throwable {
        this.tearDown();
        ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(8).build();
        try {
            cluster.waitActive();
            NamenodeProtocols preSpyNN = cluster.getNameNodeRpc();
            NamenodeProtocols spyNN = (NamenodeProtocols)Mockito.spy((Object)preSpyNN);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
            ((NamenodeProtocols)Mockito.doAnswer((Answer)delayer).when((Object)spyNN)).complete(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (ExtendedBlock)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
            String topDir = "/myDir";
            DFSClient client = new DFSClient(null, (ClientProtocol)spyNN, this.conf, null);
            Path file = new Path(topDir + "/testECLeaseRecover");
            client.mkdirs(topDir, null, false);
            client.enableErasureCodingPolicy(ecPolicy.getName());
            client.setErasureCodingPolicy(topDir, ecPolicy.getName());
            OutputStream stm = client.create(file.toString(), true);
            AppendTestUtil.write(stm, 0, 0x500000);
            AtomicReference err = new AtomicReference();
            Thread t = new Thread(() -> {
                try {
                    stm.close();
                }
                catch (Throwable t1) {
                    err.set(t1);
                }
            });
            t.start();
            delayer.waitForCall();
            GenericTestUtils.waitFor(() -> {
                try {
                    return client.getNamenode().recoverLease(file.toString(), client.getClientName());
                }
                catch (IOException e) {
                    return false;
                }
            }, (long)5000L, (long)24000L);
            delayer.proceed();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testRecoveryWillIgnoreMinReplication() throws Exception {
        this.tearDown();
        int blockSize = 4096;
        int numReplicas = 3;
        String filename = "/testIgnoreMinReplication";
        Path filePath = new Path("/testIgnoreMinReplication");
        HdfsConfiguration configuration = new HdfsConfiguration();
        configuration.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        configuration.setInt("dfs.namenode.replication.min", 2);
        configuration.setLong("dfs.blocksize", 4096L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)configuration).numDataNodes(5).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            FSNamesystem fsn = cluster.getNamesystem();
            FSDataOutputStream out = dfs.create(filePath, (short)3);
            out.write(AppendTestUtil.randomBytes(0L, 4096));
            out.hsync();
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), (Configuration)configuration);
            LocatedBlock blk = dfsClient.getNamenode().getBlockLocations("/testIgnoreMinReplication", 0L, 4096L).getLastLocatedBlock();
            List<DatanodeInfoWithStorage> dataNodes = Arrays.asList(blk.getLocations());
            Assertions.assertEquals((int)dataNodes.size(), (int)3);
            for (DatanodeInfo datanodeInfo : dataNodes.subList(0, 2)) {
                cluster.stopDataNode(datanodeInfo.getName());
            }
            GenericTestUtils.waitFor(() -> fsn.getNumDeadDataNodes() == 2, (long)300L, (long)300000L);
            cluster.setLeasePeriod(100L, 100L);
            GenericTestUtils.waitFor(() -> {
                try {
                    return dfs.isFileClosed(filePath);
                }
                catch (IOException e) {
                    LOG.info("Something went wrong.", (Throwable)e);
                    return false;
                }
            }, (long)300L, (long)300000L);
            DFSTestUtil.waitForReplication(cluster, DFSTestUtil.getFirstBlock((FileSystem)dfs, filePath), 1, 3, 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)LOG, (Level)Level.TRACE);
    }
}

