/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.BlockAlias;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.impl.LevelDBFileRegionAliasMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLevelDBFileRegionAliasMap {
    private static final String BPID = "BPID-0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadBack() throws Exception {
        File dbFile = Files.createTempDirectory("fileregionformat", new FileAttribute[0]).toFile();
        try {
            LevelDBFileRegionAliasMap frf = new LevelDBFileRegionAliasMap();
            LevelDBFileRegionAliasMap.LevelDBOptions opts = new LevelDBFileRegionAliasMap.LevelDBOptions().filename(dbFile.getAbsolutePath());
            BlockAliasMap.Writer writer = frf.getWriter((BlockAliasMap.Writer.Options)opts, BPID);
            FileRegion fr = new FileRegion(1L, new Path("/file"), 1L, 1L, 1L);
            writer.store((BlockAlias)fr);
            writer.close();
            BlockAliasMap.Reader reader = frf.getReader((BlockAliasMap.Reader.Options)opts, BPID);
            FileRegion fr2 = (FileRegion)reader.resolve(new Block(1L, 1L, 1L)).get();
            Assertions.assertEquals((Object)fr, (Object)fr2);
            reader.close();
        }
        finally {
            dbFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterate() throws Exception {
        FileRegion[] regions = new FileRegion[]{new FileRegion(1L, new Path("/file1"), 0L, 1024L, 1L), new FileRegion(2L, new Path("/file1"), 1024L, 1024L, 1L), new FileRegion(3L, new Path("/file1"), 2048L, 1024L, 1L), new FileRegion(4L, new Path("/file2"), 0L, 1024L, 1L), new FileRegion(5L, new Path("/file2"), 1024L, 1024L, 1L), new FileRegion(6L, new Path("/file2"), 2048L, 1024L, 1L), new FileRegion(7L, new Path("/file2"), 3072L, 1024L, 1L), new FileRegion(8L, new Path("/file3"), 0L, 1024L, 1L), new FileRegion(9L, new Path("/file4"), 0L, 1024L, 1L), new FileRegion(10L, new Path("/file5"), 0L, 1024L, 1L)};
        File dbFile = Files.createTempDirectory("fileregionformat", new FileAttribute[0]).toFile();
        try {
            LevelDBFileRegionAliasMap frf = new LevelDBFileRegionAliasMap();
            LevelDBFileRegionAliasMap.LevelDBOptions opts = new LevelDBFileRegionAliasMap.LevelDBOptions().filename(dbFile.getAbsolutePath());
            BlockAliasMap.Writer writer = frf.getWriter((BlockAliasMap.Writer.Options)opts, BPID);
            for (FileRegion fr : regions) {
                writer.store((BlockAlias)fr);
            }
            writer.close();
            BlockAliasMap.Reader reader = frf.getReader((BlockAliasMap.Reader.Options)opts, BPID);
            Iterator it = reader.iterator();
            int last = -1;
            int count = 0;
            while (it.hasNext()) {
                FileRegion fr = (FileRegion)it.next();
                int blockId = (int)fr.getBlock().getBlockId();
                Assertions.assertEquals((Object)regions[blockId - 1], (Object)fr);
                Assertions.assertNotEquals((int)blockId, (int)last);
                last = blockId;
                ++count;
            }
            Assertions.assertEquals((int)count, (int)10);
            reader.close();
        }
        finally {
            dbFile.delete();
        }
    }
}

