/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReportLeaseManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSortLocatedStripedBlock {
    static final Logger LOG = LoggerFactory.getLogger(TestSortLocatedStripedBlock.class);
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final int groupSize = this.dataBlocks + this.parityBlocks;
    static DatanodeManager dm;
    static final long STALE_INTERVAL = 1800000L;

    @BeforeAll
    public static void setup() throws IOException {
        dm = TestSortLocatedStripedBlock.mockDatanodeManager();
    }

    @Test
    @Timeout(value=10L)
    public void testWithMultipleDecommnDatanodes() {
        LOG.info("Starting test testSortWithMultipleDecommnDatanodes");
        int lbsCount = 2;
        ArrayList<Integer> decommnNodeIndices = new ArrayList<Integer>();
        decommnNodeIndices.add(0);
        decommnNodeIndices.add(1);
        decommnNodeIndices.add(7);
        decommnNodeIndices.add(8);
        ArrayList<Integer> targetNodeIndices = new ArrayList<Integer>();
        targetNodeIndices.addAll(decommnNodeIndices);
        HashMap<Integer, List<String>> decommissionedNodes = new HashMap<Integer, List<String>>(lbsCount * decommnNodeIndices.size());
        List<LocatedBlock> lbs = this.createLocatedStripedBlocks(lbsCount, this.dataBlocks, this.parityBlocks, decommnNodeIndices, targetNodeIndices, decommissionedNodes);
        ArrayList<HashMap<DatanodeInfo, Byte>> locToIndexList = new ArrayList<HashMap<DatanodeInfo, Byte>>();
        ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>> locToTokenList = new ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>>();
        this.prepareBlockIndexAndTokenList(lbs, locToIndexList, locToTokenList);
        dm.sortLocatedBlocks(null, lbs);
        this.assertDecommnNodePosition(this.groupSize, decommissionedNodes, lbs);
        this.assertBlockIndexAndTokenPosition(lbs, locToIndexList, locToTokenList);
    }

    @Test
    @Timeout(value=10L)
    public void testTwoDatanodesWithSameBlockIndexAreDecommn() {
        LOG.info("Starting test testTwoDatanodesWithSameBlockIndexAreDecommn");
        int lbsCount = 2;
        ArrayList<Integer> decommnNodeIndices = new ArrayList<Integer>();
        decommnNodeIndices.add(0);
        decommnNodeIndices.add(1);
        decommnNodeIndices.add(4);
        decommnNodeIndices.add(5);
        decommnNodeIndices.add(1);
        ArrayList<Integer> targetNodeIndices = new ArrayList<Integer>();
        targetNodeIndices.addAll(decommnNodeIndices);
        HashMap<Integer, List<String>> decommissionedNodes = new HashMap<Integer, List<String>>(lbsCount * decommnNodeIndices.size());
        List<LocatedBlock> lbs = this.createLocatedStripedBlocks(lbsCount, this.dataBlocks, this.parityBlocks, decommnNodeIndices, targetNodeIndices, decommissionedNodes);
        ArrayList<HashMap<DatanodeInfo, Byte>> locToIndexList = new ArrayList<HashMap<DatanodeInfo, Byte>>();
        ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>> locToTokenList = new ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>>();
        this.prepareBlockIndexAndTokenList(lbs, locToIndexList, locToTokenList);
        dm.sortLocatedBlocks(null, lbs);
        this.assertDecommnNodePosition(this.groupSize, decommissionedNodes, lbs);
        this.assertBlockIndexAndTokenPosition(lbs, locToIndexList, locToTokenList);
    }

    @Test
    @Timeout(value=10L)
    public void testSmallerThanOneStripeWithMultpleDecommnNodes() throws Exception {
        LOG.info("Starting test testSmallerThanOneStripeWithDecommn");
        int lbsCount = 2;
        ArrayList<Integer> decommnNodeIndices = new ArrayList<Integer>();
        decommnNodeIndices.add(0);
        decommnNodeIndices.add(2);
        decommnNodeIndices.add(2);
        ArrayList<Integer> targetNodeIndices = new ArrayList<Integer>();
        targetNodeIndices.addAll(decommnNodeIndices);
        HashMap<Integer, List<String>> decommissionedNodes = new HashMap<Integer, List<String>>(lbsCount * decommnNodeIndices.size());
        int dataBlksNum = this.dataBlocks - 2;
        List<LocatedBlock> lbs = this.createLocatedStripedBlocks(lbsCount, dataBlksNum, this.parityBlocks, decommnNodeIndices, targetNodeIndices, decommissionedNodes);
        ArrayList<HashMap<DatanodeInfo, Byte>> locToIndexList = new ArrayList<HashMap<DatanodeInfo, Byte>>();
        ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>> locToTokenList = new ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>>();
        this.prepareBlockIndexAndTokenList(lbs, locToIndexList, locToTokenList);
        dm.sortLocatedBlocks(null, lbs);
        int blkGrpWidth = dataBlksNum + this.parityBlocks;
        this.assertDecommnNodePosition(blkGrpWidth, decommissionedNodes, lbs);
        this.assertBlockIndexAndTokenPosition(lbs, locToIndexList, locToTokenList);
    }

    @Test
    @Timeout(value=10L)
    public void testTargetDecommnDatanodeDoesntExists() {
        LOG.info("Starting test testTargetDecommnDatanodeDoesntExists");
        int lbsCount = 2;
        ArrayList<Integer> decommnNodeIndices = new ArrayList<Integer>();
        decommnNodeIndices.add(0);
        decommnNodeIndices.add(1);
        decommnNodeIndices.add(2);
        decommnNodeIndices.add(4);
        decommnNodeIndices.add(5);
        ArrayList<Integer> targetNodeIndices = new ArrayList<Integer>();
        targetNodeIndices.add(0);
        targetNodeIndices.add(2);
        targetNodeIndices.add(4);
        HashMap<Integer, List<String>> decommissionedNodes = new HashMap<Integer, List<String>>(lbsCount * decommnNodeIndices.size());
        List<LocatedBlock> lbs = this.createLocatedStripedBlocks(lbsCount, this.dataBlocks, this.parityBlocks, decommnNodeIndices, targetNodeIndices, decommissionedNodes);
        ArrayList<HashMap<DatanodeInfo, Byte>> locToIndexList = new ArrayList<HashMap<DatanodeInfo, Byte>>();
        ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>> locToTokenList = new ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>>();
        this.prepareBlockIndexAndTokenList(lbs, locToIndexList, locToTokenList);
        dm.sortLocatedBlocks(null, lbs);
        int blkGrpWidth = this.dataBlocks + this.parityBlocks - 2;
        this.assertDecommnNodePosition(blkGrpWidth, decommissionedNodes, lbs);
        this.assertBlockIndexAndTokenPosition(lbs, locToIndexList, locToTokenList);
    }

    @Test
    @Timeout(value=10L)
    public void testWithMultipleInServiceAndDecommnDatanodes() {
        LOG.info("Starting test testWithMultipleInServiceAndDecommnDatanodes");
        int lbsCount = 2;
        ArrayList<Integer> decommnNodeIndices = new ArrayList<Integer>();
        decommnNodeIndices.add(0);
        decommnNodeIndices.add(1);
        decommnNodeIndices.add(7);
        decommnNodeIndices.add(8);
        ArrayList<Integer> targetNodeIndices = new ArrayList<Integer>();
        targetNodeIndices.addAll(decommnNodeIndices);
        targetNodeIndices.add(1);
        HashMap<Integer, List<String>> decommissionedNodes = new HashMap<Integer, List<String>>(lbsCount * decommnNodeIndices.size());
        List<LocatedBlock> lbs = this.createLocatedStripedBlocks(lbsCount, this.dataBlocks, this.parityBlocks, decommnNodeIndices, targetNodeIndices, decommissionedNodes);
        ArrayList<DatanodeInfoWithStorage> staleDns = new ArrayList<DatanodeInfoWithStorage>();
        for (LocatedBlock lb : lbs) {
            DatanodeInfoWithStorage[] locations = lb.getLocations();
            DatanodeInfoWithStorage staleDn = locations[locations.length - 1];
            staleDn.setLastUpdateMonotonic(Time.monotonicNow() - 3600000L);
            staleDns.add(staleDn);
        }
        ArrayList<HashMap<DatanodeInfo, Byte>> locToIndexList = new ArrayList<HashMap<DatanodeInfo, Byte>>();
        ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>> locToTokenList = new ArrayList<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>>();
        this.prepareBlockIndexAndTokenList(lbs, locToIndexList, locToTokenList);
        dm.sortLocatedBlocks(null, lbs);
        this.assertDecommnNodePosition(this.groupSize + 1, decommissionedNodes, lbs);
        this.assertBlockIndexAndTokenPosition(lbs, locToIndexList, locToTokenList);
        for (LocatedBlock lb : lbs) {
            byte[] blockIndices = ((LocatedStripedBlock)lb).getBlockIndices();
            Assertions.assertEquals((int)1, (int)blockIndices[9], (String)"Failed to move stale node to bottom!");
            DatanodeInfoWithStorage[] locations = lb.getLocations();
            Assertions.assertEquals(staleDns.remove(0), (Object)locations[9], (String)"Failed to move stale dn after normal one!");
        }
    }

    private void assertDecommnNodePosition(int blkGrpWidth, HashMap<Integer, List<String>> decommissionedNodes, List<LocatedBlock> lbs) {
        for (int i = 0; i < lbs.size(); ++i) {
            LocatedBlock blk = lbs.get(i);
            DatanodeInfoWithStorage[] nodes = blk.getLocations();
            List<String> decommissionedNodeList = decommissionedNodes.get(i);
            for (int j = 0; j < nodes.length; ++j) {
                DatanodeInfoWithStorage dnInfo = nodes[j];
                LOG.info("Block Locations size={}, locs={}, j=", new Object[]{nodes.length, dnInfo.toString(), j});
                if (j < blkGrpWidth) {
                    Assertions.assertEquals((Object)DatanodeInfo.AdminStates.NORMAL, (Object)dnInfo.getAdminState(), (String)"Node shouldn't be decommissioned");
                    continue;
                }
                Assertions.assertTrue((boolean)decommissionedNodeList.contains(dnInfo.getXferAddr()), (String)("For block " + blk.getBlock() + " decommissioned node " + dnInfo + " is not last node in list: " + j + "th index of " + nodes.length));
                Assertions.assertEquals((Object)DatanodeInfo.AdminStates.DECOMMISSIONED, (Object)dnInfo.getAdminState(), (String)"Node should be decommissioned");
            }
        }
    }

    private List<LocatedBlock> createLocatedStripedBlocks(int blkGrpCount, int dataNumBlk, int numParityBlk, List<Integer> decommnNodeIndices, List<Integer> targetNodeIndices, HashMap<Integer, List<String>> decommissionedNodes) {
        ArrayList<LocatedBlock> lbs = new ArrayList<LocatedBlock>(blkGrpCount);
        for (int i = 0; i < blkGrpCount; ++i) {
            ArrayList<String> decommNodeInfo = new ArrayList<String>();
            decommissionedNodes.put(new Integer(i), decommNodeInfo);
            ArrayList<Integer> dummyDecommnNodeIndices = new ArrayList<Integer>();
            dummyDecommnNodeIndices.addAll(decommnNodeIndices);
            LocatedStripedBlock lsb = this.createEachLocatedBlock(dataNumBlk, numParityBlk, dummyDecommnNodeIndices, targetNodeIndices, decommNodeInfo);
            lbs.add((LocatedBlock)lsb);
        }
        return lbs;
    }

    private LocatedStripedBlock createEachLocatedBlock(int numDataBlk, int numParityBlk, List<Integer> decommnNodeIndices, List<Integer> targetNodeIndices, ArrayList<String> decommNodeInfo) {
        int index;
        long blockGroupID = Long.MIN_VALUE;
        int totalDns = numDataBlk + numParityBlk + targetNodeIndices.size();
        DatanodeInfo[] locs = new DatanodeInfo[totalDns];
        String[] storageIDs = new String[totalDns];
        StorageType[] storageTypes = new StorageType[totalDns];
        byte[] blkIndices = new byte[totalDns];
        for (index = 0; index < numDataBlk; ++index) {
            blkIndices[index] = (byte)index;
            locs[index] = DFSTestUtil.getLocalDatanodeInfo(blkIndices[index]);
            locs[index].setLastUpdateMonotonic(Time.monotonicNow());
            storageIDs[index] = locs[index].getDatanodeUuid();
            storageTypes[index] = StorageType.DISK;
            if (!decommnNodeIndices.contains(index)) continue;
            locs[index].setDecommissioned();
            decommNodeInfo.add(locs[index].toString());
            decommnNodeIndices.remove(new Integer(index));
        }
        index = this.dataBlocks;
        int j = numDataBlk;
        while (j < numDataBlk + numParityBlk) {
            blkIndices[j] = (byte)index;
            locs[j] = DFSTestUtil.getLocalDatanodeInfo(blkIndices[j]);
            locs[j].setLastUpdateMonotonic(Time.monotonicNow());
            storageIDs[j] = locs[j].getDatanodeUuid();
            storageTypes[j] = StorageType.DISK;
            if (decommnNodeIndices.contains(index)) {
                locs[j].setDecommissioned();
                decommNodeInfo.add(locs[j].toString());
                decommnNodeIndices.remove(new Integer(index));
            }
            ++j;
            ++index;
        }
        int basePortValue = this.dataBlocks + this.parityBlocks;
        index = numDataBlk + numParityBlk;
        int i = 0;
        while (i < targetNodeIndices.size()) {
            int blkIndexPos = targetNodeIndices.get(i);
            blkIndices[index] = (byte)blkIndexPos;
            locs[index] = DFSTestUtil.getLocalDatanodeInfo(basePortValue++);
            locs[index].setLastUpdateMonotonic(Time.monotonicNow());
            storageIDs[index] = locs[index].getDatanodeUuid();
            storageTypes[index] = StorageType.DISK;
            if (decommnNodeIndices.contains(blkIndexPos)) {
                locs[index].setDecommissioned();
                decommNodeInfo.add(locs[index].toString());
                decommnNodeIndices.remove(new Integer(blkIndexPos));
            }
            ++i;
            ++index;
        }
        return new LocatedStripedBlock(new ExtendedBlock("pool", Long.MIN_VALUE, (long)this.cellSize, 1001L), locs, storageIDs, storageTypes, blkIndices, 0L, false, null);
    }

    private static DatanodeManager mockDatanodeManager() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        conf.setLong("dfs.namenode.stale.datanode.interval", 1800000L);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        BlockManager bm = (BlockManager)Mockito.mock(BlockManager.class);
        BlockReportLeaseManager blm = new BlockReportLeaseManager(conf);
        Mockito.when((Object)bm.getBlockReportLeaseManager()).thenReturn((Object)blm);
        DatanodeManager dm = new DatanodeManager(bm, (Namesystem)fsn, conf);
        return dm;
    }

    private void prepareBlockIndexAndTokenList(List<LocatedBlock> lbs, List<HashMap<DatanodeInfo, Byte>> locToIndexList, List<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>> locToTokenList) {
        for (LocatedBlock lb : lbs) {
            HashMap<DatanodeInfoWithStorage, Byte> locToIndex = new HashMap<DatanodeInfoWithStorage, Byte>();
            locToIndexList.add(locToIndex);
            HashMap<DatanodeInfoWithStorage, Token> locToToken = new HashMap<DatanodeInfoWithStorage, Token>();
            locToTokenList.add(locToToken);
            DatanodeInfoWithStorage[] di = lb.getLocations();
            LocatedStripedBlock stripedBlk = (LocatedStripedBlock)lb;
            for (int i = 0; i < di.length; ++i) {
                locToIndex.put(di[i], stripedBlk.getBlockIndices()[i]);
                locToToken.put(di[i], stripedBlk.getBlockTokens()[i]);
            }
        }
    }

    private void assertBlockIndexAndTokenPosition(List<LocatedBlock> lbs, List<HashMap<DatanodeInfo, Byte>> locToIndexList, List<HashMap<DatanodeInfo, Token<BlockTokenIdentifier>>> locToTokenList) {
        for (int i = 0; i < lbs.size(); ++i) {
            LocatedBlock lb = lbs.get(i);
            LocatedStripedBlock stripedBlk = (LocatedStripedBlock)lb;
            HashMap<DatanodeInfo, Byte> locToIndex = locToIndexList.get(i);
            HashMap<DatanodeInfo, Token<BlockTokenIdentifier>> locToToken = locToTokenList.get(i);
            DatanodeInfoWithStorage[] di = lb.getLocations();
            for (int j = 0; j < di.length; ++j) {
                Assertions.assertEquals((byte)locToIndex.get(di[j]), (byte)stripedBlk.getBlockIndices()[j], (String)"Block index value mismatches after sorting");
                Assertions.assertEquals(locToToken.get(di[j]), (Object)stripedBlk.getBlockTokens()[j], (String)"Block token value mismatches after sorting");
            }
        }
    }
}

