/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.SequentialBlockGroupIdGenerator;
import org.apache.hadoop.hdfs.server.blockmanagement.SequentialBlockIdGenerator;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSequentialBlockGroupId {
    private static final Logger LOG = LoggerFactory.getLogger((String)"TestSequentialBlockGroupId");
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final short REPLICATION = 1;
    private final long SEED = 0L;
    private final int dataBlocks = this.ecPolicy.getNumDataUnits();
    private final int parityBlocks = this.ecPolicy.getNumParityUnits();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripesPerBlock = 2;
    private final int blockSize = this.cellSize * 2;
    private final int numDNs = this.dataBlocks + this.parityBlocks + 2;
    private final int blockGrpCount = 4;
    private final int fileLen = this.blockSize * this.dataBlocks * 4;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private SequentialBlockGroupIdGenerator blockGrpIdGenerator;
    private Path ecDir = new Path("/ecDir");

    @BeforeEach
    public void setup() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 1);
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.numDNs).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        this.blockGrpIdGenerator = this.cluster.getNamesystem().getBlockManager().getBlockIdManager().getBlockGroupIdGenerator();
        this.fs.mkdirs(this.ecDir);
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/ecDir", StripedFileTestUtil.getDefaultECPolicy().getName());
    }

    @AfterEach
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testBlockGroupIdGeneration() throws IOException {
        long blockGroupIdInitialValue = this.blockGrpIdGenerator.getCurrentValue();
        Path path = new Path(this.ecDir, "testBlockGrpIdGeneration.dat");
        DFSTestUtil.createFile((FileSystem)this.fs, path, this.cellSize, this.fileLen, this.blockSize, (short)1, 0L);
        List<LocatedBlock> blocks = DFSTestUtil.getAllBlocks((FileSystem)this.fs, path);
        ((AbstractIntegerAssert)Assertions.assertThat((int)blocks.size()).as("Wrong BlockGrps", new Object[0])).isEqualTo(4);
        this.blockGrpIdGenerator.setCurrentValue(blockGroupIdInitialValue);
        for (int i = 0; i < blocks.size(); ++i) {
            this.blockGrpIdGenerator.skipTo((this.blockGrpIdGenerator.getCurrentValue() & 0xFFFFFFFFFFFFFFF0L) + 16L);
            long nextBlockExpectedId = this.blockGrpIdGenerator.getCurrentValue();
            long nextBlockGrpId = blocks.get(i).getBlock().getBlockId();
            LOG.info("BlockGrp" + i + " id is " + nextBlockGrpId);
            ((AbstractLongAssert)Assertions.assertThat((long)nextBlockGrpId).as("BlockGrpId mismatches!", new Object[0])).isEqualTo(nextBlockExpectedId);
        }
        this.cluster.getNamesystem().getBlockManager().clear();
        ((AbstractLongAssert)Assertions.assertThat((long)this.blockGrpIdGenerator.getCurrentValue()).as("BlockGrpId mismatches!", new Object[0])).isEqualTo(Long.MIN_VALUE);
    }

    @Test
    @Timeout(value=60L)
    public void testTriggerBlockGroupIdCollision() throws IOException {
        long blockGroupIdInitialValue = this.blockGrpIdGenerator.getCurrentValue();
        Path path1 = new Path(this.ecDir, "testBlockGrpIdCollisionDetection_file1.dat");
        DFSTestUtil.createFile((FileSystem)this.fs, path1, this.cellSize, this.fileLen, this.blockSize, (short)1, 0L);
        List<LocatedBlock> blocks1 = DFSTestUtil.getAllBlocks((FileSystem)this.fs, path1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)blocks1.size()).as("Wrong BlockGrps", new Object[0])).isEqualTo(4);
        this.blockGrpIdGenerator.setCurrentValue(blockGroupIdInitialValue);
        Path path2 = new Path(this.ecDir, "testBlockGrpIdCollisionDetection_file2.dat");
        DFSTestUtil.createFile((FileSystem)this.fs, path2, this.cellSize, this.fileLen, this.blockSize, (short)1, 0L);
        List<LocatedBlock> blocks2 = DFSTestUtil.getAllBlocks((FileSystem)this.fs, path2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)blocks2.size()).as("Wrong BlockGrps", new Object[0])).isEqualTo(4);
        for (LocatedBlock locBlock1 : blocks1) {
            long blockId1 = locBlock1.getBlock().getBlockId();
            for (LocatedBlock locBlock2 : blocks2) {
                long blockId2 = locBlock2.getBlock().getBlockId();
                ((AbstractLongAssert)Assertions.assertThat((long)blockId1).as("BlockGrpId mismatches!", new Object[0])).isNotEqualTo(blockId2);
            }
        }
    }

    @Test
    @Timeout(value=60L)
    public void testTriggerBlockGroupIdCollisionWithLegacyBlockId() throws Exception {
        long blockGroupIdInitialValue = this.blockGrpIdGenerator.getCurrentValue();
        this.blockGrpIdGenerator.skipTo((this.blockGrpIdGenerator.getCurrentValue() & 0xFFFFFFFFFFFFFFF0L) + 16L);
        final long curBlockGroupIdValue = this.blockGrpIdGenerator.getCurrentValue();
        FSNamesystem fsn = this.cluster.getNamesystem();
        SequentialBlockIdGenerator blockIdGenerator = (SequentialBlockIdGenerator)Mockito.spy((Object)fsn.getBlockManager().getBlockIdManager().getBlockIdGenerator());
        Whitebox.setInternalState((Object)fsn.getBlockManager().getBlockIdManager(), (String)"blockIdGenerator", (Object)blockIdGenerator);
        SequentialBlockIdGenerator spySequentialBlockIdGenerator = new SequentialBlockIdGenerator(null){

            public long nextValue() {
                return curBlockGroupIdValue;
            }
        };
        GenericTestUtils.DelegateAnswer delegator = new GenericTestUtils.DelegateAnswer((Object)spySequentialBlockIdGenerator);
        ((SequentialBlockIdGenerator)Mockito.doAnswer((Answer)delegator).when((Object)blockIdGenerator)).nextValue();
        Path path1 = new Path("/testCollisionWithLegacyBlock_file1.dat");
        DFSTestUtil.createFile((FileSystem)this.fs, path1, 1024L, (short)1, 0L);
        List<LocatedBlock> contiguousBlocks = DFSTestUtil.getAllBlocks((FileSystem)this.fs, path1);
        Assertions.assertThat((int)contiguousBlocks.size()).isEqualTo(1);
        org.junit.jupiter.api.Assertions.assertEquals((long)curBlockGroupIdValue, (long)contiguousBlocks.get(0).getBlock().getBlockId(), (String)"Unexpected BlockId!");
        this.blockGrpIdGenerator.setCurrentValue(blockGroupIdInitialValue);
        Path path2 = new Path(this.ecDir, "testCollisionWithLegacyBlock_file2.dat");
        DFSTestUtil.createFile((FileSystem)this.fs, path2, this.cellSize, this.fileLen, this.blockSize, (short)1, 0L);
        List<LocatedBlock> blocks2 = DFSTestUtil.getAllBlocks((FileSystem)this.fs, path2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)blocks2.size()).as("Wrong BlockGrps", new Object[0])).isEqualTo(4);
        for (LocatedBlock locBlock1 : contiguousBlocks) {
            long blockId1 = locBlock1.getBlock().getBlockId();
            for (LocatedBlock locBlock2 : blocks2) {
                long blockId2 = locBlock2.getBlock().getBlockId();
                ((AbstractLongAssert)Assertions.assertThat((long)blockId1).as("BlockGrpId mismatches!", new Object[0])).isNotEqualTo(blockId2);
            }
        }
    }
}

