/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.Node;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReplicationPolicyWithUpgradeDomain
extends BaseReplicationPolicyTest {
    public TestReplicationPolicyWithUpgradeDomain() {
        this.blockPlacementPolicy = BlockPlacementPolicyWithUpgradeDomain.class.getName();
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d1/r2", "/d1/r3", "/d1/r3", "/d1/r3"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        DatanodeDescriptor[] dataNodes = DFSTestUtil.toDatanodeDescriptor(this.storages);
        for (int i = 0; i < dataNodes.length; ++i) {
            String upgradeDomain = Integer.toString(i % 3 + 1);
            dataNodes[i].setUpgradeDomain(upgradeDomain);
        }
        return dataNodes;
    }

    @Test
    public void testChooseTarget1() throws Exception {
        this.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 4, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        targets = this.chooseTarget(2);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        Assertions.assertEquals((int)this.getUpgradeDomains(targets).size(), (int)2);
        targets = this.chooseTarget(3);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        Assertions.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assertions.assertEquals((int)this.getUpgradeDomains(targets).size(), (int)3);
        targets = this.chooseTarget(4);
        Assertions.assertEquals((int)targets.length, (int)4);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
        Assertions.assertEquals((int)this.getUpgradeDomains(targets).size(), (int)3);
        this.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 0, 0);
    }

    @Test
    public void testChooseTargetWithExcludeNodes() throws Exception {
        HashSet<Node> excludedNodes = new HashSet<Node>();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[4]);
        DatanodeStorageInfo[] targets = this.chooseTarget(3, chosenNodes, excludedNodes);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertEquals((int)this.getRacks(targets).size(), (int)2);
        Assertions.assertEquals((int)this.getUpgradeDomains(targets).size(), (int)3);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[4]);
        excludedNodes.add((Node)this.dataNodes[8]);
        targets = this.chooseTarget(3, chosenNodes, excludedNodes);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertEquals((int)this.getRacks(targets).size(), (int)2);
        Assertions.assertEquals((int)this.getUpgradeDomains(targets).size(), (int)3);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[4]);
        excludedNodes.add((Node)this.dataNodes[5]);
        excludedNodes.add((Node)this.dataNodes[8]);
        targets = this.chooseTarget(3, chosenNodes, excludedNodes);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertEquals((Object)this.storages[2], (Object)targets[1]);
        Assertions.assertEquals((Object)this.storages[7], (Object)targets[2]);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[4]);
        targets = this.chooseTarget(4, chosenNodes, excludedNodes);
        Assertions.assertEquals((int)targets.length, (int)4);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertTrue((this.getRacks(targets).size() >= 2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)this.getUpgradeDomains(targets).size(), (int)3);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[4]);
        excludedNodes.add((Node)this.dataNodes[8]);
        targets = this.chooseTarget(4, chosenNodes, excludedNodes);
        Assertions.assertEquals((int)targets.length, (int)4);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertTrue((this.getRacks(targets).size() >= 2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)this.getUpgradeDomains(targets).size(), (int)3);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[1]);
        chosenNodes.add(this.storages[2]);
        targets = this.replicator.chooseTarget("/dummyfile.txt", 1, (Node)this.dataNodes[0], chosenNodes, true, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
        System.out.println("targets=" + Arrays.asList(targets));
        Assertions.assertEquals((int)2, (int)targets.length);
    }

    @Test
    public void testChooseTargetWithoutEnoughReplica() throws Exception {
        HashSet<Node> excludedNodes = new HashSet<Node>();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[4]);
        excludedNodes.add((Node)this.dataNodes[5]);
        excludedNodes.add((Node)this.dataNodes[7]);
        excludedNodes.add((Node)this.dataNodes[8]);
        DatanodeStorageInfo[] targets = this.chooseTarget(3, chosenNodes, excludedNodes);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertTrue((targets[1].equals((Object)this.storages[1]) || targets[1].equals((Object)this.storages[2]) ? 1 : 0) != 0);
    }

    @Test
    public void testVerifyBlockPlacement() throws Exception {
        ExtendedBlock b = new ExtendedBlock("fake-pool", new Block(12345L));
        ArrayList<DatanodeStorageInfo> set = new ArrayList<DatanodeStorageInfo>();
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[4]);
        LocatedBlock locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        BlockPlacementStatus status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[5]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertTrue((boolean)status.isPlacementPolicySatisfied());
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[2]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        Assertions.assertFalse((boolean)status.getErrorDescription().contains("upgrade domain"));
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[5]);
        set.add(this.storages[8]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("upgrade domain"));
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[4]);
        set.add(this.storages[8]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertTrue((boolean)status.isPlacementPolicySatisfied());
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[5]);
        set.add(this.storages[8]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertTrue((boolean)status.isPlacementPolicySatisfied());
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[3]);
        set.add(this.storages[5]);
        set.add(this.storages[8]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
    }

    @Test
    public void testChooseReplicasToDelete() throws Exception {
        ArrayList<DatanodeStorageInfo> nonExcess = new ArrayList<DatanodeStorageInfo>();
        nonExcess.add(this.storages[0]);
        nonExcess.add(this.storages[1]);
        nonExcess.add(this.storages[2]);
        nonExcess.add(this.storages[3]);
        BlockStoragePolicySuite POLICY_SUITE = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy storagePolicy = POLICY_SUITE.getDefaultPolicy();
        DatanodeDescriptor delHintNode = this.storages[0].getDatanodeDescriptor();
        List excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        List excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[3].getDatanodeDescriptor(), delHintNode);
        Assertions.assertTrue((excessReplicas.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)excessReplicas.contains(this.storages[0]));
        delHintNode = this.storages[1].getDatanodeDescriptor();
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[3].getDatanodeDescriptor(), delHintNode);
        Assertions.assertTrue((excessReplicas.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)excessReplicas.contains(this.storages[0]));
        nonExcess.clear();
        nonExcess.add(this.storages[0]);
        nonExcess.add(this.storages[1]);
        nonExcess.add(this.storages[4]);
        nonExcess.add(this.storages[8]);
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[8].getDatanodeDescriptor(), null);
        Assertions.assertTrue((excessReplicas.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)excessReplicas.contains(this.storages[1]));
        nonExcess.clear();
        nonExcess.add(this.storages[0]);
        nonExcess.add(this.storages[1]);
        nonExcess.add(this.storages[4]);
        nonExcess.add(this.storages[5]);
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[8].getDatanodeDescriptor(), null);
        Assertions.assertTrue((excessReplicas.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((excessReplicas.contains(this.storages[1]) || excessReplicas.contains(this.storages[4]) ? 1 : 0) != 0);
        nonExcess.clear();
        nonExcess.add(this.storages[0]);
        nonExcess.add(this.storages[1]);
        nonExcess.add(this.storages[2]);
        nonExcess.add(this.storages[3]);
        DatanodeStorageInfo excessStorage = DFSTestUtil.createDatanodeStorageInfo("Storage-excess-ID", "localhost", delHintNode.getNetworkLocation(), "foo.com", StorageType.ARCHIVE, delHintNode.getUpgradeDomain());
        nonExcess.add(excessStorage);
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[3].getDatanodeDescriptor(), null);
        Assertions.assertTrue((excessReplicas.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)excessReplicas.contains(this.storages[0]));
        Assertions.assertTrue((boolean)excessReplicas.contains(excessStorage));
        DatanodeStorageInfo excessSSD = DFSTestUtil.createDatanodeStorageInfo("Storage-excess-SSD-ID", "localhost", this.storages[0].getDatanodeDescriptor().getNetworkLocation(), "foo.com", StorageType.SSD, null);
        DatanodeStorageInfo[] ssds = new DatanodeStorageInfo[]{excessSSD};
        DatanodeDescriptor[] ssdNodes = DFSTestUtil.toDatanodeDescriptor(ssds);
        ssdNodes[0].setUpgradeDomain(Integer.toString(4));
        nonExcess.clear();
        nonExcess.add(excessSSD);
        nonExcess.add(this.storages[3]);
        nonExcess.add(this.storages[7]);
        nonExcess.add(this.storages[8]);
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[3].getDatanodeDescriptor(), this.storages[7].getDatanodeDescriptor());
        Assertions.assertEquals((int)1, (int)excessReplicas.size());
        Assertions.assertTrue((boolean)excessReplicas.contains(excessSSD));
    }

    @Test
    public void testIsMovable() throws Exception {
        ArrayList<DatanodeDescriptor> candidates = new ArrayList<DatanodeDescriptor>();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[1]);
        candidates.add(this.dataNodes[2]);
        candidates.add(this.dataNodes[3]);
        Assertions.assertTrue((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[3]));
        candidates.clear();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[1]);
        candidates.add(this.dataNodes[2]);
        candidates.add(this.dataNodes[4]);
        Assertions.assertFalse((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[4]));
        candidates.clear();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[4]);
        candidates.add(this.dataNodes[5]);
        candidates.add(this.dataNodes[6]);
        Assertions.assertTrue((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[6]));
        candidates.clear();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[1]);
        candidates.add(this.dataNodes[3]);
        candidates.add(this.dataNodes[4]);
        Assertions.assertTrue((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[4]));
        candidates.clear();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[3]);
        candidates.add(this.dataNodes[4]);
        candidates.add(this.dataNodes[6]);
        Assertions.assertFalse((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[4], (DatanodeInfo)this.dataNodes[6]));
    }

    private Set<String> getUpgradeDomains(DatanodeStorageInfo[] nodes) {
        HashSet<String> upgradeDomains = new HashSet<String>();
        for (DatanodeStorageInfo node : nodes) {
            upgradeDomains.add(node.getDatanodeDescriptor().getUpgradeDomain());
        }
        return upgradeDomains;
    }

    private Set<String> getRacks(DatanodeStorageInfo[] nodes) {
        HashSet<String> racks = new HashSet<String>();
        for (DatanodeStorageInfo node : nodes) {
            String rack = node.getDatanodeDescriptor().getNetworkLocation();
            racks.add(rack);
        }
        return racks;
    }
}

