/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestRedundancyMonitor {
    private static final String FILENAME = "/dummyfile.txt";

    @Test
    public void testChooseTargetWhenAllDataNodesStop() throws Throwable {
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] hosts = new String[]{"host1", "host2"};
        String[] racks = new String[]{"/d1/r1", "/d1/r1"};
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)conf).racks(racks).hosts(hosts).numDataNodes(hosts.length).build();){
            NetworkTopology spyClusterMap;
            miniCluster.waitActive();
            FSNamesystem fsn = miniCluster.getNamesystem();
            BlockManager blockManager = fsn.getBlockManager();
            BlockPlacementPolicyDefault replicator = (BlockPlacementPolicyDefault)blockManager.getBlockPlacementPolicy();
            Set dns = blockManager.getDatanodeManager().getDatanodes();
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(BlockPlacementPolicyDefault.LOG);
            NetworkTopology clusterMap = replicator.clusterMap;
            replicator.clusterMap = spyClusterMap = (NetworkTopology)Mockito.spy((Object)clusterMap);
            ((NetworkTopology)Mockito.doAnswer((Answer)delayer).when((Object)spyClusterMap)).getNumOfNonEmptyRacks();
            ExecutorService pool = Executors.newFixedThreadPool(2);
            Future<Void> chooseTargetFuture = pool.submit(() -> {
                replicator.chooseTarget(FILENAME, 2, (Node)dns.iterator().next(), new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
                return null;
            });
            delayer.waitForCall();
            Future<Void> stopDatanodesFuture = pool.submit(() -> {
                for (DatanodeDescriptor dn : dns) {
                    spyClusterMap.remove((Node)dn);
                }
                return null;
            });
            stopDatanodesFuture.get();
            delayer.proceed();
            try {
                chooseTargetFuture.get();
            }
            catch (ExecutionException ee) {
                throw ee.getCause();
            }
        }
    }
}

