/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.ProvidedStorageMap;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.TestProvidedImpl;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.util.RwLock;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestProvidedStorageMap {
    private Configuration conf;
    private BlockManager bm;
    private RwLock nameSystemLock;
    private String providedStorageID;
    private String blockPoolID;

    @BeforeEach
    public void setup() {
        this.providedStorageID = "DS-PROVIDED";
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.provided.storage.id", this.providedStorageID);
        this.conf.setBoolean("dfs.namenode.provided.enabled", true);
        this.conf.setClass("dfs.provided.aliasmap.class", TestProvidedImpl.TestFileRegionBlockAliasMap.class, BlockAliasMap.class);
        this.blockPoolID = "BP-12344-10.1.1.2-12344";
        this.bm = (BlockManager)Mockito.mock(BlockManager.class);
        Mockito.when((Object)this.bm.getBlockPoolId()).thenReturn((Object)this.blockPoolID);
        this.nameSystemLock = (RwLock)Mockito.mock(RwLock.class);
    }

    private DatanodeDescriptor createDatanodeDescriptor(int port) {
        return DFSTestUtil.getDatanodeDescriptor("127.0.0.1", port, "defaultRack", "localhost");
    }

    @Test
    public void testProvidedStorageMap() throws IOException {
        ProvidedStorageMap providedMap = new ProvidedStorageMap(this.nameSystemLock, this.bm, this.conf);
        DatanodeStorageInfo providedMapStorage = providedMap.getProvidedStorageInfo();
        Assertions.assertNotNull((Object)providedMapStorage);
        DatanodeDescriptor dn1 = this.createDatanodeDescriptor(5000);
        DatanodeStorage dn1ProvidedStorage = new DatanodeStorage(this.providedStorageID, DatanodeStorage.State.NORMAL, StorageType.PROVIDED);
        DatanodeStorage dn1DiskStorage = new DatanodeStorage("sid-1", DatanodeStorage.State.NORMAL, StorageType.DISK);
        Mockito.when((Object)this.nameSystemLock.hasWriteLock(RwLockMode.GLOBAL)).thenReturn((Object)true);
        DatanodeStorageInfo dns1Provided = providedMap.getStorage(dn1, dn1ProvidedStorage);
        DatanodeStorageInfo dns1Disk = providedMap.getStorage(dn1, dn1DiskStorage);
        Assertions.assertTrue((dns1Provided == providedMapStorage ? 1 : 0) != 0, (String)"The provided storages should be equal");
        Assertions.assertTrue((dns1Disk == null ? 1 : 0) != 0, (String)"Disk storage has not yet been registered with block manager");
        DatanodeStorageInfo dnsDisk = new DatanodeStorageInfo(dn1, dn1DiskStorage);
        dn1.injectStorage(dnsDisk);
        Assertions.assertTrue((dnsDisk == providedMap.getStorage(dn1, dn1DiskStorage) ? 1 : 0) != 0, (String)"Disk storage must match the injected storage info");
        DatanodeDescriptor dn2 = this.createDatanodeDescriptor(5010);
        DatanodeStorage dn2ProvidedStorage = new DatanodeStorage(this.providedStorageID, DatanodeStorage.State.NORMAL, StorageType.PROVIDED);
        DatanodeStorageInfo dns2Provided = providedMap.getStorage(dn2, dn2ProvidedStorage);
        Assertions.assertTrue((dns2Provided == providedMapStorage ? 1 : 0) != 0, (String)"The provided storages should be equal");
        Assertions.assertTrue((dn2.getStorageInfo(this.providedStorageID) == providedMapStorage ? 1 : 0) != 0, (String)"The DatanodeDescriptor should contain the provided storage");
    }
}

