/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingRecoveryBlocks;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestPendingRecoveryBlocks {
    private PendingRecoveryBlocks pendingRecoveryBlocks;
    private final long recoveryTimeout = 1000L;
    private final BlockInfo blk1 = this.getBlock(1L);
    private final BlockInfo blk2 = this.getBlock(2L);
    private final BlockInfo blk3 = this.getBlock(3L);

    @BeforeEach
    public void setUp() {
        this.pendingRecoveryBlocks = (PendingRecoveryBlocks)Mockito.spy((Object)new PendingRecoveryBlocks(1000L));
    }

    BlockInfo getBlock(long blockId) {
        return new BlockInfoContiguous(new Block(blockId), 0);
    }

    @Test
    public void testAddDifferentBlocks() {
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk1));
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.isUnderRecovery(this.blk1));
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk2));
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.isUnderRecovery(this.blk2));
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk3));
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.isUnderRecovery(this.blk3));
    }

    @Test
    public void testAddAndRemoveBlocks() {
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk1));
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk2));
        this.pendingRecoveryBlocks.remove(this.blk1);
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk1));
    }

    @Test
    public void testAddBlockWithPreviousRecoveryTimedOut() {
        ((PendingRecoveryBlocks)Mockito.doReturn((Object)0L).when((Object)this.pendingRecoveryBlocks)).getTime();
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk1));
        ((PendingRecoveryBlocks)Mockito.doReturn((Object)500L).when((Object)this.pendingRecoveryBlocks)).getTime();
        Assertions.assertFalse((boolean)this.pendingRecoveryBlocks.add(this.blk1));
        ((PendingRecoveryBlocks)Mockito.doReturn((Object)2000L).when((Object)this.pendingRecoveryBlocks)).getTime();
        Assertions.assertTrue((boolean)this.pendingRecoveryBlocks.add(this.blk1));
    }
}

