/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.LowRedundancyBlocks;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;

@ParameterizedClass(name="{index}: {0}")
@MethodSource(value={"policies"})
public class TestLowRedundancyBlockQueues {
    private final ErasureCodingPolicy ecPolicy;
    private static AtomicLong mockINodeId = new AtomicLong(0L);

    public TestLowRedundancyBlockQueues(ErasureCodingPolicy policy) {
        this.ecPolicy = policy;
    }

    public static Collection<Object[]> policies() {
        return StripedFileTestUtil.getECPolicies();
    }

    private BlockInfo genBlockInfo(long id) {
        return this.genBlockInfo(id, false);
    }

    private BlockInfo genBlockInfo(long id, boolean isCorruptBlock) {
        BlockInfoContiguous bInfo = new BlockInfoContiguous(new Block(id), 3);
        if (!isCorruptBlock) {
            bInfo.setBlockCollectionId(mockINodeId.incrementAndGet());
        }
        return bInfo;
    }

    private BlockInfo genStripedBlockInfo(long id, long numBytes) {
        BlockInfoStriped sblk = new BlockInfoStriped(new Block(id), this.ecPolicy);
        sblk.setNumBytes(numBytes);
        return sblk;
    }

    private void verifyBlockStats(LowRedundancyBlocks queues, int lowRedundancyReplicaCount, int corruptReplicaCount, int corruptReplicationOneCount, int lowRedundancyStripedCount, int corruptStripedCount, int highestPriorityReplicatedBlockCount, int highestPriorityECBlockCount, int badlyDistributedBlockCount) {
        Assertions.assertEquals((long)lowRedundancyReplicaCount, (long)queues.getLowRedundancyBlocks(), (String)"Low redundancy replica count incorrect!");
        Assertions.assertEquals((long)corruptReplicaCount, (long)queues.getCorruptBlocks(), (String)"Corrupt replica count incorrect!");
        Assertions.assertEquals((long)corruptReplicationOneCount, (long)queues.getCorruptReplicationOneBlocks(), (String)"Corrupt replica one count incorrect!");
        Assertions.assertEquals((long)lowRedundancyStripedCount, (long)queues.getLowRedundancyECBlockGroups(), (String)"Low redundancy striped blocks count incorrect!");
        Assertions.assertEquals((long)corruptStripedCount, (long)queues.getCorruptECBlockGroups(), (String)"Corrupt striped blocks count incorrect!");
        Assertions.assertEquals((int)(lowRedundancyReplicaCount + lowRedundancyStripedCount), (int)queues.getLowRedundancyBlockCount(), (String)"Low Redundancy count incorrect!");
        Assertions.assertEquals((int)(lowRedundancyReplicaCount + corruptReplicaCount + lowRedundancyStripedCount + corruptStripedCount), (int)queues.size(), (String)"LowRedundancyBlocks queue size incorrect!");
        Assertions.assertEquals((long)badlyDistributedBlockCount, (long)queues.getBadlyDistributedBlocks(), (String)"Badly Distributed Blocks queue size incorrect!");
        Assertions.assertEquals((long)highestPriorityReplicatedBlockCount, (long)queues.getHighestPriorityReplicatedBlockCount(), (String)"Highest priority replicated low redundancy blocks count is incorrect!");
        Assertions.assertEquals((long)highestPriorityECBlockCount, (long)queues.getHighestPriorityECBlockCount(), (String)"Highest priority erasure coded low redundancy blocks count is incorrect!");
    }

    @Test
    public void testDeletedBlocks() throws Exception {
        int numBlocks = 5;
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        for (int ind = 0; ind < numBlocks; ++ind) {
            BlockInfo blockInfo = this.genBlockInfo(ind, ind == 0);
            queues.add(blockInfo, 2, 0, 0, 3);
        }
        List blocks = queues.chooseLowRedundancyBlocks(2, false);
        Assertions.assertEquals((int)1, (int)((List)blocks.get(2)).size());
        Assertions.assertEquals((long)1L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assertions.assertEquals((long)2L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, true);
        Assertions.assertEquals((long)3L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assertions.assertEquals((long)1L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
    }

    @Test
    public void testQueuePositionCanBeReset() throws Throwable {
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        for (int i = 0; i < 4; ++i) {
            BlockInfo block = this.genBlockInfo(i);
            queues.add(block, 2, 0, 0, 3);
        }
        List blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assertions.assertEquals((int)1, (int)((List)blocks.get(2)).size());
        Assertions.assertEquals((long)0L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assertions.assertEquals((long)1L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, true);
        Assertions.assertEquals((long)2L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
        blocks = queues.chooseLowRedundancyBlocks(1, false);
        Assertions.assertEquals((long)0L, (long)((BlockInfo)((List)blocks.get(2)).get(0)).getBlockId());
    }

    @Test
    public void testBlockPriorities() throws Throwable {
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        BlockInfo block1 = this.genBlockInfo(1L);
        BlockInfo block2 = this.genBlockInfo(2L);
        BlockInfo block_very_low_redundancy = this.genBlockInfo(3L);
        BlockInfo block_corrupt = this.genBlockInfo(4L);
        BlockInfo block_corrupt_repl_one = this.genBlockInfo(5L);
        BlockInfo blockBadlyDistributed = this.genBlockInfo(6L);
        this.assertAdded(queues, block1, 1, 0, 3);
        this.assertInLevel(queues, (Block)block1, 0);
        this.verifyBlockStats(queues, 1, 0, 0, 0, 0, 1, 0, 0);
        Assertions.assertFalse((boolean)queues.add(block1, 1, 0, 0, 3));
        this.verifyBlockStats(queues, 1, 0, 0, 0, 0, 1, 0, 0);
        this.assertAdded(queues, block2, 2, 0, 3);
        this.assertInLevel(queues, (Block)block2, 2);
        this.verifyBlockStats(queues, 2, 0, 0, 0, 0, 1, 0, 0);
        this.assertAdded(queues, block_corrupt, 0, 0, 3);
        this.assertInLevel(queues, (Block)block_corrupt, 4);
        this.verifyBlockStats(queues, 2, 1, 0, 0, 0, 1, 0, 0);
        this.assertAdded(queues, block_very_low_redundancy, 4, 0, 25);
        this.assertInLevel(queues, (Block)block_very_low_redundancy, 1);
        this.verifyBlockStats(queues, 3, 1, 0, 0, 0, 1, 0, 0);
        this.assertAdded(queues, block_corrupt_repl_one, 0, 0, 1);
        this.verifyBlockStats(queues, 3, 2, 1, 0, 0, 1, 0, 0);
        queues.update(block_corrupt_repl_one, 0, 0, 0, 3, 0, 2);
        this.verifyBlockStats(queues, 3, 2, 0, 0, 0, 1, 0, 0);
        queues.update(block_corrupt, 0, 0, 0, 1, 0, -2);
        this.verifyBlockStats(queues, 3, 2, 1, 0, 0, 1, 0, 0);
        queues.update(block_very_low_redundancy, 0, 0, 0, 1, -4, -24);
        this.verifyBlockStats(queues, 2, 3, 2, 0, 0, 1, 0, 0);
        queues.update(block1, 1, 0, 0, 1, 0, 0);
        this.verifyBlockStats(queues, 2, 3, 2, 0, 0, 0, 0, 1);
        this.assertAdded(queues, blockBadlyDistributed, 2, 0, 1);
        this.assertInLevel(queues, (Block)blockBadlyDistributed, 3);
        this.verifyBlockStats(queues, 3, 3, 2, 0, 0, 0, 0, 2);
    }

    @Test
    public void testRemoveWithWrongPriority() {
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        BlockInfo corruptBlock = this.genBlockInfo(1L);
        this.assertAdded(queues, corruptBlock, 0, 0, 3);
        this.assertInLevel(queues, (Block)corruptBlock, 4);
        this.verifyBlockStats(queues, 0, 1, 0, 0, 0, 0, 0, 0);
        queues.remove(corruptBlock, 2);
        this.verifyBlockStats(queues, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    @Test
    public void testStripedBlockPriorities() throws Throwable {
        int dataBlkNum = this.ecPolicy.getNumDataUnits();
        int parityBlkNUm = this.ecPolicy.getNumParityUnits();
        this.doTestStripedBlockPriorities(1, parityBlkNUm);
        this.doTestStripedBlockPriorities(dataBlkNum, parityBlkNUm);
    }

    private void doTestStripedBlockPriorities(int dataBlkNum, int parityBlkNum) throws Throwable {
        int groupSize = dataBlkNum + parityBlkNum;
        long numBytes = this.ecPolicy.getCellSize() * dataBlkNum;
        LowRedundancyBlocks queues = new LowRedundancyBlocks();
        int numUR = 0;
        int numCorrupt = 0;
        int i = 0;
        while (dataBlkNum + i < groupSize) {
            BlockInfo block = this.genStripedBlockInfo(-100 - 100 * i, numBytes);
            this.assertAdded(queues, block, dataBlkNum + i, 0, groupSize);
            Assertions.assertEquals((int)(++numUR), (int)queues.getLowRedundancyBlockCount());
            Assertions.assertEquals((int)(numUR + numCorrupt), (int)queues.size());
            if (i == 0) {
                this.assertInLevel(queues, (Block)block, 0);
            } else if (i * 3 < parityBlkNum + 1) {
                this.assertInLevel(queues, (Block)block, 1);
            } else {
                this.assertInLevel(queues, (Block)block, 2);
            }
            this.verifyBlockStats(queues, 0, 0, 0, numUR, 0, 0, 1, 0);
            ++i;
        }
        BlockInfo block_corrupt = this.genStripedBlockInfo(-10L, numBytes);
        Assertions.assertEquals((int)numCorrupt, (int)queues.getCorruptBlockSize());
        this.verifyBlockStats(queues, 0, 0, 0, numUR, numCorrupt, 0, 1, 0);
        this.assertAdded(queues, block_corrupt, dataBlkNum - 1, 0, groupSize);
        this.verifyBlockStats(queues, 0, 0, 0, numUR, ++numCorrupt, 0, 1, 0);
        this.assertInLevel(queues, (Block)block_corrupt, 4);
    }

    private void assertAdded(LowRedundancyBlocks queues, BlockInfo block, int curReplicas, int decommissionedReplicas, int expectedReplicas) {
        Assertions.assertTrue((boolean)queues.add(block, curReplicas, 0, decommissionedReplicas, expectedReplicas), (String)("Failed to add " + block));
    }

    private void assertInLevel(LowRedundancyBlocks queues, Block block, int level) {
        Iterator bi = queues.iterator(level);
        while (bi.hasNext()) {
            Block next = (Block)bi.next();
            if (!block.equals((Object)next)) continue;
            return;
        }
        Assertions.fail((String)("Block " + block + " not found in level " + level));
    }

    @Test
    public void testRemoveBlockInManyQueues() {
        LowRedundancyBlocks neededReconstruction = new LowRedundancyBlocks();
        BlockInfoContiguous block = new BlockInfoContiguous(new Block(), 1024);
        neededReconstruction.add((BlockInfo)block, 2, 0, 1, 3);
        neededReconstruction.add((BlockInfo)block, 0, 0, 0, 3);
        neededReconstruction.remove((BlockInfo)block, 5);
        Assertions.assertFalse((boolean)neededReconstruction.contains((BlockInfo)block), (String)"Should not contain the block.");
    }
}

