/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostSet;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.test.Whitebox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHostFileManager {
    private static InetSocketAddress entry(String e) {
        return HostFileManager.parseEntry((String)"dummy", (String)"dummy", (String)e);
    }

    @Test
    public void testDeduplication() {
        HostSet s = new HostSet();
        s.add(TestHostFileManager.entry("127.0.0.1:12345"));
        s.add(TestHostFileManager.entry("localhost:12345"));
        Assertions.assertEquals((int)1, (int)s.size());
        s.add(TestHostFileManager.entry("127.0.0.1:12345"));
        Assertions.assertEquals((int)1, (int)s.size());
        s.add(TestHostFileManager.entry("127.0.0.1:12346"));
        Assertions.assertEquals((int)2, (int)s.size());
        s.add(TestHostFileManager.entry("127.0.0.1"));
        Assertions.assertEquals((int)3, (int)s.size());
        s.add(TestHostFileManager.entry("127.0.0.10"));
        Assertions.assertEquals((int)4, (int)s.size());
    }

    @Test
    public void testRelation() {
        HostSet s = new HostSet();
        s.add(TestHostFileManager.entry("127.0.0.1:123"));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:123")));
        Assertions.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.1:12")));
        Assertions.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.1")));
        Assertions.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:12")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:123")));
        Assertions.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2")));
        Assertions.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2:123")));
        Assertions.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2")));
        Assertions.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2:123")));
        s.add(TestHostFileManager.entry("127.0.0.1"));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:123")));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:12")));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1")));
        Assertions.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:12")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:123")));
        Assertions.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2")));
        Assertions.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2:123")));
        Assertions.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2")));
        Assertions.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2:123")));
        s.add(TestHostFileManager.entry("127.0.0.2:123"));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:123")));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1:12")));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.1")));
        Assertions.assertFalse((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:12")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.1:123")));
        Assertions.assertFalse((boolean)s.match(TestHostFileManager.entry("127.0.0.2")));
        Assertions.assertTrue((boolean)s.match(TestHostFileManager.entry("127.0.0.2:123")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2")));
        Assertions.assertTrue((boolean)s.matchedBy(TestHostFileManager.entry("127.0.0.2:123")));
    }

    @Test
    public void testIncludeExcludeLists() throws IOException {
        BlockManager bm = (BlockManager)Mockito.mock(BlockManager.class);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Configuration conf = new Configuration();
        HostFileManager hm = new HostFileManager();
        HostSet includedNodes = new HostSet();
        HostSet excludedNodes = new HostSet();
        includedNodes.add(TestHostFileManager.entry("127.0.0.1:12345"));
        includedNodes.add(TestHostFileManager.entry("localhost:12345"));
        includedNodes.add(TestHostFileManager.entry("127.0.0.1:12345"));
        includedNodes.add(TestHostFileManager.entry("127.0.0.2"));
        excludedNodes.add(TestHostFileManager.entry("127.0.0.1:12346"));
        excludedNodes.add(TestHostFileManager.entry("127.0.30.1:12346"));
        Assertions.assertEquals((int)2, (int)includedNodes.size());
        Assertions.assertEquals((int)2, (int)excludedNodes.size());
        hm.refresh(includedNodes, excludedNodes);
        DatanodeManager dm = new DatanodeManager(bm, (Namesystem)fsn, conf);
        Whitebox.setInternalState((Object)dm, (String)"hostConfigManager", (Object)hm);
        Map dnMap = (Map)Whitebox.getInternalState((Object)dm, (String)"datanodeMap");
        Assertions.assertEquals((int)2, (int)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL).size());
        Assertions.assertEquals((int)2, (int)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        dnMap.put("uuid-foo", new DatanodeDescriptor(new DatanodeID("127.0.0.1", "localhost", "uuid-foo", 12345, 1020, 1021, 1022)));
        Assertions.assertEquals((int)1, (int)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        dnMap.put("uuid-bar", new DatanodeDescriptor(new DatanodeID("127.0.0.2", "127.0.0.2", "uuid-bar", 12345, 1020, 1021, 1022)));
        Assertions.assertEquals((int)0, (int)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        DatanodeDescriptor spam = new DatanodeDescriptor(new DatanodeID("127.0.0.3", "127.0.0.3", "uuid-spam", 12345, 1020, 1021, 1022));
        DFSTestUtil.setDatanodeDead((DatanodeInfo)spam);
        includedNodes.add(TestHostFileManager.entry("127.0.0.3:12345"));
        dnMap.put("uuid-spam", spam);
        Assertions.assertEquals((int)1, (int)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        dnMap.remove("uuid-spam");
        Assertions.assertEquals((int)1, (int)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
        excludedNodes.add(TestHostFileManager.entry("127.0.0.3"));
        Assertions.assertEquals((int)1, (int)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD).size());
    }
}

