/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDatanodeDescriptor {
    @Test
    public void testGetInvalidateBlocks() throws Exception {
        int MAX_BLOCKS = 10;
        int REMAINING_BLOCKS = 2;
        int MAX_LIMIT = 8;
        DatanodeDescriptor dd = DFSTestUtil.getLocalDatanodeDescriptor();
        ArrayList<Block> blockList = new ArrayList<Block>(10);
        for (int i = 0; i < 10; ++i) {
            blockList.add(new Block((long)i, 0L, 1000L));
        }
        dd.addBlocksToBeInvalidated(blockList);
        Block[] bc = dd.getInvalidateBlocks(8);
        Assertions.assertEquals((int)bc.length, (int)8);
        bc = dd.getInvalidateBlocks(8);
        Assertions.assertEquals((int)bc.length, (int)2);
    }

    @Test
    public void testBlocksCounter() throws Exception {
        DatanodeDescriptor dd = BlockManagerTestUtil.getLocalDatanodeDescriptor(true);
        Assertions.assertEquals((int)0, (int)dd.numBlocks());
        BlockInfoContiguous blk = new BlockInfoContiguous(new Block(1L), 1);
        BlockInfoContiguous blk1 = new BlockInfoContiguous(new Block(2L), 2);
        DatanodeStorageInfo[] storages = dd.getStorageInfos();
        Assertions.assertTrue((storages.length > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)DatanodeStorageInfo.AddBlockResult.ADDED, (Object)storages[0].addBlock((BlockInfo)blk));
        Assertions.assertEquals((int)1, (int)dd.numBlocks());
        Assertions.assertFalse((boolean)BlocksMap.removeBlock((DatanodeDescriptor)dd, (BlockInfo)blk1));
        Assertions.assertEquals((int)1, (int)dd.numBlocks());
        Assertions.assertNotEquals((Object)DatanodeStorageInfo.AddBlockResult.ADDED, (Object)storages[0].addBlock((BlockInfo)blk));
        Assertions.assertEquals((int)1, (int)dd.numBlocks());
        Assertions.assertEquals((Object)DatanodeStorageInfo.AddBlockResult.ADDED, (Object)storages[0].addBlock((BlockInfo)blk1));
        Assertions.assertEquals((int)2, (int)dd.numBlocks());
        Assertions.assertTrue((boolean)BlocksMap.removeBlock((DatanodeDescriptor)dd, (BlockInfo)blk));
        Assertions.assertEquals((int)1, (int)dd.numBlocks());
        Assertions.assertTrue((boolean)BlocksMap.removeBlock((DatanodeDescriptor)dd, (BlockInfo)blk1));
        Assertions.assertEquals((int)0, (int)dd.numBlocks());
    }
}

