/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeAdminMonitorBase;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatanodeAdminMonitorBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatanodeAdminMonitorBase.class);
    private static final int NUM_DATANODE = 10;
    private static final int[] UNORDERED_LAST_UPDATE_TIMES = new int[]{0, 5, 2, 11, 0, 3, 1001, 5, 1, 103};
    private static final int[] ORDERED_LAST_UPDATE_TIMES = new int[]{1001, 103, 11, 5, 5, 3, 2, 1, 0, 0};
    private static final int[] REVERSE_ORDER_LAST_UPDATE_TIMES = new int[]{0, 0, 1, 2, 3, 5, 5, 11, 103, 1001};
    private static final DatanodeDescriptor[] NODES = new DatanodeDescriptor[10];

    @Test
    public void testPendingNodesQueueOrdering() {
        PriorityQueue<DatanodeDescriptor> pendingNodes = new PriorityQueue<DatanodeDescriptor>(DatanodeAdminMonitorBase.PENDING_NODES_QUEUE_COMPARATOR);
        pendingNodes.addAll(Arrays.asList(NODES));
        for (int i = 0; i < 10; ++i) {
            DatanodeDescriptor dn = (DatanodeDescriptor)pendingNodes.poll();
            Assertions.assertNotNull((Object)dn);
            Assertions.assertEquals((long)ORDERED_LAST_UPDATE_TIMES[i], (long)dn.getLastUpdate());
        }
    }

    @Test
    public void testPendingNodesQueueReverseOrdering() {
        List<DatanodeDescriptor> nodes = Arrays.asList(NODES);
        List reverseOrderNodes = nodes.stream().sorted(DatanodeAdminMonitorBase.PENDING_NODES_QUEUE_COMPARATOR.reversed()).collect(Collectors.toList());
        Assertions.assertEquals((int)10, (int)reverseOrderNodes.size());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((long)REVERSE_ORDER_LAST_UPDATE_TIMES[i], (long)((DatanodeDescriptor)reverseOrderNodes.get(i)).getLastUpdate());
        }
    }

    static {
        for (int i = 0; i < 10; ++i) {
            TestDatanodeAdminMonitorBase.NODES[i] = new DatanodeDescriptor(DatanodeID.EMPTY_DATANODE_ID);
            NODES[i].setLastUpdate((long)UNORDERED_LAST_UPDATE_TIMES[i]);
            NODES[i].setLastUpdateMonotonic((long)UNORDERED_LAST_UPDATE_TIMES[i]);
        }
    }
}

