/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Test;

public class TestCorruptionWithFailover {
    @Test
    public void testCorruptReplicaAfterFailover() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.corrupt.block.delete.immediately.enabled", false);
        conf.setInt("dfs.client.block.write.replace-datanode-on-failure.min-replication", 2);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();){
            cluster.transitionToActive(0);
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem(0);
            FSDataOutputStream out = dfs.create(new Path("/dir/file"));
            for (int i = 0; i < 0x100000; ++i) {
                out.write(i);
            }
            out.hsync();
            MiniDFSCluster.DataNodeProperties dn = cluster.stopDataNode(0);
            for (int i = 0; i < 0x100000; ++i) {
                out.write(i);
            }
            out.close();
            BlockManager bm0 = cluster.getNamesystem(0).getBlockManager();
            BlockManager bm1 = cluster.getNamesystem(1).getBlockManager();
            bm0.getDatanodeManager().markAllDatanodesStaleAndSetKeyUpdateIfNeed();
            bm1.getDatanodeManager().markAllDatanodesStaleAndSetKeyUpdateIfNeed();
            cluster.restartDataNode(dn);
            GenericTestUtils.waitFor(() -> bm0.getCorruptBlocks() == 1L, (long)100L, (long)10000L);
            cluster.transitionToStandby(0);
            cluster.transitionToActive(1);
            cluster.waitActive(1);
            GenericTestUtils.waitFor(() -> bm1.getCorruptBlocks() == 1L, (long)100L, (long)10000L);
        }
    }
}

