/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.util.IntrusiveCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCachedBlocksList {
    public static final Logger LOG = LoggerFactory.getLogger(TestCachedBlocksList.class);

    @Test
    @Timeout(value=60L)
    public void testSingleList() {
        DatanodeDescriptor dn = new DatanodeDescriptor(new DatanodeID("127.0.0.1", "localhost", "abcd", 5000, 5001, 5002, 5003));
        CachedBlock[] blocks = new CachedBlock[]{new CachedBlock(0L, 1, true), new CachedBlock(1L, 1, true), new CachedBlock(2L, 1, true)};
        Assertions.assertTrue((!dn.getPendingCached().iterator().hasNext() ? 1 : 0) != 0, (String)"expected pending cached list to start off empty.");
        Assertions.assertTrue((!dn.getCached().iterator().hasNext() ? 1 : 0) != 0, (String)"expected cached list to start off empty.");
        Assertions.assertTrue((!dn.getPendingUncached().iterator().hasNext() ? 1 : 0) != 0, (String)"expected pending uncached list to start off empty.");
        Assertions.assertTrue((boolean)dn.getCached().add((IntrusiveCollection.Element)blocks[0]));
        Assertions.assertTrue((!dn.getPendingCached().iterator().hasNext() ? 1 : 0) != 0, (String)"expected pending cached list to still be empty.");
        Assertions.assertEquals((Object)blocks[0], dn.getCached().iterator().next(), (String)"failed to insert blocks[0]");
        Assertions.assertTrue((!dn.getPendingUncached().iterator().hasNext() ? 1 : 0) != 0, (String)"expected pending uncached list to still be empty.");
        Assertions.assertTrue((boolean)dn.getCached().add((IntrusiveCollection.Element)blocks[1]));
        Iterator iter = dn.getCached().iterator();
        Assertions.assertEquals((Object)blocks[0], iter.next());
        Assertions.assertEquals((Object)blocks[1], iter.next());
        Assertions.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)dn.getCached().addFirst((IntrusiveCollection.Element)blocks[2]));
        iter = dn.getCached().iterator();
        Assertions.assertEquals((Object)blocks[2], iter.next());
        Assertions.assertEquals((Object)blocks[0], iter.next());
        Assertions.assertEquals((Object)blocks[1], iter.next());
        Assertions.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)dn.getCached().remove((Object)blocks[0]));
        iter = dn.getCached().iterator();
        Assertions.assertEquals((Object)blocks[2], iter.next());
        Assertions.assertEquals((Object)blocks[1], iter.next());
        Assertions.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        dn.getCached().clear();
        Assertions.assertTrue((!dn.getPendingCached().iterator().hasNext() ? 1 : 0) != 0, (String)"expected cached list to be empty after clear.");
    }

    private void testAddElementsToList(DatanodeDescriptor.CachedBlocksList list, CachedBlock[] blocks) {
        Assertions.assertTrue((!list.iterator().hasNext() ? 1 : 0) != 0, (String)"expected list to start off empty.");
        for (CachedBlock block : blocks) {
            Assertions.assertTrue((boolean)list.add((IntrusiveCollection.Element)block));
        }
    }

    private void testRemoveElementsFromList(Random r, DatanodeDescriptor.CachedBlocksList list, CachedBlock[] blocks) {
        int i = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Assertions.assertEquals((Object)blocks[i], iter.next());
            ++i;
        }
        if (r.nextBoolean()) {
            LOG.info("Removing via iterator");
            iter = list.iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        } else {
            LOG.info("Removing in pseudo-random order");
            CachedBlock[] remainingBlocks = Arrays.copyOf(blocks, blocks.length);
            int removed = 0;
            while (removed < remainingBlocks.length) {
                int toRemove = r.nextInt(remainingBlocks.length);
                if (remainingBlocks[toRemove] == null) continue;
                Assertions.assertTrue((boolean)list.remove((Object)remainingBlocks[toRemove]));
                remainingBlocks[toRemove] = null;
                ++removed;
            }
        }
        Assertions.assertTrue((!list.iterator().hasNext() ? 1 : 0) != 0, (String)"expected list to be empty after everything was removed.");
    }

    @Test
    @Timeout(value=60L)
    public void testMultipleLists() {
        DatanodeDescriptor[] datanodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("127.0.0.1", "localhost", "abcd", 5000, 5001, 5002, 5003)), new DatanodeDescriptor(new DatanodeID("127.0.1.1", "localhost", "efgh", 6000, 6001, 6002, 6003))};
        DatanodeDescriptor.CachedBlocksList[] lists = new DatanodeDescriptor.CachedBlocksList[]{datanodes[0].getPendingCached(), datanodes[0].getCached(), datanodes[1].getPendingCached(), datanodes[1].getCached(), datanodes[1].getPendingUncached()};
        int NUM_BLOCKS = 8000;
        CachedBlock[] blocks = new CachedBlock[8000];
        for (int i = 0; i < 8000; ++i) {
            blocks[i] = new CachedBlock((long)i, (short)i, true);
        }
        Random r = new Random(654L);
        for (DatanodeDescriptor.CachedBlocksList list : lists) {
            this.testAddElementsToList(list, blocks);
        }
        for (DatanodeDescriptor.CachedBlocksList list : lists) {
            this.testRemoveElementsFromList(r, list, blocks);
        }
    }
}

