/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReconstructionWork;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBlocksWithNotEnoughRacks {
    public static final Logger LOG = LoggerFactory.getLogger(TestBlocksWithNotEnoughRacks.class);

    private Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 1);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("net.topology.script.file.name", "xyz");
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSufficientlyReplBlocksUsesNewRack() throws Exception {
        Configuration conf = this.getConf();
        int REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)3, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 1, 3, 0);
            String[] newRacks = new String[]{"/rack2"};
            cluster.startDataNodes(conf, 1, true, null, newRacks);
            cluster.waitActive();
            DFSTestUtil.waitForReplication(cluster, b, 2, 3, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSufficientlySingleReplBlockUsesNewRack() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 1;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 0);
            REPLICATION_FACTOR = 2;
            NameNodeAdapter.setReplication(ns, "/testFile", REPLICATION_FACTOR);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testMisReplicatedBlockUsesNewRack() throws Exception {
        Configuration conf = this.getConf();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        int replicationFactor = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack2"};
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();){
            cluster.waitActive();
            String poolId = cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration reg = InternalDataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(3), poolId);
            cluster.stopDataNode(3);
            DFSTestUtil.waitForDatanodeState(cluster, reg.getDatanodeUuid(), false, 20000);
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)3, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitReplication((FileSystem)cluster.getFileSystem(), filePath, (short)3);
            cluster.startDataNodes(conf, 1, true, null, new String[]{"/rack2"});
            cluster.waitActive();
            try {
                DFSTestUtil.waitForReplication(cluster, b, 2, 3, 0);
                Assertions.fail((String)"NameNode should not have fixed the mis-replicated blocks automatically.");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            String fsckOp = DFSTestUtil.runFsck(conf, 0, true, filePath.toString(), "-replicate");
            LOG.info("fsck response {}", (Object)fsckOp);
            Assertions.assertTrue((boolean)fsckOp.contains("/testFile:  Replica placement policy is violated"));
            Assertions.assertTrue((boolean)fsckOp.contains(" Block should be additionally replicated on 1 more rack(s). Total number of racks in the cluster: 2"));
            Assertions.assertTrue((boolean)fsckOp.contains(" Blocks queued for replication:\t1"));
            try {
                DFSTestUtil.waitForReplication(cluster, b, 2, 3, 0);
            }
            catch (TimeoutException e) {
                Assertions.fail((String)"NameNode should have fixed the mis-replicated blocks as a result of fsck command.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnderReplicatedUsesNewRacks() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack1", "/rack1"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 0);
            String[] newRacks = new String[]{"/rack2", "/rack2"};
            cluster.startDataNodes(conf, 2, true, null, newRacks);
            REPLICATION_FACTOR = 5;
            NameNodeAdapter.setReplication(ns, "/testFile", REPLICATION_FACTOR);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptBlockRereplicatedAcrossRacks() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        int fileLen = 512;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, fileLen, REPLICATION_FACTOR, 1L);
            byte[] fileContent = DFSTestUtil.readFileAsBytes((FileSystem)fs, filePath);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            int dnToCorrupt = DFSTestUtil.firstDnWithBlock(cluster, b);
            cluster.corruptReplica(dnToCorrupt, b);
            cluster.restartDataNode(dnToCorrupt);
            DFSTestUtil.waitCorruptReplicas((FileSystem)fs, ns, filePath, b, 1);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            for (int i = 0; i < racks.length; ++i) {
                byte[] blockContent = cluster.readBlockOnDataNodeAsBytes(i, b);
                if (blockContent == null || i == dnToCorrupt) continue;
                Assertions.assertArrayEquals((byte[])fileContent, (byte[])blockContent, (String)"Corrupt replica");
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReduceReplFactorRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            REPLICATION_FACTOR = 2;
            NameNodeAdapter.setReplication(ns, "/testFile", REPLICATION_FACTOR);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplDueToNodeFailRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 3;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            int idx = datanodes.size() - 1;
            DataNode dataNode = datanodes.get(idx);
            DatanodeID dnId = dataNode.getDatanodeId();
            cluster.stopDataNode(idx);
            dm.removeDatanode(dnId);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            datanodes = cluster.getDataNodes();
            idx = datanodes.size() - 1;
            dataNode = datanodes.get(idx);
            dnId = dataNode.getDatanodeId();
            cluster.stopDataNode(idx);
            dm.removeDatanode(dnId);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReduceReplFactorDueToRejoinRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        Path filePath = new Path("/testFile");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assertions.assertEquals((int)3, (int)datanodes.size());
            DataNode dataNode = datanodes.get(2);
            DatanodeID dnId = dataNode.getDatanodeId();
            cluster.stopDataNode(2);
            dm.removeDatanode(dnId);
            DFSTestUtil.waitForReplication(cluster, b, 1, REPLICATION_FACTOR, 0);
            String[] rack2 = new String[]{"/rack2"};
            cluster.startDataNodes(conf, 1, true, null, rack2);
            cluster.waitActive();
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeDecomissionRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        Path filePath = new Path("/testFile");
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/decommission");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(filePath), 0L, Long.MAX_VALUE);
            String name = locs[0].getNames()[0];
            hostsFileWriter.initExcludeHost(name);
            ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
            DFSTestUtil.waitForDecommission((FileSystem)fs, name);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeDecomissionWithOverreplicationRespectsRackPolicy() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 5;
        Path filePath = new Path("/testFile");
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/decommission");
        String[] racks = new String[]{"/rack1", "/rack2", "/rack1", "/rack1", "/rack1"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            REPLICATION_FACTOR = 2;
            fs.setReplication(filePath, REPLICATION_FACTOR);
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(filePath), 0L, Long.MAX_VALUE);
            for (String top : locs[0].getTopologyPaths()) {
                if (top.startsWith("/rack2")) continue;
                String name = top.substring("/rack1".length() + 1);
                hostsFileWriter.initExcludeHost(name);
                ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
                DFSTestUtil.waitForDecommission((FileSystem)fs, name);
                break;
            }
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
        }
        finally {
            cluster.shutdown();
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleReplicasScheduledForUpgradeDomain() throws Exception {
        Configuration conf = this.getConf();
        int replicationFactor = 3;
        Path filePath = new Path("/testFile");
        conf.set("dfs.block.replicator.classname", "org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(6).build();
        cluster.waitClusterUp();
        List<DatanodeDescriptor> dnDescriptors = this.getDnDescriptors(cluster);
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)3, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            BlockInfo storedBlock = bm.getStoredBlock(b.getLocalBlock());
            BlockReconstructionWork work = TestBlocksWithNotEnoughRacks.scheduleReconstruction(cluster.getNamesystem(), storedBlock, 2);
            Assertions.assertNull((Object)work);
            for (int i = 0; i < storedBlock.getReplication(); ++i) {
                storedBlock.getDatanode(i).setUpgradeDomain("3");
            }
            int udInd = 0;
            for (DatanodeDescriptor d : dnDescriptors) {
                if (d.getUpgradeDomain() != null) continue;
                d.setUpgradeDomain(Integer.toString(udInd % 2));
                ++udInd;
            }
            work = TestBlocksWithNotEnoughRacks.scheduleReconstruction(cluster.getNamesystem(), storedBlock, 2);
            Assertions.assertEquals((int)2, (int)work.getAdditionalReplRequired());
            bm.neededReconstruction.add(storedBlock, 3, 0, 0, 3);
            DFSTestUtil.waitForReplication(cluster, b, 1, 3, 0, 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BlockReconstructionWork scheduleReconstruction(FSNamesystem fsn, BlockInfo block, int priority) {
        fsn.writeLock(RwLockMode.BM);
        try {
            BlockReconstructionWork blockReconstructionWork = fsn.getBlockManager().scheduleReconstruction(block, priority);
            return blockReconstructionWork;
        }
        finally {
            fsn.writeUnlock(RwLockMode.BM, "scheduleReconstruction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnderReplicatedRespectsRacksAndUpgradeDomain() throws Exception {
        Configuration conf = this.getConf();
        int replicationFactor = 3;
        Path filePath = new Path("/testFile");
        conf.set("dfs.block.replicator.classname", "org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain");
        String[] racks = new String[]{"/r1", "/r1", "/r1", "/r2", "/r2", "/r2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(6).racks(racks).build();
        cluster.waitClusterUp();
        List<DatanodeDescriptor> dnDescriptors = this.getDnDescriptors(cluster);
        for (int i = 0; i < dnDescriptors.size(); ++i) {
            dnDescriptors.get(i).setUpgradeDomain(Integer.toString(i % 3));
        }
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            fs.setReplication(filePath, (short)3);
            DFSTestUtil.waitForReplication(cluster, b, 2, 3, 0, 3);
        }
        finally {
            cluster.shutdown();
        }
    }

    private List<DatanodeDescriptor> getDnDescriptors(MiniDFSCluster cluster) throws IOException {
        ArrayList<DatanodeDescriptor> dnDesc = new ArrayList<DatanodeDescriptor>();
        DatanodeManager dnManager = cluster.getNamesystem().getBlockManager().getDatanodeManager();
        for (DataNode dn : cluster.getDataNodes()) {
            DatanodeDescriptor d = dnManager.getDatanode(dn.getDatanodeUuid());
            if (d == null) {
                throw new IOException("DatanodeDescriptor not found for DN " + dn.getDatanodeUuid());
            }
            dnDesc.add(d);
        }
        return dnDesc;
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)LOG, (Level)Level.TRACE);
    }
}

