/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusWithUpgradeDomain;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBlockPlacementStatusWithUpgradeDomain {
    private Set<String> upgradeDomains;
    private BlockPlacementStatusDefault bpsd = (BlockPlacementStatusDefault)Mockito.mock(BlockPlacementStatusDefault.class);

    @BeforeEach
    public void setup() {
        this.upgradeDomains = new HashSet<String>();
        this.upgradeDomains.add("1");
        this.upgradeDomains.add("2");
        this.upgradeDomains.add("3");
        Mockito.when((Object)this.bpsd.isPlacementPolicySatisfied()).thenReturn((Object)true);
    }

    @Test
    public void testIsPolicySatisfiedParentFalse() {
        Mockito.when((Object)this.bpsd.isPlacementPolicySatisfied()).thenReturn((Object)false);
        Mockito.when((Object)this.bpsd.getAdditionalReplicasRequired()).thenReturn((Object)1);
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 3, 3);
        Assertions.assertFalse((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)1, (int)bps.getAdditionalReplicasRequired());
    }

    @Test
    public void testIsPolicySatisfiedAllEqual() {
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 3, 3);
        Assertions.assertTrue((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)0, (int)bps.getAdditionalReplicasRequired());
    }

    @Test
    public void testIsPolicySatisfiedSmallDomains() {
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 4, 3);
        Assertions.assertTrue((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)0, (int)bps.getAdditionalReplicasRequired());
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 4, 2);
        Assertions.assertTrue((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)0, (int)bps.getAdditionalReplicasRequired());
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 4, 4);
        Assertions.assertFalse((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)1, (int)bps.getAdditionalReplicasRequired());
    }

    @Test
    public void testIsPolicySatisfiedSmallReplicas() {
        this.upgradeDomains.clear();
        this.upgradeDomains.add("1");
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 1, 3);
        Assertions.assertTrue((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)0, (int)bps.getAdditionalReplicasRequired());
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 2, 3);
        Assertions.assertFalse((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)1, (int)bps.getAdditionalReplicasRequired());
        this.upgradeDomains.add("2");
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 2, 3);
        Assertions.assertTrue((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)0, (int)bps.getAdditionalReplicasRequired());
    }

    @Test
    public void testPolicyIsNotSatisfiedInsufficientDomains() {
        this.upgradeDomains.clear();
        this.upgradeDomains.add("1");
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 3, 3);
        Assertions.assertFalse((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)2, (int)bps.getAdditionalReplicasRequired());
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 2, 3);
        Assertions.assertFalse((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)1, (int)bps.getAdditionalReplicasRequired());
        this.upgradeDomains.add("2");
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 3, 3);
        Assertions.assertFalse((boolean)bps.isPlacementPolicySatisfied());
        Assertions.assertEquals((int)1, (int)bps.getAdditionalReplicasRequired());
    }
}

