/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;

@ParameterizedClass(name="{index}: {0}")
@MethodSource(value={"policies"})
@Timeout(value=300L)
public class TestBlockInfoStriped {
    private static final long BASE_ID = -1600L;
    private final Block baseBlock = new Block(-1600L);
    private final ErasureCodingPolicy testECPolicy;
    private final int totalBlocks;
    private final BlockInfoStriped info;

    public TestBlockInfoStriped(ErasureCodingPolicy policy) {
        this.testECPolicy = policy;
        this.totalBlocks = this.testECPolicy.getNumDataUnits() + this.testECPolicy.getNumParityUnits();
        this.info = new BlockInfoStriped(this.baseBlock, this.testECPolicy);
    }

    public static Collection<Object[]> policies() {
        return StripedFileTestUtil.getECPolicies();
    }

    private Block[] createReportedBlocks(int num) {
        Block[] blocks = new Block[num];
        for (int i = 0; i < num; ++i) {
            blocks[i] = new Block(-1600L + (long)i);
        }
        return blocks;
    }

    @Test
    public void testAddStorage() {
        int index;
        int i;
        DatanodeStorageInfo[] storageInfos = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks);
        Block[] blocks = this.createReportedBlocks(this.totalBlocks);
        for (i = 0; i < storageInfos.length; i += 2) {
            this.info.addStorage(storageInfos[i], blocks[i]);
            Assertions.assertEquals((int)(i / 2 + 1), (int)this.info.numNodes());
        }
        i /= 2;
        for (int j = 1; j < storageInfos.length; j += 2) {
            Assertions.assertTrue((boolean)this.info.addStorage(storageInfos[j], blocks[j]));
            Assertions.assertEquals((int)(i + (j + 1) / 2), (int)this.info.numNodes());
        }
        byte[] indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        Assertions.assertEquals((int)this.totalBlocks, (int)this.info.getCapacity());
        Assertions.assertEquals((int)this.totalBlocks, (int)indices.length);
        i = 0;
        for (DatanodeStorageInfo storage : storageInfos) {
            index = this.info.findStorageInfo(storage);
            Assertions.assertEquals((int)i++, (int)index);
            Assertions.assertEquals((int)index, (int)indices[index]);
        }
        i = 0;
        for (DatanodeStorageInfo storage : storageInfos) {
            Assertions.assertTrue((boolean)this.info.addStorage(storage, blocks[i++]));
        }
        Assertions.assertEquals((int)this.totalBlocks, (int)this.info.getCapacity());
        Assertions.assertEquals((int)this.totalBlocks, (int)this.info.numNodes());
        Assertions.assertEquals((int)this.totalBlocks, (int)indices.length);
        i = 0;
        for (DatanodeStorageInfo storage : storageInfos) {
            index = this.info.findStorageInfo(storage);
            Assertions.assertEquals((int)i++, (int)index);
            Assertions.assertEquals((int)index, (int)indices[index]);
        }
        DatanodeStorageInfo[] storageInfos2 = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks * 2);
        for (i = this.totalBlocks; i < storageInfos2.length; ++i) {
            this.info.addStorage(storageInfos2[i], blocks[i % this.totalBlocks]);
            Assertions.assertEquals((int)(i + 1), (int)this.info.getCapacity());
            Assertions.assertEquals((int)(i + 1), (int)this.info.numNodes());
            indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
            Assertions.assertEquals((int)(i + 1), (int)indices.length);
        }
        for (i = this.totalBlocks; i < storageInfos2.length; ++i) {
            int index2 = this.info.findStorageInfo(storageInfos2[i]);
            Assertions.assertEquals((int)i++, (int)index2);
            Assertions.assertEquals((int)(index2 - this.totalBlocks), (int)indices[index2]);
        }
    }

    @Test
    public void testRemoveStorage() {
        int index;
        int i;
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks);
        Block[] blocks = this.createReportedBlocks(this.totalBlocks);
        for (int i2 = 0; i2 < storages.length; ++i2) {
            this.info.addStorage(storages[i2], blocks[i2]);
        }
        this.info.removeStorage(storages[0]);
        this.info.removeStorage(storages[2]);
        Assertions.assertEquals((int)this.totalBlocks, (int)this.info.getCapacity());
        Assertions.assertEquals((int)(this.totalBlocks - 2), (int)this.info.numNodes());
        byte[] indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        for (int i3 = 0; i3 < storages.length; ++i3) {
            int index2 = this.info.findStorageInfo(storages[i3]);
            if (i3 != 0 && i3 != 2) {
                Assertions.assertEquals((int)i3, (int)index2);
                Assertions.assertEquals((int)index2, (int)indices[index2]);
                continue;
            }
            Assertions.assertEquals((int)-1, (int)index2);
            Assertions.assertEquals((int)-1, (int)indices[i3]);
        }
        DatanodeStorageInfo[] storages2 = DFSTestUtil.createDatanodeStorageInfos(this.totalBlocks * 2);
        for (int i4 = this.totalBlocks; i4 < storages2.length; ++i4) {
            this.info.addStorage(storages2[i4], blocks[i4 % this.totalBlocks]);
        }
        Assertions.assertEquals((int)(this.totalBlocks * 2 - 2), (int)this.info.numNodes());
        Assertions.assertEquals((int)(this.totalBlocks * 2 - 2), (int)this.info.getCapacity());
        indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        Assertions.assertEquals((int)(this.totalBlocks * 2 - 2), (int)indices.length);
        int j = this.totalBlocks;
        for (i = this.totalBlocks; i < storages2.length; ++i) {
            index = this.info.findStorageInfo(storages2[i]);
            if (i == this.totalBlocks || i == this.totalBlocks + 2) {
                Assertions.assertEquals((int)(i - this.totalBlocks), (int)index);
                continue;
            }
            Assertions.assertEquals((int)j++, (int)index);
        }
        for (i = 0; i < this.totalBlocks; ++i) {
            this.info.removeStorage(storages2[i + this.totalBlocks]);
        }
        Assertions.assertEquals((int)(this.totalBlocks - 2), (int)this.info.numNodes());
        Assertions.assertEquals((int)(this.totalBlocks * 2 - 2), (int)this.info.getCapacity());
        indices = (byte[])Whitebox.getInternalState((Object)this.info, (String)"indices");
        Assertions.assertEquals((int)(this.totalBlocks * 2 - 2), (int)indices.length);
        for (i = 0; i < this.totalBlocks; ++i) {
            if (i == 0 || i == 2) {
                index = this.info.findStorageInfo(storages2[i + this.totalBlocks]);
                Assertions.assertEquals((int)-1, (int)index);
                continue;
            }
            index = this.info.findStorageInfo(storages[i]);
            Assertions.assertEquals((int)i, (int)index);
        }
        for (i = this.totalBlocks; i < this.totalBlocks * 2 - 2; ++i) {
            Assertions.assertEquals((int)-1, (int)indices[i]);
            Assertions.assertNull((Object)this.info.getDatanode(i));
        }
    }

    @Test
    public void testGetBlockInfo() throws IllegalArgumentException, Exception {
        int dataBlocks = this.testECPolicy.getNumDataUnits();
        int parityBlocks = this.testECPolicy.getNumParityUnits();
        int totalSize = dataBlocks + parityBlocks;
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        Configuration conf = new Configuration();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf, builderBaseDir).numDataNodes(totalSize).build();){
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            fs.enableErasureCodingPolicy(this.testECPolicy.getName());
            fs.mkdirs(new Path("/ecDir"));
            fs.setErasureCodingPolicy(new Path("/ecDir"), this.testECPolicy.getName());
            DFSTestUtil.createFile((FileSystem)fs, new Path("/ecDir/ecFile"), fs.getDefaultBlockSize() * (long)dataBlocks, (short)1, 1024L);
            ExtendedBlock blk = DFSTestUtil.getAllBlocks((FileSystem)fs, new Path("/ecDir/ecFile")).get(0).getBlock();
            String id = "blk_" + Long.toString(blk.getBlockId());
            BlockInfo bInfo = cluster.getNameNode().getNamesystem().getBlockManager().getStoredBlock(blk.getLocalBlock());
            DatanodeStorageInfo[] dnStorageInfo = cluster.getNameNode().getNamesystem().getBlockManager().getStorages(bInfo);
            bInfo.removeStorage(dnStorageInfo[1]);
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bStream, true);
            Assertions.assertEquals((int)0, (int)ToolRunner.run((Tool)new DFSck(conf, out), (String[])new String[]{new Path("/ecDir/ecFile").toString(), "-blockId", id}));
            Assertions.assertFalse((boolean)out.toString().contains("null"));
        }
    }

    @Test
    public void testWrite() {
        long blkID = 1L;
        long numBytes = 1L;
        long generationStamp = 1L;
        ByteBuffer byteBuffer = ByteBuffer.allocate(24);
        byteBuffer.putLong(blkID).putLong(numBytes).putLong(generationStamp);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        BlockInfoStriped blk = new BlockInfoStriped(new Block(blkID, numBytes, generationStamp), this.testECPolicy);
        try {
            blk.write((DataOutput)out);
        }
        catch (Exception ex) {
            Assertions.fail((String)("testWrite error:" + ex.getMessage()));
        }
        Assertions.assertEquals((int)byteBuffer.array().length, (int)byteStream.toByteArray().length);
        Assertions.assertArrayEquals((byte[])byteBuffer.array(), (byte[])byteStream.toByteArray());
    }

    @Test
    public void testAddStorageWithReplicatedBlock() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
            BlockInfoContiguous replica = new BlockInfoContiguous(new Block(1000L), 3);
            this.info.addStorage(storage, (Block)replica);
        });
    }

    @Test
    public void testAddStorageWithDifferentBlockGroup() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
            BlockInfoStriped diffGroup = new BlockInfoStriped(new Block(-1500L), this.testECPolicy);
            this.info.addStorage(storage, (Block)diffGroup);
        });
    }
}

