/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceRackFaultTolerantBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.PathUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestAvailableSpaceRackFaultTolerantBPP {
    private static final int NUM_RACKS = 4;
    private static final int NODES_PER_RACK = 5;
    private static final int BLOCK_SIZE = 1024;
    private static final int CHOOSE_TIMES = 10000;
    private static final String FILE = "/tobers/test";
    private static final int REPLICA = 3;
    private static DatanodeStorageInfo[] storages;
    private static DatanodeDescriptor[] dataNodes;
    private static Configuration conf;
    private static NameNode namenode;
    private static BlockPlacementPolicy placementPolicy;
    private static NetworkTopology cluster;

    @BeforeAll
    public static void setupCluster() throws Exception {
        conf = new HdfsConfiguration();
        conf.setFloat("dfs.namenode.available-space-rack-fault-tolerant-block-placement-policy.balanced-space-preference-fraction", 0.6f);
        String[] racks = new String[4];
        for (int i = 0; i < 4; ++i) {
            racks[i] = "/rack" + i;
        }
        String[] owerRackOfNodes = new String[20];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                owerRackOfNodes[i * 4 + j] = racks[j];
            }
        }
        storages = DFSTestUtil.createDatanodeStorageInfos(owerRackOfNodes);
        dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = PathUtils.getTestDir(AvailableSpaceRackFaultTolerantBlockPlacementPolicy.class);
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        conf.set("dfs.block.replicator.classname", AvailableSpaceRackFaultTolerantBlockPlacementPolicy.class.getName());
        DFSTestUtil.formatNameNode(conf);
        namenode = new NameNode(conf);
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        placementPolicy = bm.getBlockPlacementPolicy();
        cluster = bm.getDatanodeManager().getNetworkTopology();
        for (int i = 0; i < 20; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
        TestAvailableSpaceRackFaultTolerantBPP.setupDataNodeCapacity();
    }

    private static void updateHeartbeatWithUsage(DatanodeDescriptor dn, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long dnCacheCapacity, long dnCacheUsed, int xceiverCount, int volFailures) {
        dn.getStorageInfos()[0].setUtilizationForTesting(capacity, dfsUsed, remaining, blockPoolUsed);
        dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), dnCacheCapacity, dnCacheUsed, xceiverCount, volFailures, null);
    }

    private static void setupDataNodeCapacity() {
        for (int i = 0; i < 20; ++i) {
            if (i % 2 == 0) {
                TestAvailableSpaceRackFaultTolerantBPP.updateHeartbeatWithUsage(dataNodes[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
                continue;
            }
            TestAvailableSpaceRackFaultTolerantBPP.updateHeartbeatWithUsage(dataNodes[i], 2048L, 1024L, 1024L, 0L, 0L, 0L, 0, 0);
        }
    }

    @Test
    public void testPolicyReplacement() {
        Assertions.assertTrue((boolean)(placementPolicy instanceof AvailableSpaceRackFaultTolerantBlockPlacementPolicy));
    }

    @Test
    public void testChooseTarget() {
        int total = 0;
        int moreRemainingNode = 0;
        for (int i = 0; i < 10000; ++i) {
            DatanodeStorageInfo[] targets = namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget(FILE, 3, null, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assertions.assertTrue((targets.length == 3 ? 1 : 0) != 0);
            for (int j = 0; j < 3; ++j) {
                ++total;
                if (!(targets[j].getDatanodeDescriptor().getRemainingPercent() > 60.0f)) continue;
                ++moreRemainingNode;
            }
        }
        Assertions.assertTrue((total == 30000 ? 1 : 0) != 0);
        double possibility = 1.0 * (double)moreRemainingNode / (double)total;
        Assertions.assertTrue((possibility > 0.52 ? 1 : 0) != 0);
        Assertions.assertTrue((possibility < 0.55 ? 1 : 0) != 0);
    }

    @Test
    public void testChooseDataNode() {
        try {
            ArrayList allNodes = new ArrayList(dataNodes.length);
            Collections.addAll(allNodes, dataNodes);
            if (placementPolicy instanceof AvailableSpaceBlockPlacementPolicy) {
                ((AvailableSpaceRackFaultTolerantBlockPlacementPolicy)placementPolicy).chooseDataNode("~", allNodes);
            }
        }
        catch (NullPointerException npe) {
            Assertions.fail((String)"NPE should not be thrown");
        }
    }

    @Test
    public void testMaxRackAllocation() {
        DatanodeStorageInfo[] targets = namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget(FILE, 3, null, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
        HashSet<String> racks = new HashSet<String>();
        for (int i = 0; i < targets.length; ++i) {
            racks.add(targets[i].getDatanodeDescriptor().getNetworkLocation());
        }
        Assertions.assertEquals((int)3, (int)racks.size());
    }

    @Test
    public void testChooseSimilarDataNode() {
        int capacity = 3;
        ArrayList allTolerateNodes = new ArrayList(capacity);
        String[] ownerRackOfTolerateNodes = new String[capacity];
        for (int i = 0; i < capacity; ++i) {
            ownerRackOfTolerateNodes[i] = "rack" + i;
        }
        DatanodeStorageInfo[] tolerateStorages = DFSTestUtil.createDatanodeStorageInfos(ownerRackOfTolerateNodes);
        DatanodeDescriptor[] tolerateDataNodes = DFSTestUtil.toDatanodeDescriptor(tolerateStorages);
        Collections.addAll(allTolerateNodes, tolerateDataNodes);
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        AvailableSpaceRackFaultTolerantBlockPlacementPolicy toleratePlacementPolicy = (AvailableSpaceRackFaultTolerantBlockPlacementPolicy)bm.getBlockPlacementPolicy();
        TestAvailableSpaceRackFaultTolerantBPP.updateHeartbeatWithUsage(tolerateDataNodes[0], 20480L, 1024L, 1024L, 0L, 0L, 0L, 0, 0);
        TestAvailableSpaceRackFaultTolerantBPP.updateHeartbeatWithUsage(tolerateDataNodes[1], 11264L, 1024L, 1024L, 0L, 0L, 0L, 0, 0);
        TestAvailableSpaceRackFaultTolerantBPP.updateHeartbeatWithUsage(tolerateDataNodes[2], 10240L, 1024L, 1024L, 0L, 0L, 0L, 0, 0);
        Assertions.assertTrue((toleratePlacementPolicy.compareDataNode(tolerateDataNodes[0], tolerateDataNodes[1]) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((toleratePlacementPolicy.compareDataNode(tolerateDataNodes[1], tolerateDataNodes[0]) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((toleratePlacementPolicy.compareDataNode(tolerateDataNodes[0], tolerateDataNodes[2]) == -1 ? 1 : 0) != 0);
        Assertions.assertTrue((toleratePlacementPolicy.compareDataNode(tolerateDataNodes[2], tolerateDataNodes[0]) == 1 ? 1 : 0) != 0);
    }

    @AfterAll
    public static void teardownCluster() {
        if (namenode != null) {
            namenode.stop();
        }
    }
}

