/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.balancer.BalancerHttpServer;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestBalancerHttpServer {
    private static final String BASEDIR = GenericTestUtils.getTempPath((String)TestBalancerHttpServer.class.getSimpleName());
    private static String keystoresDir;
    private static String sslConfDir;
    private static Configuration conf;
    private static URLConnectionFactory connectionFactory;

    @BeforeAll
    public static void setUp() throws Exception {
        conf = new Configuration();
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTP_ONLY.name());
        conf.set("dfs.balancer.http-address", "localhost:0");
        conf.set("dfs.balancer.https-address", "localhost:0");
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestBalancerHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
    }

    @AfterAll
    public static void tearDown() throws Exception {
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @Test
    public void testHttpServer() throws Exception {
        BalancerHttpServer server = null;
        try {
            server = new BalancerHttpServer(conf);
            server.start();
            Assertions.assertThat((boolean)this.checkConnection("http", server.getHttpAddress())).isTrue();
            Assertions.assertThat((boolean)this.checkConnection("https", server.getHttpsAddress())).isFalse();
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private boolean checkConnection(String scheme, InetSocketAddress address) {
        if (address == null) {
            return false;
        }
        try {
            URL url = new URL(scheme + "://" + NetUtils.getHostPortString((InetSocketAddress)address));
            URLConnection conn = connectionFactory.openConnection(url);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.connect();
            conn.getContent();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

