/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestUpdateDataNodeCurrentKey {
    private static final short REPLICATION = 1;
    private MiniDFSCluster cluster = null;
    private Configuration config;

    @BeforeEach
    public void setup() throws IOException {
        this.config = new Configuration();
        this.config.setInt("dfs.namenode.replication.max-streams", 8);
        this.config.setInt("dfs.namenode.replication.max-streams-hard-limit", 10);
        this.config.setInt("dfs.namenode.replication.work.multiplier.per.iteration", 12);
        this.config.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 300);
        this.config.setBoolean("dfs.block.access.token.enable", true);
        this.config.setBoolean("dfs.block.access.token.enable", true);
        this.cluster = new MiniDFSCluster.Builder(this.config).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        this.cluster.waitActive();
    }

    @AfterEach
    public void shutDownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testUpdateDatanodeCurrentKeyWithStandbyNameNodes() {
        String bpid = this.cluster.getNameNode(0).getFSImage().getBlockPoolID();
        DataNode dataNode = this.cluster.getDataNodes().get(0);
        BlockKey currentKey = dataNode.getBlockPoolTokenSecretManager().get(bpid).getCurrentKey();
        Assertions.assertTrue((currentKey != null ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateDatanodeCurrentKeyWithFailover() throws IOException, InterruptedException {
        this.cluster.transitionToActive(0);
        String bpid = this.cluster.getNameNode(0).getFSImage().getBlockPoolID();
        Thread.sleep(3000L);
        BlockKey annCurrentKey = this.cluster.getNameNode(0).getNamesystem().getBlockManager().getBlockTokenSecretManager().getCurrentKey();
        DataNode dataNode = this.cluster.getDataNodes().get(0);
        BlockKey currentKey = dataNode.getBlockPoolTokenSecretManager().get(bpid).getCurrentKey();
        Assertions.assertEquals((Object)annCurrentKey, (Object)currentKey);
    }

    @Test
    public void testUpdateDatanodeCurrentKeyFromActiveNameNode() throws IOException {
        this.cluster.transitionToActive(0);
        DataNode oldDataNode = this.cluster.getDataNodes().get(0);
        this.cluster.startDataNodes(this.config, 1, true, null, null);
        String bpid = this.cluster.getNamesystem(0).getBlockPoolId();
        DatanodeInfo[] dataNodeInfos = this.cluster.getNameNodeRpc(0).getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assertions.assertEquals((int)2, (int)dataNodeInfos.length);
        this.cluster.restartNameNode(1, true, new String[0]);
        BlockKey currentKey = this.cluster.getNameNode(0).getNamesystem().getBlockManager().getBlockTokenSecretManager().getCurrentKey();
        DataNode newDataNode = this.cluster.getDataNodes().get(1);
        BlockKey dnCurrentKey = oldDataNode.getBlockPoolTokenSecretManager().get(bpid).getCurrentKey();
        BlockKey dn2CurrentKey = newDataNode.getBlockPoolTokenSecretManager().get(bpid).getCurrentKey();
        Assertions.assertEquals((Object)dnCurrentKey, (Object)dn2CurrentKey);
        Assertions.assertEquals((Object)currentKey, (Object)dn2CurrentKey);
    }
}

