/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.qjournal.server.GetJournalEditServlet;
import org.apache.hadoop.security.UserGroupInformation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestGetJournalEditServlet {
    private static final Configuration CONF = new HdfsConfiguration();
    private static final GetJournalEditServlet SERVLET = new GetJournalEditServlet();

    @BeforeAll
    public static void setUp() throws ServletException {
        CONF.set("fs.defaultFS", "hdfs://localhost:4321/");
        CONF.set("hadoop.security.auth_to_local", "RULE:[2:$1/$2@$0]([nsdj]n/.*@REALM\\.TLD)s/.*/hdfs/\nDEFAULT");
        CONF.set("dfs.nameservices", "ns");
        CONF.set("dfs.namenode.kerberos.principal", "nn/_HOST@REALM.TLD");
        UserGroupInformation.setConfiguration((Configuration)CONF);
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)"jn/somehost@REALM.TLD"));
        ServletConfig config = (ServletConfig)Mockito.mock(ServletConfig.class);
        SERVLET.init(config);
    }

    @Test
    public void testWithoutUser() throws IOException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        boolean isValid = SERVLET.isValidRequestor(request, CONF);
        Assertions.assertThat((boolean)isValid).isFalse();
    }

    @Test
    public void testRequestNameNode() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("user.name")).thenReturn((Object)"nn/localhost@REALM.TLD");
        boolean isValid = SERVLET.isValidRequestor(request, CONF);
        Assertions.assertThat((boolean)isValid).isTrue();
    }

    @Test
    public void testRequestShortName() throws IOException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("user.name")).thenReturn((Object)"jn/localhost@REALM.TLD");
        boolean isValid = SERVLET.isValidRequestor(request, CONF);
        Assertions.assertThat((boolean)isValid).isTrue();
    }
}

