/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMiniJournalCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestMiniJournalCluster.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartStop() throws IOException {
        Configuration conf = new Configuration();
        MiniJournalCluster c = new MiniJournalCluster.Builder(conf).build();
        c.waitActive();
        try {
            URI uri = c.getQuorumJournalURI("myjournal");
            String[] addrs = uri.getAuthority().split(";");
            Assertions.assertEquals((int)3, (int)addrs.length);
            JournalNode node = c.getJournalNode(0);
            String dir = node.getConf().get("dfs.journalnode.edits.dir");
            Assertions.assertEquals((Object)new File(MiniDFSCluster.getBaseDirectory() + "journalnode-0").getAbsolutePath(), (Object)dir);
        }
        finally {
            c.shutdown();
        }
    }

    @Test
    public void testStartStopWithPorts() throws Exception {
        Configuration conf = new Configuration();
        LambdaTestUtils.intercept(IllegalArgumentException.class, (String)"Num of http ports (1) should match num of JournalNodes (3)", (String)"MiniJournalCluster port validation failed", () -> new MiniJournalCluster.Builder(conf).setHttpPorts(8481).build());
        LambdaTestUtils.intercept(IllegalArgumentException.class, (String)"Num of rpc ports (2) should match num of JournalNodes (3)", (String)"MiniJournalCluster port validation failed", () -> new MiniJournalCluster.Builder(conf).setRpcPorts(8481, 8482).build());
        LambdaTestUtils.intercept(IllegalArgumentException.class, (String)"Num of rpc ports (1) should match num of JournalNodes (3)", (String)"MiniJournalCluster port validation failed", () -> new MiniJournalCluster.Builder(conf).setHttpPorts(800, 9000, 10000).setRpcPorts(8481).build());
        LambdaTestUtils.intercept(IllegalArgumentException.class, (String)"Num of http ports (4) should match num of JournalNodes (3)", (String)"MiniJournalCluster port validation failed", () -> new MiniJournalCluster.Builder(conf).setHttpPorts(800, 9000, 1000, 2000).setRpcPorts(8481, 8482, 8483).build());
        Set httpAndRpcPorts = NetUtils.getFreeSocketPorts((int)6);
        LOG.info("Free socket ports: {}", (Object)httpAndRpcPorts);
        for (Integer httpAndRpcPort : httpAndRpcPorts) {
            Assertions.assertNotEquals((int)0, (int)httpAndRpcPort, (String)"None of the acquired socket port should not be zero");
        }
        int[] httpPorts = new int[3];
        int[] rpcPorts = new int[3];
        int httpPortIdx = 0;
        int rpcPortIdx = 0;
        for (Integer httpAndRpcPort : httpAndRpcPorts) {
            if (httpPortIdx < 3) {
                httpPorts[httpPortIdx++] = httpAndRpcPort;
                continue;
            }
            rpcPorts[rpcPortIdx++] = httpAndRpcPort;
        }
        LOG.info("Http ports selected: {}", (Object)httpPorts);
        LOG.info("Rpc ports selected: {}", (Object)rpcPorts);
        try (MiniJournalCluster miniJournalCluster = new MiniJournalCluster.Builder(conf).setHttpPorts(httpPorts).setRpcPorts(rpcPorts).build();){
            miniJournalCluster.waitActive();
            URI uri = miniJournalCluster.getQuorumJournalURI("myjournal");
            String[] addrs = uri.getAuthority().split(";");
            Assertions.assertEquals((int)3, (int)addrs.length);
            Assertions.assertEquals((int)httpPorts[0], (int)miniJournalCluster.getJournalNode(0).getHttpAddress().getPort());
            Assertions.assertEquals((int)httpPorts[1], (int)miniJournalCluster.getJournalNode(1).getHttpAddress().getPort());
            Assertions.assertEquals((int)httpPorts[2], (int)miniJournalCluster.getJournalNode(2).getHttpAddress().getPort());
            Assertions.assertEquals((int)rpcPorts[0], (int)miniJournalCluster.getJournalNode(0).getRpcServer().getAddress().getPort());
            Assertions.assertEquals((int)rpcPorts[1], (int)miniJournalCluster.getJournalNode(1).getRpcServer().getAddress().getPort());
            Assertions.assertEquals((int)rpcPorts[2], (int)miniJournalCluster.getJournalNode(2).getRpcServer().getAddress().getPort());
            JournalNode node = miniJournalCluster.getJournalNode(0);
            String dir = node.getConf().get("dfs.journalnode.edits.dir");
            Assertions.assertEquals((Object)new File(MiniDFSCluster.getBaseDirectory() + "journalnode-0").getAbsolutePath(), (Object)dir);
        }
    }
}

