/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.SecurityTestUtil;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=60L)
public class TestSaslDataTransferExpiredBlockToken
extends SaslDataTransferTestCase {
    private static final int BLOCK_SIZE = 4096;
    private static final int FILE_SIZE = 8192;
    private static final Path PATH = new Path("/file1");
    private final byte[] rawData = new byte[8192];
    private MiniDFSCluster cluster;

    @BeforeEach
    public void before() throws Exception {
        Random r = new Random();
        r.nextBytes(this.rawData);
        HdfsConfiguration conf = this.createSecureConfig("authentication,integrity,privacy");
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        this.cluster.waitActive();
        try (DistributedFileSystem fs = this.cluster.getFileSystem();){
            this.createFile((FileSystem)fs);
        }
        SecurityTestUtil.setBlockTokenLifetime(this.cluster.getNameNode().getNamesystem().getBlockManager().getBlockTokenSecretManager(), 1000L);
    }

    @AfterEach
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void createFile(FileSystem fs) throws IOException {
        try (FSDataOutputStream out = fs.create(PATH);){
            out.write(this.rawData);
        }
    }

    private boolean checkFile1(FSDataInputStream in) {
        byte[] toRead = new byte[8192];
        int totalRead = 0;
        int nRead = 0;
        try {
            while ((nRead = in.read(toRead, totalRead, toRead.length - totalRead)) > 0) {
                totalRead += nRead;
            }
        }
        catch (IOException e) {
            return false;
        }
        Assertions.assertEquals((int)toRead.length, (int)totalRead, (String)"Cannot read file.");
        return this.checkFile(toRead);
    }

    private boolean checkFile2(FSDataInputStream in) {
        byte[] toRead = new byte[8192];
        try {
            Assertions.assertEquals((int)toRead.length, (int)in.read(0L, toRead, 0, toRead.length), (String)"Cannot read file");
        }
        catch (IOException e) {
            return false;
        }
        return this.checkFile(toRead);
    }

    private boolean checkFile(byte[] fileToCheck) {
        if (fileToCheck.length != this.rawData.length) {
            return false;
        }
        for (int i = 0; i < fileToCheck.length; ++i) {
            if (fileToCheck[i] == this.rawData[i]) continue;
            return false;
        }
        return true;
    }

    private FileSystem newFileSystem() throws IOException {
        Configuration clientConf = new Configuration(this.cluster.getConfiguration(0));
        clientConf.setInt("dfs.client.retry.window.base", Integer.MAX_VALUE);
        return FileSystem.newInstance((URI)this.cluster.getURI(), (Configuration)clientConf);
    }

    private FileSystem newFileSystemHedgedRead() throws IOException {
        Configuration clientConf = new Configuration(this.cluster.getConfiguration(0));
        clientConf.setInt("dfs.client.retry.window.base", 3000);
        clientConf.setInt("dfs.client.hedged.read.threadpool.size", 5);
        return FileSystem.newInstance((URI)this.cluster.getURI(), (Configuration)clientConf);
    }

    @Test
    public void testBlockSeekToWithExpiredToken() throws Exception {
        try (FileSystem fs = this.newFileSystem();
             FSDataInputStream in = fs.open(PATH);){
            this.waitBlockTokenExpired(in);
            Assertions.assertTrue((boolean)this.checkFile1(in));
        }
    }

    @Test
    public void testFetchBlockByteRangeWithExpiredToken() throws Exception {
        try (FileSystem fs = this.newFileSystem();
             FSDataInputStream in = fs.open(PATH);){
            this.waitBlockTokenExpired(in);
            Assertions.assertTrue((boolean)this.checkFile2(in));
        }
    }

    @Test
    public void testHedgedFetchBlockByteRangeWithExpiredToken() throws Exception {
        try (FileSystem fs = this.newFileSystemHedgedRead();
             FSDataInputStream in = fs.open(PATH);){
            this.waitBlockTokenExpired(in);
            Assertions.assertTrue((boolean)this.checkFile2(in));
        }
    }

    private void waitBlockTokenExpired(FSDataInputStream in1) throws Exception {
        DFSInputStream innerStream = (DFSInputStream)in1.getWrappedStream();
        for (LocatedBlock block : innerStream.getAllBlocks()) {
            while (!SecurityTestUtil.isBlockTokenExpired((Token<BlockTokenIdentifier>)block.getBlockToken())) {
                Thread.sleep(100L);
            }
        }
    }
}

