/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocatedBlock {
    public static final Logger LOG = LoggerFactory.getLogger(TestLocatedBlock.class);

    @Test
    @Timeout(value=10L)
    public void testAddCachedLocWhenEmpty() {
        DatanodeInfo[] ds = DatanodeInfo.EMPTY_ARRAY;
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds);
        DatanodeDescriptor dn = new DatanodeDescriptor(new DatanodeID("127.0.0.1", "localhost", "abcd", 5000, 5001, 5002, 5003));
        try {
            l1.addCachedLoc((DatanodeInfo)dn);
            Assertions.fail((String)"Adding dn when block is empty should throw");
        }
        catch (IllegalArgumentException e) {
            LOG.info("Expected exception:", (Throwable)e);
        }
    }
}

