/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.SortedSet;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestLayoutVersion {
    public static final LayoutVersion.LayoutFeature LAST_NON_RESERVED_COMMON_FEATURE;
    public static final LayoutVersion.LayoutFeature LAST_COMMON_FEATURE;

    @Test
    public void testFeaturesFromAncestorSupported() {
        for (LayoutVersion.Feature f : LayoutVersion.Feature.values()) {
            this.validateFeatureList((LayoutVersion.LayoutFeature)f);
        }
    }

    @Test
    public void testRelease203() {
        Assertions.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_203.getInfo().getLayoutVersion()));
    }

    @Test
    public void testRelease204() {
        Assertions.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_204.getInfo().getLayoutVersion()));
    }

    @Test
    public void testRelease1_2_0() {
        Assertions.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.CONCAT, (int)LayoutVersion.Feature.RESERVED_REL1_2_0.getInfo().getLayoutVersion()));
    }

    @Test
    public void testNameNodeFeature() {
        NameNodeLayoutVersion.Feature first = NameNodeLayoutVersion.Feature.ROLLING_UPGRADE;
        Assertions.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LAST_NON_RESERVED_COMMON_FEATURE, (int)first.getInfo().getLayoutVersion()));
        Assertions.assertEquals((int)(LAST_COMMON_FEATURE.getInfo().getLayoutVersion() - 1), (int)first.getInfo().getLayoutVersion());
    }

    @Test
    public void testDataNodeFeature() {
        DataNodeLayoutVersion.Feature first = DataNodeLayoutVersion.Feature.FIRST_LAYOUT;
        Assertions.assertTrue((boolean)DataNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LAST_NON_RESERVED_COMMON_FEATURE, (int)first.getInfo().getLayoutVersion()));
        Assertions.assertEquals((int)(LAST_COMMON_FEATURE.getInfo().getLayoutVersion() - 1), (int)first.getInfo().getLayoutVersion());
    }

    @Test
    public void testNameNodeFeatureMinimumCompatibleLayoutVersions() {
        int baseLV = NameNodeLayoutVersion.Feature.TRUNCATE.getInfo().getLayoutVersion();
        EnumSet<NameNodeLayoutVersion.Feature[]> compatibleFeatures = EnumSet.of(NameNodeLayoutVersion.Feature.TRUNCATE, new NameNodeLayoutVersion.Feature[]{NameNodeLayoutVersion.Feature.APPEND_NEW_BLOCK, NameNodeLayoutVersion.Feature.QUOTA_BY_STORAGE_TYPE, NameNodeLayoutVersion.Feature.ERASURE_CODING, NameNodeLayoutVersion.Feature.EXPANDED_STRING_TABLE, NameNodeLayoutVersion.Feature.SNAPSHOT_MODIFICATION_TIME, NameNodeLayoutVersion.Feature.NVDIMM_SUPPORT});
        for (LayoutVersion.LayoutFeature layoutFeature : compatibleFeatures) {
            Assertions.assertEquals((int)baseLV, (int)layoutFeature.getInfo().getMinimumCompatibleLayoutVersion(), (String)String.format("Expected minimum compatible layout version %d for feature %s.", baseLV, layoutFeature));
        }
        ArrayList<Object> features = new ArrayList<Object>();
        features.addAll(EnumSet.allOf(LayoutVersion.Feature.class));
        features.addAll(EnumSet.allOf(NameNodeLayoutVersion.Feature.class));
        for (LayoutVersion.LayoutFeature layoutFeature : features) {
            if (compatibleFeatures.contains(layoutFeature)) continue;
            Assertions.assertEquals((int)layoutFeature.getInfo().getLayoutVersion(), (int)layoutFeature.getInfo().getMinimumCompatibleLayoutVersion(), (String)String.format("Expected feature %s to have minimum compatible layout version set to itself.", layoutFeature));
        }
    }

    @Test
    public void testNameNodeFeatureMinimumCompatibleLayoutVersionAscending() {
        LayoutVersion.LayoutFeature prevF = null;
        for (LayoutVersion.LayoutFeature layoutFeature : EnumSet.allOf(NameNodeLayoutVersion.Feature.class)) {
            if (prevF != null) {
                Assertions.assertTrue((layoutFeature.getInfo().getMinimumCompatibleLayoutVersion() <= prevF.getInfo().getMinimumCompatibleLayoutVersion() ? 1 : 0) != 0, (String)String.format("Features %s and %s not listed in order of minimum compatible layout version.", prevF, layoutFeature));
                continue;
            }
            prevF = layoutFeature;
        }
    }

    @Test
    public void testNameNodeFeatureMinimumCompatibleLayoutVersionOutOfOrder() {
        Assertions.assertThrows(AssertionError.class, () -> {
            LayoutVersion.FeatureInfo ancestorF = LayoutVersion.Feature.RESERVED_REL2_4_0.getInfo();
            LayoutVersion.LayoutFeature f = (LayoutVersion.LayoutFeature)Mockito.mock(LayoutVersion.LayoutFeature.class);
            Mockito.when((Object)f.getInfo()).thenReturn((Object)new LayoutVersion.FeatureInfo(ancestorF.getLayoutVersion() - 1, ancestorF.getLayoutVersion(), Integer.valueOf(ancestorF.getMinimumCompatibleLayoutVersion() + 1), "Invalid feature.", false, new LayoutVersion.LayoutFeature[0]));
            HashMap features = new HashMap();
            LayoutVersion.updateMap(features, (LayoutVersion.LayoutFeature[])LayoutVersion.Feature.values());
            LayoutVersion.updateMap(features, (LayoutVersion.LayoutFeature[])new LayoutVersion.LayoutFeature[]{f});
        });
    }

    @Test
    public void testCurrentMinimumCompatibleLayoutVersion() {
        int expectedMinCompatLV = NameNodeLayoutVersion.Feature.TRUNCATE.getInfo().getLayoutVersion();
        int actualMinCompatLV = LayoutVersion.getMinimumCompatibleLayoutVersion((LayoutVersion.LayoutFeature[])NameNodeLayoutVersion.Feature.values());
        Assertions.assertEquals((int)expectedMinCompatLV, (int)actualMinCompatLV, (String)"The minimum compatible layout version has changed.  Downgrade to prior versions is no longer possible.  Please either restore compatibility, or if the incompatibility is intentional, then update this assertion.");
    }

    private void validateFeatureList(LayoutVersion.LayoutFeature f) {
        LayoutVersion.FeatureInfo info = f.getInfo();
        int lv = info.getLayoutVersion();
        int ancestorLV = info.getAncestorLayoutVersion();
        SortedSet ancestorSet = NameNodeLayoutVersion.getFeatures((int)ancestorLV);
        Assertions.assertNotNull((Object)ancestorSet);
        for (LayoutVersion.LayoutFeature feature : ancestorSet) {
            Assertions.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)feature, (int)lv), (String)("LV " + lv + " does nto support " + feature + " supported by the ancestor LV " + info.getAncestorLayoutVersion()));
        }
    }

    @Test
    public void testSNAPSHOT() {
        for (LayoutVersion.Feature f : LayoutVersion.Feature.values()) {
            int version = f.getInfo().getLayoutVersion();
            if (!NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.SNAPSHOT, (int)version)) continue;
            Assertions.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.FSIMAGE_NAME_OPTIMIZATION, (int)version));
        }
    }

    static {
        LayoutVersion.Feature[] features = LayoutVersion.Feature.values();
        LAST_COMMON_FEATURE = features[features.length - 1];
        LAST_NON_RESERVED_COMMON_FEATURE = LayoutVersion.getLastNonReservedFeature((LayoutVersion.LayoutFeature[])features);
    }
}

