/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.net.DFSTopologyNodeImpl;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.Node;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=30L)
public class TestDFSNetworkTopology {
    private static final Logger LOG = LoggerFactory.getLogger(TestDFSNetworkTopology.class);
    private static final DFSNetworkTopology CLUSTER = DFSNetworkTopology.getInstance((Configuration)new Configuration());
    private DatanodeDescriptor[] dataNodes;

    @BeforeEach
    public void setupDatanodes() {
        String[] racks = new String[]{"/l1/d1/r1", "/l1/d1/r1", "/l1/d1/r2", "/l1/d1/r2", "/l1/d1/r2", "/l1/d2/r3", "/l1/d2/r3", "/l1/d2/r3", "/l1/d2/r3", "/l2/d3/r1", "/l2/d3/r2", "/l2/d3/r3", "/l2/d3/r4", "/l2/d3/r5", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r2", "/l3/d5/r1", "/l3/d5/r1", "/l3/d5/r2"};
        String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6", "host7", "host8", "host9", "host10", "host11", "host12", "host13", "host14", "host15", "host16", "host17", "host18", "host19", "host20", "host21", "host22", "host23", "host24", "host25"};
        StorageType[] types = new StorageType[]{StorageType.ARCHIVE, StorageType.DISK, StorageType.ARCHIVE, StorageType.DISK, StorageType.DISK, StorageType.DISK, StorageType.RAM_DISK, StorageType.SSD, StorageType.NVDIMM, StorageType.DISK, StorageType.RAM_DISK, StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.DISK, StorageType.DISK, StorageType.RAM_DISK, StorageType.RAM_DISK, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.SSD, StorageType.NVDIMM, StorageType.NVDIMM, StorageType.ARCHIVE, StorageType.DISK};
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(25, racks, hosts, types);
        this.dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        for (int i = 0; i < this.dataNodes.length; ++i) {
            CLUSTER.add((Node)this.dataNodes[i]);
        }
        this.dataNodes[10].setDecommissioned();
        this.dataNodes[11].setDecommissioned();
    }

    @Test
    public void testGetStorageTypeInfo() throws Exception {
        DFSTopologyNodeImpl d1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d1");
        HashMap d1info = d1.getChildrenStorageInfo();
        Assertions.assertEquals((int)2, (int)d1info.keySet().size());
        Assertions.assertTrue((((EnumMap)d1info.get("r1")).size() == 2 && ((EnumMap)d1info.get("r2")).size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.ARCHIVE)));
        DFSTopologyNodeImpl d2 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d2");
        HashMap d2info = d2.getChildrenStorageInfo();
        Assertions.assertEquals((int)1, (int)d2info.keySet().size());
        Assertions.assertEquals((int)4, (int)((EnumMap)d2info.get("r3")).size());
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d2info.get("r3")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d2info.get("r3")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d2info.get("r3")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d2info.get("r3")).get(StorageType.NVDIMM)));
        DFSTopologyNodeImpl d3 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l2/d3");
        HashMap d3info = d3.getChildrenStorageInfo();
        Assertions.assertEquals((int)5, (int)d3info.keySet().size());
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d3info.get("r1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d3info.get("r2")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d3info.get("r3")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d3info.get("r4")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d3info.get("r5")).get(StorageType.ARCHIVE)));
        DFSTopologyNodeImpl d4 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l2/d4");
        HashMap d4info = d4.getChildrenStorageInfo();
        Assertions.assertEquals((int)2, (int)d4info.keySet().size());
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d4info.get("r2")).get(StorageType.NVDIMM)));
        DFSTopologyNodeImpl d5 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l3/d5");
        System.out.println(d5);
        HashMap d5info = d5.getChildrenStorageInfo();
        Assertions.assertEquals((int)2, (int)d5info.keySet().size());
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d5info.get("r1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d5info.get("r1")).get(StorageType.NVDIMM)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d5info.get("r2")).get(StorageType.DISK)));
        DFSTopologyNodeImpl l1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1");
        HashMap l1info = l1.getChildrenStorageInfo();
        Assertions.assertEquals((int)2, (int)l1info.keySet().size());
        Assertions.assertTrue((((EnumMap)l1info.get("d1")).size() == 2 && ((EnumMap)l1info.get("d2")).size() == 4 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)3, (int)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.NVDIMM)));
        DFSTopologyNodeImpl l2 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l2");
        HashMap l2info = l2.getChildrenStorageInfo();
        Assertions.assertTrue((((EnumMap)l2info.get("d3")).size() == 3 && ((EnumMap)l2info.get("d4")).size() == 5 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)l2info.keySet().size());
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l2info.get("d3")).get(StorageType.DISK)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l2info.get("d3")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l2info.get("d3")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.DISK)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.NVDIMM)));
        DFSTopologyNodeImpl l3 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l3");
        HashMap l3info = l3.getChildrenStorageInfo();
        Assertions.assertTrue((((EnumMap)l3info.get("d5")).size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)l3info.keySet().size());
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l3info.get("d5")).get(StorageType.NVDIMM)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l3info.get("d5")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l3info.get("d5")).get(StorageType.DISK)));
    }

    @Test
    public void testAddAndRemoveTopology() throws Exception {
        String[] newRack = new String[]{"/l1/d1/r1", "/l1/d1/r3", "/l1/d3/r3", "/l1/d3/r3", "/l1/d3/r4"};
        String[] newHost = new String[]{"nhost1", "nhost2", "nhost3", "nhost4", "nhost5"};
        String[] newips = new String[]{"30.30.30.30", "31.31.31.31", "32.32.32.32", "33.33.33.33", "34.34.34.34"};
        StorageType[] newTypes = new StorageType[]{StorageType.DISK, StorageType.SSD, StorageType.SSD, StorageType.SSD, StorageType.NVDIMM};
        DatanodeDescriptor[] newDD = new DatanodeDescriptor[5];
        for (int i = 0; i < 5; ++i) {
            DatanodeStorageInfo dsi = DFSTestUtil.createDatanodeStorageInfo("s" + newHost[i], newips[i], newRack[i], newHost[i], newTypes[i], null);
            newDD[i] = dsi.getDatanodeDescriptor();
            CLUSTER.add((Node)newDD[i]);
        }
        DFSTopologyNodeImpl d1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d1");
        HashMap d1info = d1.getChildrenStorageInfo();
        Assertions.assertEquals((int)3, (int)d1info.keySet().size());
        Assertions.assertTrue((((EnumMap)d1info.get("r1")).size() == 2 && ((EnumMap)d1info.get("r2")).size() == 2 && ((EnumMap)d1info.get("r3")).size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d1info.get("r3")).get(StorageType.SSD)));
        DFSTopologyNodeImpl d3 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d3");
        HashMap d3info = d3.getChildrenStorageInfo();
        Assertions.assertEquals((int)2, (int)d3info.keySet().size());
        Assertions.assertTrue((((EnumMap)d3info.get("r3")).size() == 1 && ((EnumMap)d3info.get("r4")).size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)d3info.get("r3")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)d3info.get("r4")).get(StorageType.NVDIMM)));
        DFSTopologyNodeImpl l1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1");
        HashMap l1info = l1.getChildrenStorageInfo();
        Assertions.assertEquals((int)3, (int)l1info.keySet().size());
        Assertions.assertTrue((((EnumMap)l1info.get("d1")).size() == 3 && ((EnumMap)l1info.get("d2")).size() == 4 && ((EnumMap)l1info.get("d3")).size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.DISK)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)l1info.get("d3")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d3")).get(StorageType.NVDIMM)));
        for (int i = 0; i < 5; ++i) {
            CLUSTER.remove((Node)newDD[i]);
        }
        DFSTopologyNodeImpl nd1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d1");
        HashMap nd1info = nd1.getChildrenStorageInfo();
        Assertions.assertEquals((int)2, (int)nd1info.keySet().size());
        Assertions.assertTrue((((EnumMap)nd1info.get("r1")).size() == 2 && ((EnumMap)nd1info.get("r2")).size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)nd1info.get("r1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)nd1info.get("r1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)nd1info.get("r2")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)nd1info.get("r2")).get(StorageType.ARCHIVE)));
        DFSTopologyNodeImpl nl1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1");
        HashMap nl1info = nl1.getChildrenStorageInfo();
        Assertions.assertEquals((int)2, (int)nl1info.keySet().size());
        Assertions.assertTrue((((EnumMap)l1info.get("d1")).size() == 2 && ((EnumMap)l1info.get("d2")).size() == 4 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)((Integer)((EnumMap)nl1info.get("d1")).get(StorageType.ARCHIVE)));
        Assertions.assertEquals((int)3, (int)((Integer)((EnumMap)nl1info.get("d1")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.RAM_DISK)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.SSD)));
        Assertions.assertEquals((int)1, (int)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.NVDIMM)));
        Assertions.assertNull((Object)CLUSTER.getNode("/l1/d3"));
    }

    @Test
    public void testChooseRandomWithStorageType() throws Exception {
        HashSet<String> diskUnderL1 = new HashSet<String>(Arrays.asList("host2", "host4", "host5", "host6"));
        HashSet<String> archiveUnderL1 = new HashSet<String>(Arrays.asList("host1", "host3"));
        HashSet<String> ramdiskUnderL1 = new HashSet<String>(Arrays.asList("host7"));
        HashSet<String> ssdUnderL1 = new HashSet<String>(Arrays.asList("host8"));
        HashSet<String> nvdimmUnderL1 = new HashSet<String>(Arrays.asList("host9"));
        for (int i = 0; i < 10; ++i) {
            Node n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.DISK);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            DatanodeDescriptor dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)diskUnderL1.contains(dd.getHostName()));
            n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.RAM_DISK);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)ramdiskUnderL1.contains(dd.getHostName()));
            n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)archiveUnderL1.contains(dd.getHostName()));
            n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.SSD);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)ssdUnderL1.contains(dd.getHostName()));
        }
    }

    @Test
    public void testChooseRandomWithStorageTypeWithExcluded() throws Exception {
        DatanodeDescriptor dd;
        int i;
        Node n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r4", null, null, StorageType.ARCHIVE);
        HashSet<Node> excluded = new HashSet<Node>();
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", null, null, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((dd.getHostName().equals("host13") || dd.getHostName().equals("host14") ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", null, excluded, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)dd.getHostName().equals("host14"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", "/l2/d3/r4", null, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)dd.getHostName().equals("host14"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", "/l2/d3/r5", excluded, StorageType.ARCHIVE);
            Assertions.assertNull((Object)n);
        }
        n = CLUSTER.chooseRandomWithStorageType("/l1/d2", null, null, StorageType.DISK);
        dd = (DatanodeDescriptor)n;
        Assertions.assertEquals((Object)"host6", (Object)dd.getHostName());
        excluded.add(n);
        HashSet<String> expectedSet = new HashSet<String>(Arrays.asList("host4", "host5"));
        for (int i2 = 0; i2 < 10; ++i2) {
            n = CLUSTER.chooseRandomWithStorageType("/l1", "/l1/d1/r1", excluded, StorageType.DISK);
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)expectedSet.contains(dd.getHostName()));
        }
    }

    @Test
    public void testChooseRandomWithStorageTypeWithExcludedforNullCheck() throws Exception {
        HashSet<DatanodeInfo> excluded = new HashSet<DatanodeInfo>();
        excluded.add(new DatanodeInfo.DatanodeInfoBuilder().setNodeID(DatanodeID.EMPTY_DATANODE_ID).build());
        Node node = CLUSTER.chooseRandomWithStorageType("/", "/l1/d1/r1", excluded, StorageType.ARCHIVE);
        Assertions.assertNotNull((Object)node);
    }

    @Test
    public void testChooseRandomWithStorageTypeWrapper() throws Exception {
        DatanodeDescriptor dd;
        int i;
        Node n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r4", null, null, StorageType.ARCHIVE);
        HashSet<Node> excluded = new HashSet<Node>();
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", null, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((dd.getHostName().equals("host13") || dd.getHostName().equals("host14") ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", excluded, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)dd.getHostName().equals("host14"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("~/l2/d4", null, StorageType.RAM_DISK);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((dd.getHostName().equals("host7") || dd.getHostName().equals("host11") ? 1 : 0) != 0);
        }
        n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r2", null, null, StorageType.RAM_DISK);
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("~/l2/d4", excluded, StorageType.RAM_DISK);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)dd.getHostName().equals("host7"));
        }
    }

    @Test
    public void testNonExistingNode() throws Exception {
        Node n = CLUSTER.chooseRandomWithStorageType("/l100", null, null, StorageType.DISK);
        Assertions.assertNull((Object)n);
        n = CLUSTER.chooseRandomWithStorageType("/l100/d100", null, null, StorageType.DISK);
        Assertions.assertNull((Object)n);
        n = CLUSTER.chooseRandomWithStorageType("/l100/d100/r100", null, null, StorageType.DISK);
        Assertions.assertNull((Object)n);
    }

    @Test
    public void testGetSubtreeStorageCount() throws Exception {
        Node l2 = CLUSTER.getNode("/l2");
        Node l2d3 = CLUSTER.getNode("/l2/d3");
        Node l2d3r1 = CLUSTER.getNode("/l2/d3/r1");
        Node l2d3r3 = CLUSTER.getNode("/l2/d3/r3");
        Assertions.assertTrue((boolean)(l2 instanceof DFSTopologyNodeImpl));
        Assertions.assertTrue((boolean)(l2d3 instanceof DFSTopologyNodeImpl));
        Assertions.assertTrue((boolean)(l2d3r1 instanceof DFSTopologyNodeImpl));
        Assertions.assertTrue((boolean)(l2d3r3 instanceof DFSTopologyNodeImpl));
        DFSTopologyNodeImpl innerl2 = (DFSTopologyNodeImpl)l2;
        DFSTopologyNodeImpl innerl2d3 = (DFSTopologyNodeImpl)l2d3;
        DFSTopologyNodeImpl innerl2d3r1 = (DFSTopologyNodeImpl)l2d3r1;
        DFSTopologyNodeImpl innerl2d3r3 = (DFSTopologyNodeImpl)l2d3r3;
        Assertions.assertEquals((int)4, (int)innerl2.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)2, (int)innerl2d3.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)1, (int)innerl2d3r1.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)1, (int)innerl2d3r3.getSubtreeStorageCount(StorageType.DISK));
        DatanodeStorageInfo storageInfo = DFSTestUtil.createDatanodeStorageInfo("StorageID", "1.2.3.4", "/l2/d3/r1", "newhost");
        DatanodeDescriptor newNode = storageInfo.getDatanodeDescriptor();
        CLUSTER.add((Node)newNode);
        Assertions.assertEquals((int)5, (int)innerl2.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)3, (int)innerl2d3.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)2, (int)innerl2d3r1.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)1, (int)innerl2d3r3.getSubtreeStorageCount(StorageType.DISK));
        CLUSTER.remove((Node)newNode);
        Assertions.assertEquals((int)4, (int)innerl2.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)2, (int)innerl2d3.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)1, (int)innerl2d3r1.getSubtreeStorageCount(StorageType.DISK));
        Assertions.assertEquals((int)1, (int)innerl2d3r3.getSubtreeStorageCount(StorageType.DISK));
    }

    @Test
    public void testChooseRandomWithStorageTypeTwoTrial() throws Exception {
        DatanodeDescriptor dd;
        int i;
        Node n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r4", null, null, StorageType.ARCHIVE);
        HashSet<Node> excluded = new HashSet<Node>();
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("/l2/d3", null, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((dd.getHostName().equals("host13") || dd.getHostName().equals("host14") ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("/l2/d3", excluded, StorageType.ARCHIVE);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)dd.getHostName().equals("host14"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("~/l2/d4", null, StorageType.RAM_DISK);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((dd.getHostName().equals("host7") || dd.getHostName().equals("host11") ? 1 : 0) != 0);
        }
        n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r2", null, null, StorageType.RAM_DISK);
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("~/l2/d4", excluded, StorageType.RAM_DISK);
            Assertions.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assertions.assertTrue((boolean)dd.getHostName().equals("host7"));
        }
    }

    @Test
    public void testChooseRandomWithStorageTypeNoAvlblNode() {
        DFSNetworkTopology dfsCluster = DFSNetworkTopology.getInstance((Configuration)new Configuration());
        String[] racks = new String[]{"/default/rack1", "/default/rack10"};
        String[] hosts = new String[]{"host1", "host2"};
        StorageType[] types = new StorageType[]{StorageType.DISK, StorageType.DISK};
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(2, racks, hosts, types);
        DatanodeDescriptor[] dns = DFSTestUtil.toDatanodeDescriptor(storages);
        dfsCluster.add((Node)dns[0]);
        dfsCluster.add((Node)dns[1]);
        HashSet<DatanodeDescriptor> excluded = new HashSet<DatanodeDescriptor>();
        excluded.add(dns[1]);
        Node n = dfsCluster.chooseRandomWithStorageType("/default", "/default/rack1", excluded, StorageType.DISK);
        Assertions.assertNull((Object)n, (String)"No node should have been selected.");
    }

    @Test
    public void testChooseRandomWithStorageTypeScopeEqualsExcludedNodes() {
        DFSNetworkTopology dfsCluster = DFSNetworkTopology.getInstance((Configuration)new Configuration());
        String[] racks = new String[]{"/default/rack1", "/default/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        StorageType[] types = new StorageType[]{StorageType.DISK, StorageType.DISK};
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[2];
        for (int i = 0; i < 2; ++i) {
            String storageID = "s" + i;
            String ip = i + "." + i + "." + i + "." + i;
            storages[i] = DFSTestUtil.createDatanodeStorageInfo(storageID, ip, racks[i], hosts[i], types[i], null);
        }
        DatanodeDescriptor[] dns = DFSTestUtil.toDatanodeDescriptor(storages);
        dfsCluster.add((Node)dns[0]);
        dfsCluster.add((Node)dns[1]);
        HashSet<DatanodeDescriptor> excluded = new HashSet<DatanodeDescriptor>();
        excluded.add(dns[0]);
        Node n = dfsCluster.chooseRandomWithStorageType("/default/rack1/0.0.0.0:9866", null, excluded, StorageType.DISK);
        Assertions.assertNull((Object)n, (String)"No node should have been selected.");
    }

    @Test
    public void testChooseRandomWithStorageTypeWithExcludeNodes() {
        DFSNetworkTopology dfsCluster = DFSNetworkTopology.getInstance((Configuration)new Configuration());
        String[] racks = new String[]{"/default/rack1", "/default/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        StorageType[] types = new StorageType[]{StorageType.DISK, StorageType.DISK};
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(2, racks, hosts, types);
        DatanodeDescriptor[] dns = DFSTestUtil.toDatanodeDescriptor(storages);
        dfsCluster.add((Node)dns[0]);
        dfsCluster.add((Node)dns[1]);
        HashSet<DatanodeDescriptor> excluded = new HashSet<DatanodeDescriptor>();
        excluded.add(dns[1]);
        Node n = dfsCluster.chooseRandomWithStorageType("/default/rack1", null, excluded, StorageType.DISK);
        Assertions.assertNotNull((Object)n, (String)"/default/rack1/host1 should be selected.");
    }
}

