/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoStreamsTestBase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.crypto.CryptoFSDataInputStream;
import org.apache.hadoop.fs.crypto.CryptoFSDataOutputStream;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class TestHdfsCryptoStreams
extends CryptoStreamsTestBase {
    private static MiniDFSCluster dfsCluster;
    private static FileSystem fs;
    private static int pathCount;
    private static Path path;
    private static Path file;

    @BeforeAll
    public static void init() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        dfsCluster.waitClusterUp();
        fs = dfsCluster.getFileSystem();
        codec = CryptoCodec.getInstance((Configuration)conf);
    }

    @AfterAll
    public static void shutdown() throws Exception {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws IOException {
        path = new Path("/p" + ++pathCount);
        file = new Path(path, "file");
        FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        super.setUp();
    }

    @AfterEach
    public void cleanUp() throws IOException {
        fs.delete(path, true);
    }

    protected OutputStream getOutputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        return new CryptoFSDataOutputStream(fs.create(file), codec, bufferSize, key, iv);
    }

    protected InputStream getInputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        return new CryptoFSDataInputStream(fs.open(file), codec, bufferSize, key, iv);
    }

    static {
        pathCount = 0;
    }
}

