/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestBlockReaderLocalLegacy {
    @BeforeAll
    public static void setupCluster() throws IOException {
        DFSInputStream.tcpReadsDisabledForTesting = true;
        DomainSocket.disableBindPathValidation();
    }

    private static HdfsConfiguration getConfiguration(TemporarySocketDirectory socketDir) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (socketDir == null) {
            conf.set("dfs.domain.socket.path", "");
        } else {
            conf.set("dfs.domain.socket.path", new File(socketDir.getDir(), "TestBlockReaderLocalLegacy.%d.sock").getAbsolutePath());
        }
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.setBoolean("dfs.client.use.legacy.blockreader.local", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        conf.setBoolean("dfs.client.domain.socket.data.traffic", false);
        conf.setInt("dfs.client.retry.window.base", 10);
        return conf;
    }

    @Test
    public void testStablePositionAfterCorruptRead() throws Exception {
        boolean REPL_FACTOR = true;
        long FILE_LENGTH = 512L;
        HdfsConfiguration conf = TestBlockReaderLocalLegacy.getConfiguration(null);
        File basedir = new File(GenericTestUtils.getRandomizedTempPath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf, basedir).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/corrupted");
        DFSTestUtil.createFile((FileSystem)fs, path, 512L, (short)1, 12345L);
        DFSTestUtil.waitReplication((FileSystem)fs, path, (short)1);
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, path);
        int blockFilesCorrupted = cluster.corruptBlockOnDataNodes(block);
        Assertions.assertEquals((int)1, (int)blockFilesCorrupted, (String)"All replicas not corrupted");
        FSDataInputStream dis = cluster.getFileSystem().open(path);
        ByteBuffer buf = ByteBuffer.allocateDirect(512);
        boolean sawException = false;
        try {
            dis.read(buf);
        }
        catch (ChecksumException ex) {
            sawException = true;
        }
        Assertions.assertTrue((boolean)sawException);
        Assertions.assertEquals((int)0, (int)buf.position());
        Assertions.assertEquals((int)buf.capacity(), (int)buf.limit());
        dis = cluster.getFileSystem().open(path);
        buf.position(3);
        buf.limit(25);
        sawException = false;
        try {
            dis.read(buf);
        }
        catch (ChecksumException ex) {
            sawException = true;
        }
        Assertions.assertTrue((boolean)sawException);
        Assertions.assertEquals((int)3, (int)buf.position());
        Assertions.assertEquals((int)25, (int)buf.limit());
        cluster.shutdown();
    }

    @Test
    public void testBothOldAndNewShortCircuitConfigured() throws Exception {
        boolean REPL_FACTOR = true;
        int FILE_LENGTH = 512;
        Assumptions.assumeTrue((null == DomainSocket.getLoadingFailureReason() ? 1 : 0) != 0);
        TemporarySocketDirectory socketDir = new TemporarySocketDirectory();
        HdfsConfiguration conf = TestBlockReaderLocalLegacy.getConfiguration(socketDir);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        socketDir.close();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/foo");
        byte[] orig = new byte[512];
        for (int i = 0; i < orig.length; ++i) {
            orig[i] = (byte)(i % 10);
        }
        FSDataOutputStream fos = fs.create(path, (short)1);
        fos.write(orig);
        fos.close();
        DFSTestUtil.waitReplication((FileSystem)fs, path, (short)1);
        FSDataInputStream fis = cluster.getFileSystem().open(path);
        byte[] buf = new byte[512];
        IOUtils.readFully((InputStream)fis, (byte[])buf, (int)0, (int)512);
        fis.close();
        Assertions.assertArrayEquals((byte[])orig, (byte[])buf);
        Arrays.equals(orig, buf);
        cluster.shutdown();
    }

    @Test
    @Timeout(value=20L)
    public void testBlockReaderLocalLegacyWithAppend() throws Exception {
        boolean REPL_FACTOR = true;
        HdfsConfiguration conf = TestBlockReaderLocalLegacy.getConfiguration(null);
        conf.setBoolean("dfs.client.use.legacy.blockreader.local", true);
        File basedir = new File(GenericTestUtils.getRandomizedTempPath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf, basedir).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path path = new Path("/testBlockReaderLocalLegacy");
        DFSTestUtil.createFile((FileSystem)dfs, path, 10L, (short)1, 0L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        LocatedBlock lb = cluster.getNameNode().getRpcServer().getBlockLocations(path.toString(), 0L, 1L).get(0);
        ClientDatanodeProtocol proxy = DFSUtilClient.createClientDatanodeProtocolProxy((DatanodeID)lb.getLocations()[0], (Configuration)conf, (int)60000, (boolean)false);
        Token token = lb.getBlockToken();
        ExtendedBlock blk = new ExtendedBlock(lb.getBlock());
        ExtendedBlock originalBlock = new ExtendedBlock(blk);
        long originalGS = originalBlock.getGenerationStamp();
        BlockLocalPathInfo info = proxy.getBlockLocalPathInfo(blk, token);
        Assertions.assertEquals((long)originalGS, (long)info.getBlock().getGenerationStamp());
        FSDataOutputStream out = dfs.append(path);
        out.write(1);
        out.close();
        lb = cluster.getNameNode().getRpcServer().getBlockLocations(path.toString(), 0L, 1L).get(0);
        long newGS = lb.getBlock().getGenerationStamp();
        Assertions.assertTrue((newGS > originalGS ? 1 : 0) != 0);
        Assertions.assertEquals((long)originalGS, (long)originalBlock.getGenerationStamp());
        BlockLocalPathInfo info2 = proxy.getBlockLocalPathInfo(originalBlock, token);
        Assertions.assertEquals((long)newGS, (long)info2.getBlock().getGenerationStamp());
        cluster.shutdown();
    }
}

