/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestWriteConfigurationToDFS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testWriteConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 4096);
        System.out.println("Setting conf in: " + System.identityHashCode(conf));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        DistributedFileSystem fs = null;
        FSDataOutputStream os = null;
        try {
            fs = cluster.getFileSystem();
            Path filePath = new Path("/testWriteConf.xml");
            os = fs.create(filePath);
            StringBuilder longString = new StringBuilder();
            for (int i = 0; i < 100000; ++i) {
                longString.append("hello");
            }
            conf.set("foobar", longString.toString());
            conf.writeXml((OutputStream)os);
            os.close();
            os = null;
            fs.close();
            fs = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{os, fs});
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{os, fs});
        cluster.shutdown();
    }
}

