/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.TestDFSShell;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSetrepIncreasing {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setrep(int fromREP, int toREP, boolean simulatedStorage) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        conf.set("dfs.replication", "" + fromREP);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.reconstruction.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(10).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assertions.assertTrue((boolean)(fs instanceof DistributedFileSystem), (String)("Not a HDFS: " + fs.getUri()));
        try {
            Path root = TestDFSShell.mkdir((FileSystem)fs, new Path("/test/setrep" + fromREP + "-" + toREP));
            Path f = TestDFSShell.writeFile((FileSystem)fs, new Path(root, "foo"));
            String[] args = new String[]{"-setrep", "-w", "" + toREP, "" + f};
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            try {
                Assertions.assertEquals((int)0, (int)shell.run(args));
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)false, (String)("-setrep " + e));
            }
            fs = cluster.getFileSystem();
            FileStatus file = fs.getFileStatus(f);
            long len = file.getLen();
            for (BlockLocation locations : fs.getFileBlockLocations(file, 0L, len)) {
                Assertions.assertTrue((locations.getHosts().length == toREP ? 1 : 0) != 0);
            }
            TestDFSShell.show("done setrep waiting: " + root);
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception exception) {}
            cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=120L)
    public void testSetrepIncreasing() throws IOException {
        TestSetrepIncreasing.setrep(3, 7, false);
    }

    @Test
    @Timeout(value=120L)
    public void testSetrepIncreasingSimulatedStorage() throws IOException {
        TestSetrepIncreasing.setrep(3, 7, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetRepWithStoragePolicyOnEmptyFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            Path d = new Path("/tmp");
            dfs.mkdirs(d);
            dfs.setStoragePolicy(d, "HOT");
            Path f = new Path(d, "foo");
            dfs.createNewFile(f);
            dfs.setReplication(f, (short)4);
        }
        finally {
            dfs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetRepOnECFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        client.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        client.setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            Path d = new Path("/tmp");
            dfs.mkdirs(d);
            Path f = new Path(d, "foo");
            dfs.createNewFile(f);
            FileStatus file = dfs.getFileStatus(f);
            Assertions.assertTrue((boolean)file.isErasureCoded());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            String[] args = new String[]{"-setrep", "2", "" + f};
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            Assertions.assertEquals((int)0, (int)shell.run(args));
            Assertions.assertTrue((boolean)out.toString().contains("Did not set replication for: /tmp/foo"));
            file = dfs.getFileStatus(f);
            Assertions.assertEquals((int)1, (int)file.getReplication());
        }
        finally {
            dfs.close();
            cluster.shutdown();
        }
    }
}

