/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRestartDFS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests(Configuration conf, boolean serviceTest) throws Exception {
        FileStatus newdirstatus;
        FileStatus newrootstatus;
        FileStatus dirstatus;
        FileStatus rootstatus;
        long rootmtime;
        DistributedFileSystem fs;
        MiniDFSCluster cluster = null;
        DFSTestUtil files = new DFSTestUtil.Builder().setName("TestRestartDFS").setNumFiles(20).build();
        String dir = "/srcdat";
        Path rootpath = new Path("/");
        Path dirpath = new Path("/srcdat");
        try {
            if (serviceTest) {
                conf.set("dfs.namenode.servicerpc-address", "localhost:0");
            }
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
            fs = cluster.getFileSystem();
            files.createFiles((FileSystem)fs, "/srcdat");
            rootmtime = fs.getFileStatus(rootpath).getModificationTime();
            rootstatus = fs.getFileStatus(dirpath);
            dirstatus = fs.getFileStatus(dirpath);
            fs.setOwner(rootpath, rootstatus.getOwner() + "_XXX", null);
            fs.setOwner(dirpath, null, dirstatus.getGroup() + "_XXX");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            if (serviceTest) {
                conf.set("dfs.namenode.servicerpc-address", "localhost:0");
            }
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).format(false).build();
            fs = cluster.getFileSystem();
            Assertions.assertTrue((boolean)files.checkFiles((FileSystem)fs, "/srcdat"), (String)"Filesystem corrupted after restart.");
            newrootstatus = fs.getFileStatus(rootpath);
            Assertions.assertEquals((long)rootmtime, (long)newrootstatus.getModificationTime());
            Assertions.assertEquals((Object)(rootstatus.getOwner() + "_XXX"), (Object)newrootstatus.getOwner());
            Assertions.assertEquals((Object)rootstatus.getGroup(), (Object)newrootstatus.getGroup());
            newdirstatus = fs.getFileStatus(dirpath);
            Assertions.assertEquals((Object)dirstatus.getOwner(), (Object)newdirstatus.getOwner());
            Assertions.assertEquals((Object)(dirstatus.getGroup() + "_XXX"), (Object)newdirstatus.getGroup());
            rootmtime = fs.getFileStatus(rootpath).getModificationTime();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            if (serviceTest) {
                conf.set("dfs.namenode.servicerpc-address", "localhost:0");
            }
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).format(false).build();
            fs = cluster.getFileSystem();
            Assertions.assertTrue((boolean)files.checkFiles((FileSystem)fs, "/srcdat"), (String)"Filesystem corrupted after restart.");
            newrootstatus = fs.getFileStatus(rootpath);
            Assertions.assertEquals((long)rootmtime, (long)newrootstatus.getModificationTime());
            Assertions.assertEquals((Object)(rootstatus.getOwner() + "_XXX"), (Object)newrootstatus.getOwner());
            Assertions.assertEquals((Object)rootstatus.getGroup(), (Object)newrootstatus.getGroup());
            newdirstatus = fs.getFileStatus(dirpath);
            Assertions.assertEquals((Object)dirstatus.getOwner(), (Object)newdirstatus.getOwner());
            Assertions.assertEquals((Object)(dirstatus.getGroup() + "_XXX"), (Object)newdirstatus.getGroup());
            files.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testRestartDFS() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.runTests((Configuration)conf, false);
    }

    @Test
    public void testRestartDualPortDFS() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.runTests((Configuration)conf, true);
    }
}

