/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestReconstructStripedFile;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReconstructStripedFileWithValidator
extends TestReconstructStripedFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestReconstructStripedFileWithValidator.class);

    public TestReconstructStripedFileWithValidator() {
        LOG.info("run {} with validator.", (Object)TestReconstructStripedFileWithValidator.class.getSuperclass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testValidatorWithBadDecoding() throws Exception {
        MiniDFSCluster cluster = this.getCluster();
        cluster.getDataNodes().stream().map(DataNode::getMetrics).map(DataNodeMetrics::getECInvalidReconstructionTasks).forEach(n -> Assertions.assertEquals((long)0L, (long)n));
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector badDecodingInjector = new DataNodeFaultInjector(){
            private final AtomicBoolean flag = new AtomicBoolean(false);

            public void badDecoding(ByteBuffer[] outputs) {
                if (!this.flag.get()) {
                    for (ByteBuffer output : outputs) {
                        output.mark();
                        output.put((byte)(output.get(output.position()) + 1));
                        output.reset();
                    }
                }
                this.flag.set(true);
            }
        };
        DataNodeFaultInjector.set((DataNodeFaultInjector)badDecodingInjector);
        int fileLen = (this.getEcPolicy().getNumDataUnits() + this.getEcPolicy().getNumParityUnits()) * this.getBlockSize() + this.getBlockSize() / 10;
        try {
            this.assertFileBlocksReconstruction("/testValidatorWithBadDecoding", fileLen, TestReconstructStripedFile.ReconstructionType.DataOnly, this.getEcPolicy().getNumParityUnits());
            long sum = cluster.getDataNodes().stream().map(DataNode::getMetrics).mapToLong(DataNodeMetrics::getECInvalidReconstructionTasks).sum();
            Assertions.assertEquals((long)1L, (long)sum);
        }
        finally {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
    }

    @Override
    public boolean isValidationEnabled() {
        return true;
    }

    @Override
    public int getPendingTimeout() {
        return 10;
    }
}

