/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestReadStripedFileWithMissingBlocks {
    public static final Logger LOG = LoggerFactory.getLogger(TestReadStripedFileWithMissingBlocks.class);
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DFSClient dfsClient;
    private Configuration conf = new HdfsConfiguration();
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripPerBlock = 4;
    private final int blockSize = 4 * this.cellSize;
    private final int blockGroupSize = this.blockSize * this.dataBlocks;
    private final int numDNs = this.dataBlocks + this.parityBlocks + 2;
    private final int fileLength = this.blockSize * this.dataBlocks + 123;

    public void setup() throws IOException {
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setInt("dfs.namenode.replication.max-streams", 0);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDNs).build();
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/", this.ecPolicy.getName());
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.dfsClient = new DFSClient(this.cluster.getNameNode(0).getNameNodeAddress(), this.conf);
    }

    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFileWithMissingBlocks() throws Exception {
        try {
            this.setup();
            Path srcPath = new Path("/foo");
            byte[] expected = StripedFileTestUtil.generateBytes(this.fileLength);
            DFSTestUtil.writeFile((FileSystem)this.fs, srcPath, new String(expected));
            StripedFileTestUtil.waitBlockGroupsReported(this.fs, srcPath.toUri().getPath());
            StripedFileTestUtil.verifyLength((FileSystem)this.fs, srcPath, this.fileLength);
            for (int missingData = 1; missingData <= this.dataBlocks; ++missingData) {
                for (int missingParity = 0; missingParity <= this.parityBlocks - missingData; ++missingParity) {
                    this.readFileWithMissingBlocks(srcPath, this.fileLength, missingData, missingParity, expected);
                }
            }
        }
        finally {
            this.tearDown();
        }
    }

    private void readFileWithMissingBlocks(Path srcPath, int fileLength, int missingDataNum, int missingParityNum, byte[] expected) throws Exception {
        int i;
        LOG.info("readFileWithMissingBlocks: (" + missingDataNum + "," + missingParityNum + ")");
        int dataBlocks = (fileLength - 1) / this.cellSize + 1;
        BlockLocation[] locs = this.fs.getFileBlockLocations(srcPath, 0L, (long)this.cellSize);
        int[] missingDataNodes = new int[missingDataNum + missingParityNum];
        for (i = 0; i < missingDataNum; ++i) {
            missingDataNodes[i] = i;
        }
        for (i = 0; i < missingParityNum; ++i) {
            missingDataNodes[i + missingDataNum] = i + Math.min(this.ecPolicy.getNumDataUnits(), dataBlocks);
        }
        this.stopDataNodes(locs, missingDataNodes);
        BlockLocation[] newLocs = this.fs.getFileBlockLocations(srcPath, 0L, (long)this.cellSize);
        Assertions.assertTrue((newLocs[0].getNames().length < locs[0].getNames().length ? 1 : 0) != 0);
        byte[] smallBuf = new byte[1024];
        byte[] largeBuf = new byte[fileLength + 100];
        StripedFileTestUtil.verifySeek((FileSystem)this.fs, srcPath, fileLength, this.ecPolicy, this.blockGroupSize);
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.fs, srcPath, fileLength, expected, smallBuf);
        StripedFileTestUtil.verifyPread(this.fs, srcPath, fileLength, expected, largeBuf);
        this.restartDeadDataNodes();
    }

    private void restartDeadDataNodes() throws IOException {
        DatanodeInfo[] deadNodes;
        for (DatanodeInfo dnInfo : deadNodes = this.dfsClient.datanodeReport(HdfsConstants.DatanodeReportType.DEAD)) {
            this.cluster.restartDataNode(dnInfo.getXferAddr());
        }
        this.cluster.triggerHeartbeats();
    }

    private void stopDataNodes(BlockLocation[] locs, int[] datanodes) throws IOException {
        if (locs != null && locs.length > 0) {
            block0: for (int failedDNIdx : datanodes) {
                String name = locs[0].getNames()[failedDNIdx];
                for (DataNode dn : this.cluster.getDataNodes()) {
                    int port = dn.getXferPort();
                    if (!name.contains(Integer.toString(port))) continue;
                    dn.shutdown();
                    this.cluster.setDataNodeDead(dn.getDatanodeId());
                    LOG.info("stop datanode " + failedDNIdx);
                    continue block0;
                }
            }
        }
    }
}

