/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ReadStripedFileWithDecodingHelper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestReadStripedFileWithDecodingDeletedData {
    static final Logger LOG = LoggerFactory.getLogger(TestReadStripedFileWithDecodingDeletedData.class);
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private int fileLength;
    private int dataDelNum;
    private int parityDelNum;

    @BeforeAll
    public static void setup() throws IOException {
        cluster = ReadStripedFileWithDecodingHelper.initializeCluster();
        dfs = cluster.getFileSystem();
    }

    @AfterAll
    public static void tearDown() throws IOException {
        ReadStripedFileWithDecodingHelper.tearDownCluster(cluster);
    }

    public static Collection<Object[]> getParameters() {
        return ReadStripedFileWithDecodingHelper.getParameters();
    }

    public void initTestReadStripedFileWithDecodingDeletedData(int pFileLength, int pDataDelNum, int pParityDelNum) {
        this.fileLength = pFileLength;
        this.dataDelNum = pDataDelNum;
        this.parityDelNum = pParityDelNum;
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testReadCorruptedDataByDeleting(int pFileLength, int pDataDelNum, int pParityDelNum) throws IOException {
        this.initTestReadStripedFileWithDecodingDeletedData(pFileLength, pDataDelNum, pParityDelNum);
        String src = "/deleted_" + this.dataDelNum + "_" + this.parityDelNum;
        ReadStripedFileWithDecodingHelper.testReadWithBlockCorrupted(cluster, dfs, src, this.fileLength, this.dataDelNum, this.parityDelNum, true);
    }
}

