/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ReadStripedFileWithDecodingHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestReadStripedFileWithDecodingCorruptData {
    static final Logger LOG = LoggerFactory.getLogger(TestReadStripedFileWithDecodingCorruptData.class);
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private int fileLength;
    private int dataDelNum;
    private int parityDelNum;

    @BeforeAll
    public static void setup() throws IOException {
        cluster = ReadStripedFileWithDecodingHelper.initializeCluster();
        dfs = cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws IOException {
        ReadStripedFileWithDecodingHelper.tearDownCluster(cluster);
    }

    public static Collection<Object[]> getParameters() {
        return ReadStripedFileWithDecodingHelper.getParameters();
    }

    public void initTestReadStripedFileWithDecodingCorruptData(int pFileLength, int pDataDelNum, int pParityDelNum) {
        this.fileLength = pFileLength;
        this.dataDelNum = pDataDelNum;
        this.parityDelNum = pParityDelNum;
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testReadCorruptedData(int pFileLength, int pDataDelNum, int pParityDelNum) throws IOException {
        this.initTestReadStripedFileWithDecodingCorruptData(pFileLength, pDataDelNum, pParityDelNum);
        TestReadStripedFileWithDecodingCorruptData.setup();
        String src = "/corrupted_" + this.dataDelNum + "_" + this.parityDelNum;
        ReadStripedFileWithDecodingHelper.testReadWithBlockCorrupted(cluster, dfs, src, this.fileLength, this.dataDelNum, this.parityDelNum, false);
    }
}

