/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRead {
    private static final int BLOCK_SIZE = 512;
    static final long SEED = 3735928559L;
    static final int FILE_SIZE = 5120;
    private static final Logger LOG = LoggerFactory.getLogger((String)TestRead.class.getName());
    private final GenericTestUtils.LogCapturer dfsClientLog = GenericTestUtils.LogCapturer.captureLogs((Logger)DFSClient.LOG);

    @BeforeAll
    public static void setLogLevel() {
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.WARN);
    }

    private void testEOF(MiniDFSCluster cluster, int fileLength) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("testEOF." + fileLength);
        DFSTestUtil.createFile((FileSystem)fs, path, fileLength, (short)1, -1091584273L);
        FSDataInputStream fis = fs.open(path);
        ByteBuffer empty = ByteBuffer.allocate(0);
        Assertions.assertEquals((int)0, (int)fis.read(empty));
        fis.seek((long)fileLength);
        Assertions.assertEquals((int)-1, (int)fis.read(empty));
        if (fileLength > 512) {
            fis.seek((long)(fileLength - 512 + 1));
            ByteBuffer dbb = ByteBuffer.allocateDirect(512);
            Assertions.assertEquals((int)511, (int)fis.read(dbb));
        }
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testEOFWithBlockReaderLocal() throws Exception {
        try (DFSTestUtil.ShortCircuitTestContext testContext = new DFSTestUtil.ShortCircuitTestContext("testEOFWithBlockReaderLocal");){
            Configuration conf = testContext.newConfiguration();
            conf.setLong("dfs.client.cache.readahead", 512L);
            MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
            this.testEOF(cluster, 1);
            this.testEOF(cluster, 14);
            this.testEOF(cluster, 10000);
            cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testEOFWithRemoteBlockReader() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.client.cache.readahead", 512L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        this.testEOF(cluster, 1);
        this.testEOF(cluster, 14);
        this.testEOF(cluster, 10000);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testReadReservedPath() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.open(new Path("/.reserved/.inodes/file"));
            Assertions.fail((String)"Open a non existing file should fail.");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testInterruptReader() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.fsdataset.factory", DelayedSimulatedFSDataset.Factory.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            cluster.waitActive();
            Path file = new Path("/foo");
            DFSTestUtil.createFile((FileSystem)fs, file, 1024L, (short)1, 0L);
            final FSDataInputStream in = fs.open(file);
            final AtomicBoolean readInterrupted = new AtomicBoolean(false);
            Thread reader = new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            in.read(new byte[1024], 0, 1024);
                        }
                        catch (IOException e) {
                            if (!(e instanceof ClosedByInterruptException) && !(e instanceof InterruptedIOException)) break block2;
                            readInterrupted.set(true);
                        }
                    }
                }
            });
            reader.start();
            Thread.sleep(1000L);
            reader.interrupt();
            reader.join();
            Assertions.assertTrue((boolean)readInterrupted.get());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=120L)
    public void testReadBufferIOExceptionLogging() throws IOException {
        this.testReadBufferIOExceptionLogging(0, 0);
        this.testReadBufferIOExceptionLogging(1, 0);
        this.testReadBufferIOExceptionLogging(2, 0);
        this.testReadBufferIOExceptionLogging(3, 0);
        this.testReadBufferIOExceptionLogging(4, 1);
        this.testReadBufferIOExceptionLogging(5, 1);
        this.testReadBufferIOExceptionLogging(6, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadBufferIOExceptionLogging(final int ioExceptions, int maxBlockAcquireFailures) throws IOException {
        this.dfsClientLog.clearOutput();
        Configuration conf = new Configuration();
        conf.setInt("dfs.client.max.block.acquire.failures", maxBlockAcquireFailures);
        final int[] count = new int[]{0};
        DFSClientFaultInjector.set((DFSClientFaultInjector)((DFSClientFaultInjector)Mockito.mock(DFSClientFaultInjector.class)));
        DFSClientFaultInjector injector = DFSClientFaultInjector.get();
        ((DFSClientFaultInjector)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                if (count[0] < ioExceptions) {
                    LOG.info("-------------- throw IOException");
                    count[0] = count[0] + 1;
                    throw new IOException("IOException test");
                }
                return null;
            }
        }).when((Object)injector)).fetchFromDatanodeException();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).build();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        DFSClient dfsClient = fileSys.getClient();
        DFSInputStream input = null;
        Path file = new Path("/testfile.dat");
        try {
            DFSTestUtil.createFile((FileSystem)fileSys, file, 5120, 5120L, 512L, (short)3, 3735928559L);
            byte[] buffer = new byte[5120];
            input = dfsClient.open(file.toString());
            input.read(buffer, 0, 5120);
            Assertions.assertEquals((int)ioExceptions, (int)StringUtils.countMatches((CharSequence)this.dfsClientLog.getOutput(), (CharSequence)"Retry with the current or next available datanode."));
        }
        catch (Throwable throwable) {
            Mockito.reset((Object[])new DFSClientFaultInjector[]{injector});
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
            fileSys.close();
            cluster.shutdown();
            this.dfsClientLog.clearOutput();
            throw throwable;
        }
        Mockito.reset((Object[])new DFSClientFaultInjector[]{injector});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
        fileSys.close();
        cluster.shutdown();
        this.dfsClientLog.clearOutput();
    }

    @Test
    @Timeout(value=60L)
    public void testReadBufferIOExceptionLoggingFailedRequest() throws IOException {
        this.testReadBufferIOExceptionLoggingFailedRequest(0);
        this.testReadBufferIOExceptionLoggingFailedRequest(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadBufferIOExceptionLoggingFailedRequest(int maxBlockAcquireFailures) throws IOException {
        this.dfsClientLog.clearOutput();
        Configuration conf = new Configuration();
        conf.setInt("dfs.client.max.block.acquire.failures", maxBlockAcquireFailures);
        DFSClientFaultInjector.set((DFSClientFaultInjector)((DFSClientFaultInjector)Mockito.mock(DFSClientFaultInjector.class)));
        DFSClientFaultInjector injector = DFSClientFaultInjector.get();
        ((DFSClientFaultInjector)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                LOG.info("-------------- throw IOException");
                throw new IOException("IOException test");
            }
        }).when((Object)injector)).fetchFromDatanodeException();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).build();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        DFSClient dfsClient = fileSys.getClient();
        DFSInputStream input = null;
        Path file = new Path("/testfile.dat");
        try {
            DFSTestUtil.createFile((FileSystem)fileSys, file, 5120, 5120L, 512L, (short)3, 3735928559L);
            byte[] buffer = new byte[5120];
            input = dfsClient.open(file.toString());
            input.read(buffer, 0, 5120);
            Assertions.fail();
        }
        catch (BlockMissingException e) {
            try {
                Assertions.assertEquals((int)1, (int)StringUtils.countMatches((CharSequence)this.dfsClientLog.getOutput(), (CharSequence)"Failed to read from all available datanodes for file"));
                Assertions.assertEquals((long)(1L + 3L * (long)(maxBlockAcquireFailures + 1)), (long)StringUtils.countMatches((CharSequence)this.dfsClientLog.getOutput(), (CharSequence)"Exception when fetching file /testfile.dat at position="));
                Assertions.assertEquals((long)(1L + 3L * (long)(maxBlockAcquireFailures + 1)), (long)StringUtils.countMatches((CharSequence)this.dfsClientLog.getOutput(), (CharSequence)"Retry with the current or next available datanode."));
            }
            catch (Throwable throwable) {
                Mockito.reset((Object[])new DFSClientFaultInjector[]{injector});
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
                fileSys.close();
                cluster.shutdown();
                this.dfsClientLog.clearOutput();
                throw throwable;
            }
            Mockito.reset((Object[])new DFSClientFaultInjector[]{injector});
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
            fileSys.close();
            cluster.shutdown();
            this.dfsClientLog.clearOutput();
        }
        Mockito.reset((Object[])new DFSClientFaultInjector[]{injector});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{input});
        fileSys.close();
        cluster.shutdown();
        this.dfsClientLog.clearOutput();
    }

    private static class DelayedSimulatedFSDataset
    extends SimulatedFSDataset {
        private volatile boolean isDelayed = true;

        DelayedSimulatedFSDataset(DataNode datanode, DataStorage storage, Configuration conf) {
            super(datanode, storage, conf);
        }

        @Override
        public synchronized InputStream getBlockInputStream(ExtendedBlock b, long seekOffset) throws IOException {
            while (this.isDelayed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            InputStream result = super.getBlockInputStream(b);
            IOUtils.skipFully((InputStream)result, (long)seekOffset);
            return result;
        }

        static class Factory
        extends FsDatasetSpi.Factory<DelayedSimulatedFSDataset> {
            Factory() {
            }

            public DelayedSimulatedFSDataset newInstance(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
                return new DelayedSimulatedFSDataset(datanode, storage, conf);
            }

            public boolean isSimulated() {
                return true;
            }
        }
    }
}

