/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestParallelReadUtil;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class TestParallelShortCircuitReadUnCached
extends TestParallelReadUtil {
    private static TemporarySocketDirectory sockDir;

    @BeforeAll
    public static void setupCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        sockDir = new TemporarySocketDirectory();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestParallelShortCircuitReadUnCached._PORT.sock").getAbsolutePath());
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.setBoolean("dfs.encrypt.data.transfer", true);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.setBoolean("dfs.client.domain.socket.data.traffic", true);
        conf.setInt("dfs.datanode.socket.reuse.keepalive", 1);
        conf.setLong("dfs.client.socketcache.expiryMsec", 300000L);
        conf.setInt("dfs.client.socketcache.capacity", 32);
        conf.setInt("dfs.client.read.shortcircuit.streams.cache.size", 0);
        DomainSocket.disableBindPathValidation();
        DFSInputStream.tcpReadsDisabledForTesting = true;
        TestParallelShortCircuitReadUnCached.setupCluster(1, conf);
    }

    @BeforeEach
    public void before() {
        Assumptions.assumeThat((String)DomainSocket.getLoadingFailureReason()).isNull();
    }

    @AfterAll
    public static void teardownCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        sockDir.close();
        TestParallelReadUtil.teardownCluster();
    }
}

