/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestParallelReadUtil;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class TestParallelShortCircuitRead
extends TestParallelReadUtil {
    private static TemporarySocketDirectory sockDir;

    @BeforeAll
    public static void setupCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        DFSInputStream.tcpReadsDisabledForTesting = true;
        sockDir = new TemporarySocketDirectory();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestParallelLocalRead.%d.sock").getAbsolutePath());
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        DomainSocket.disableBindPathValidation();
        TestParallelShortCircuitRead.setupCluster(1, conf);
    }

    @BeforeEach
    public void before() {
        Assumptions.assumeThat((String)DomainSocket.getLoadingFailureReason()).isNull();
    }

    @AfterAll
    public static void teardownCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        sockDir.close();
        TestParallelReadUtil.teardownCluster();
    }
}

