/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataInput;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferServer;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMultipleNNPortQOP
extends SaslDataTransferTestCase {
    private static final Path PATH1 = new Path("/file1");
    private static final Path PATH2 = new Path("/file2");
    private static final Path PATH3 = new Path("/file3");
    private static final int BLOCK_SIZE = 4096;
    private static final int NUM_BLOCKS = 3;
    private static HdfsConfiguration clusterConf;

    @BeforeEach
    public void setup() throws Exception {
        clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        clusterConf.set("dfs.namenode.rpc-address.auxiliary-ports", "12001,12101,12201");
        clusterConf.set("dfs.namenode.servicerpc-address", "localhost:9021");
        clusterConf.set("hadoop.security.saslproperties.resolver.class", "org.apache.hadoop.security.IngressPortBasedResolver");
        clusterConf.set("ingress.port.sasl.configured.ports", "12001,12101,12201");
        clusterConf.set("ingress.port.sasl.prop.12001", "authentication");
        clusterConf.set("ingress.port.sasl.prop.12101", "integrity");
        clusterConf.set("ingress.port.sasl.prop.12201", "privacy");
        clusterConf.setBoolean("dfs.namenode.send.qop.enabled", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuxiliaryPortSendingQOP() throws Exception {
        MiniDFSCluster cluster = null;
        String pathPrefix = "/filetestAuxiliaryPortSendingQOP";
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(3).build();
            cluster.waitActive();
            HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
            clientConf.unset("hadoop.security.saslproperties.resolver.class");
            URI currentURI = cluster.getURI();
            URI uriAuthPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12001");
            URI uriIntegrityPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12101");
            URI uriPrivacyPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12201");
            byte[] secretOnPrimary = this.getHandshakeSecret(currentURI, clientConf, new Path("/filetestAuxiliaryPortSendingQOPPrimary"));
            Assertions.assertTrue((secretOnPrimary == null || secretOnPrimary.length == 0 ? 1 : 0) != 0);
            clientConf.set("hadoop.rpc.protection", "privacy");
            byte[] secretPrivacy = this.getHandshakeSecret(uriPrivacyPort, clientConf, new Path("/filetestAuxiliaryPortSendingQOPPrivacy"));
            Assertions.assertTrue((secretPrivacy.length > 0 ? 1 : 0) != 0);
            clientConf.set("hadoop.rpc.protection", "integrity");
            byte[] secretIntegrity = this.getHandshakeSecret(uriIntegrityPort, clientConf, new Path("/filetestAuxiliaryPortSendingQOPIntegrity"));
            Assertions.assertTrue((secretIntegrity.length > 0 ? 1 : 0) != 0);
            clientConf.set("hadoop.rpc.protection", "authentication");
            byte[] secretAuthentication = this.getHandshakeSecret(uriAuthPort, clientConf, new Path("/filetestAuxiliaryPortSendingQOPAuthentication"));
            Assertions.assertTrue((secretAuthentication.length > 0 ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getHandshakeSecret(URI uri, HdfsConfiguration conf, Path path) throws Exception {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        try (FSDataOutputStream out = fs.create(path, false, 4096, (short)1, 4096L);){
            out.write(0);
            out.hflush();
            Token<BlockTokenIdentifier> token = DFSTestUtil.getBlockToken(out);
            byte[] tokenBytes = token.getIdentifier();
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(tokenBytes, tokenBytes.length);
            BlockTokenIdentifier blockToken = new BlockTokenIdentifier();
            blockToken.readFields((DataInput)dib);
            byte[] byArray = blockToken.getHandshakeMsg();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleNNPort() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(3).build();
            cluster.waitActive();
            HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
            clientConf.unset("hadoop.security.saslproperties.resolver.class");
            ArrayList<DataNode> dataNodes = cluster.getDataNodes();
            URI currentURI = cluster.getURI();
            URI uriAuthPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12001");
            URI uriIntegrityPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12101");
            URI uriPrivacyPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12201");
            clientConf.set("hadoop.rpc.protection", "privacy");
            FileSystem fsPrivacy = FileSystem.get((URI)uriPrivacyPort, (Configuration)clientConf);
            this.doTest(fsPrivacy, PATH1);
            for (DataNode dataNode : dataNodes) {
                SaslDataTransferServer saslServer = dataNode.getSaslServer();
                Assertions.assertEquals((Object)"auth-conf", (Object)saslServer.getNegotiatedQOP());
            }
            clientConf.set("hadoop.rpc.protection", "integrity");
            FileSystem fsIntegrity = FileSystem.get((URI)uriIntegrityPort, (Configuration)clientConf);
            this.doTest(fsIntegrity, PATH2);
            for (DataNode dn : dataNodes) {
                SaslDataTransferServer saslServer = dn.getSaslServer();
                Assertions.assertEquals((Object)"auth-int", (Object)saslServer.getNegotiatedQOP());
            }
            clientConf.set("hadoop.rpc.protection", "authentication");
            FileSystem fileSystem = FileSystem.get((URI)uriAuthPort, (Configuration)clientConf);
            this.doTest(fileSystem, PATH3);
            for (DataNode dn : dataNodes) {
                SaslDataTransferServer saslServer = dn.getSaslServer();
                Assertions.assertEquals((Object)"auth", (Object)saslServer.getNegotiatedQOP());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleNNPortOverwriteDownStream() throws Exception {
        clusterConf.set("dfs.encrypt.data.overwrite.downstream.new.qop", "auth");
        clusterConf.setBoolean("dfs.encrypt.data.overwrite.downstream.derived.qop", true);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)clusterConf).numDataNodes(3).build();
            cluster.waitActive();
            HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
            clientConf.unset("hadoop.security.saslproperties.resolver.class");
            ArrayList<DataNode> dataNodes = cluster.getDataNodes();
            URI currentURI = cluster.getURI();
            URI uriAuthPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12001");
            URI uriIntegrityPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12101");
            URI uriPrivacyPort = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12201");
            clientConf.set("hadoop.rpc.protection", "privacy");
            FileSystem fsPrivacy = FileSystem.get((URI)uriPrivacyPort, (Configuration)clientConf);
            this.doTest(fsPrivacy, PATH1);
            long count = dataNodes.stream().map(dn -> dn.getSaslClient().getTargetQOP()).filter("auth"::equals).count();
            Assertions.assertTrue((count >= 2L ? 1 : 0) != 0, (String)"At least two qops should be auth");
            clientConf.set("hadoop.rpc.protection", "integrity");
            FileSystem fsIntegrity = FileSystem.get((URI)uriIntegrityPort, (Configuration)clientConf);
            this.doTest(fsIntegrity, PATH2);
            count = dataNodes.stream().map(dn -> dn.getSaslClient().getTargetQOP()).filter("auth"::equals).count();
            Assertions.assertTrue((count >= 2L ? 1 : 0) != 0, (String)"At least two qops should be auth");
            clientConf.set("hadoop.rpc.protection", "authentication");
            FileSystem fsAuth = FileSystem.get((URI)uriAuthPort, (Configuration)clientConf);
            this.doTest(fsAuth, PATH3);
            count = dataNodes.stream().map(dn -> dn.getSaslServer().getNegotiatedQOP()).filter("auth"::equals).count();
            Assertions.assertEquals((long)3L, (long)count, (String)"All qops should be auth");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void doTest(FileSystem fs, Path path) throws Exception {
        FileSystemTestHelper.createFile((FileSystem)fs, (Path)path, (int)3, (int)4096);
        Assertions.assertArrayEquals((byte[])FileSystemTestHelper.getFileData((int)3, (long)4096L), (byte[])DFSTestUtil.readFile(fs, path).getBytes(StandardCharsets.UTF_8));
        BlockLocation[] blockLocations = fs.getFileBlockLocations(path, 0L, Long.MAX_VALUE);
        Assertions.assertNotNull((Object)blockLocations);
        Assertions.assertEquals((int)3, (int)blockLocations.length);
        for (BlockLocation blockLocation : blockLocations) {
            Assertions.assertNotNull((Object)blockLocation.getHosts());
            Assertions.assertEquals((int)3, (int)blockLocation.getHosts().length);
        }
    }
}

