/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMissingBlocksAlert {
    private static final Logger LOG = LoggerFactory.getLogger(TestMissingBlocksAlert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingBlocksAlert() throws IOException, InterruptedException, MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.namenode.redundancy.interval.seconds", 0);
            conf.setInt("dfs.client.retry.window.base", 10);
            int fileLen = 10240;
            conf.setInt("dfs.blocksize", fileLen / 2);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/testMissingBlocksAlert/file1"), fileLen, (short)3, 0L);
            Path corruptFile = new Path("/testMissingBlocks/corruptFile");
            DFSTestUtil.createFile((FileSystem)dfs, corruptFile, fileLen, (short)3, 0L);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)dfs, corruptFile);
            cluster.corruptReplica(0, block);
            FSDataInputStream in = dfs.open(corruptFile);
            try {
                in.readFully(new byte[fileLen]);
            }
            catch (ChecksumException checksumException) {
                // empty catch block
            }
            in.close();
            LOG.info("Waiting for missing blocks count to increase...");
            while (dfs.getMissingBlocksCount() <= 0L) {
                Thread.sleep(100L);
            }
            Assertions.assertTrue((dfs.getMissingBlocksCount() == 1L ? 1 : 0) != 0);
            Assertions.assertEquals((long)4L, (long)dfs.getLowRedundancyBlocksCount());
            Assertions.assertEquals((int)3, (int)bm.getUnderReplicatedNotMissingBlocks());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            Assertions.assertEquals((long)1L, (long)((Long)mbs.getAttribute(mxbeanName, "NumberOfMissingBlocks")));
            dfs.delete(corruptFile, true);
            LOG.info("Waiting for missing blocks count to be zero...");
            while (dfs.getMissingBlocksCount() > 0L) {
                Thread.sleep(100L);
            }
            Assertions.assertEquals((long)2L, (long)dfs.getLowRedundancyBlocksCount());
            Assertions.assertEquals((int)2, (int)bm.getUnderReplicatedNotMissingBlocks());
            Assertions.assertEquals((long)0L, (long)((Long)mbs.getAttribute(mxbeanName, "NumberOfMissingBlocks")));
            Path replOneFile = new Path("/testMissingBlocks/replOneFile");
            DFSTestUtil.createFile((FileSystem)dfs, replOneFile, fileLen, (short)1, 0L);
            ExtendedBlock replOneBlock = DFSTestUtil.getFirstBlock((FileSystem)dfs, replOneFile);
            cluster.corruptReplica(0, replOneBlock);
            in = dfs.open(replOneFile);
            try {
                in.readFully(new byte[fileLen]);
            }
            catch (ChecksumException checksumException) {
                // empty catch block
            }
            in.close();
            Assertions.assertEquals((long)1L, (long)dfs.getMissingReplOneBlocksCount());
            Assertions.assertEquals((long)1L, (long)((Long)mbs.getAttribute(mxbeanName, "NumberOfMissingBlocksWithReplicationFactorOne")));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissReplicatedBlockwithTwoRack() throws Exception {
        Configuration conf = new Configuration();
        String[] hosts = new String[]{"host0", "host1", "host2", "host3"};
        String[] racks = new String[]{"/default/rack1", "/default/rack1", "/default/rack1", "/default/rack1"};
        conf.set("dfs.block.replicator.classname", AvailableSpaceBlockPlacementPolicy.class.getName());
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).hosts(hosts).racks(racks).build();
        Path file = new Path("/file2");
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)dfs, file, 1024L, (short)2, 0L);
            dfs.getFileStatus(file);
            cluster.startDataNodes(conf, 2, true, null, new String[]{"/default/rack2", "/default/rack2"}, new String[]{"host4", "host5"}, null);
            dfs.setReplication(file, (short)3);
            DFSTestUtil.waitForReplication(dfs, file, (short)3, 60000);
        }
        finally {
            cluster.shutdown();
        }
    }
}

