/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMaintenanceWithStriped {
    private static final Logger LOG = LoggerFactory.getLogger(TestMaintenanceWithStriped.class);
    private static final int HEARTBEAT_INTERVAL = 1;
    private static final int BLOCKREPORT_INTERVAL_MSEC = 1000;
    private static final int NAMENODE_REPLICATION_INTERVAL = 1;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private int numDNs;
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int dataBlocks = this.ecPolicy.getNumDataUnits();
    private final int parityBlocks = this.ecPolicy.getNumParityUnits();
    private final int blockSize = this.cellSize * 4;
    private final int blockGroupSize = this.blockSize * this.dataBlocks;
    private final Path ecDir = new Path("/" + this.getClass().getSimpleName());
    private HostsFileWriter hostsFileWriter;
    private boolean useCombinedHostFileManager = true;
    private FSNamesystem fsn;
    private BlockManager bm;

    protected Configuration createConfiguration() {
        return new HdfsConfiguration();
    }

    @BeforeEach
    public void setup() throws IOException {
        this.hostsFileWriter = new HostsFileWriter();
        this.conf = this.createConfiguration();
        if (this.useCombinedHostFileManager) {
            this.conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
        }
        this.hostsFileWriter.initialize(this.conf, "temp/admin");
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.conf.setInt("dfs.blockreport.intervalMsec", 1000);
        this.conf.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 4);
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setInt("dfs.datanode.ec.reconstruction.stripedread.buffer.size", this.cellSize - 1);
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        this.numDNs = this.dataBlocks + this.parityBlocks + 5;
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDNs).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem(0);
        this.fsn = this.cluster.getNamesystem();
        this.bm = this.fsn.getBlockManager();
        this.dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        this.dfs.mkdirs(this.ecDir);
        this.dfs.setErasureCodingPolicy(this.ecDir, StripedFileTestUtil.getDefaultECPolicy().getName());
    }

    @AfterEach
    public void teardown() throws IOException {
        this.hostsFileWriter.cleanup();
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    @Timeout(value=120L)
    public void testInMaintenance() throws Exception {
        Path ecFile = new Path(this.ecDir, "testInMaintenance");
        int writeBytes = this.cellSize * this.dataBlocks;
        this.writeStripedFile(this.dfs, ecFile, writeBytes);
        Assertions.assertEquals((int)0, (int)this.bm.numOfUnderReplicatedBlocks());
        FileChecksum fileChecksum1 = this.dfs.getFileChecksum(ecFile, (long)writeBytes);
        INodeFile fileNode = this.cluster.getNamesystem().getFSDirectory().getINode4Write(ecFile.toString()).asFile();
        BlockInfo firstBlock = fileNode.getBlocks()[0];
        DatanodeStorageInfo[] dnStorageInfos = this.bm.getStorages(firstBlock);
        int maintenanceDNIndex = 4;
        int numMaintenance = 5;
        ArrayList<DatanodeInfo> maintenanceNodes = new ArrayList<DatanodeInfo>();
        for (int i = maintenanceDNIndex; i < numMaintenance + maintenanceDNIndex; ++i) {
            maintenanceNodes.add((DatanodeInfo)dnStorageInfos[i].getDatanodeDescriptor());
        }
        this.maintenanceNode(0, maintenanceNodes, DatanodeInfo.AdminStates.IN_MAINTENANCE, Long.MAX_VALUE);
        GenericTestUtils.waitFor(() -> maintenanceNodes.size() == this.fsn.getNumInMaintenanceLiveDataNodes(), (long)100L, (long)60000L);
        LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(ecFile.toString(), 0L, (long)writeBytes);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        BlockInfoStriped blockInfo = (BlockInfoStriped)this.bm.getStoredBlock(new Block(bg.getBlock().getBlockId()));
        Assertions.assertEquals((int)6, (int)this.bm.countNodes((BlockInfo)blockInfo).liveReplicas());
        Assertions.assertEquals((int)5, (int)this.bm.countNodes((BlockInfo)blockInfo).maintenanceNotForReadReplicas());
        FileChecksum fileChecksum2 = this.dfs.getFileChecksum(ecFile, (long)writeBytes);
        Assertions.assertEquals((Object)fileChecksum1, (Object)fileChecksum2, (String)"Checksum mismatches!");
    }

    private static DFSClient getDfsClient(NameNode nn, Configuration conf) throws IOException {
        return new DFSClient(nn.getNameNodeAddress(), conf);
    }

    private byte[] writeStripedFile(DistributedFileSystem fs, Path ecFile, int writeBytes) throws Exception {
        byte[] bytes = StripedFileTestUtil.generateBytes(writeBytes);
        DFSTestUtil.writeFile((FileSystem)fs, ecFile, new String(bytes));
        StripedFileTestUtil.waitBlockGroupsReported(fs, ecFile.toString());
        StripedFileTestUtil.checkData(fs, ecFile, writeBytes, new ArrayList<DatanodeInfo>(), null, this.blockGroupSize);
        return bytes;
    }

    private void maintenanceNode(int nnIndex, List<DatanodeInfo> maintenancedNodes, DatanodeInfo.AdminStates waitForState, long maintenanceExpirationInMS) throws IOException, TimeoutException, InterruptedException {
        DFSClient client = TestMaintenanceWithStriped.getDfsClient(this.cluster.getNameNode(nnIndex), this.conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        HashMap<String, Long> maintenanceNodes = new HashMap<String, Long>();
        for (DatanodeInfo dn : maintenancedNodes) {
            boolean nodeExists = false;
            for (DatanodeInfo dninfo : info) {
                if (!dninfo.getDatanodeUuid().equals(dn.getDatanodeUuid())) continue;
                nodeExists = true;
                break;
            }
            Assertions.assertTrue((boolean)nodeExists, (String)("Datanode: " + dn + " is not LIVE"));
            maintenanceNodes.put(dn.getName(), maintenanceExpirationInMS);
            LOG.info("Maintenance node: " + dn.getName());
        }
        this.hostsFileWriter.initOutOfServiceHosts(null, maintenanceNodes);
        TestMaintenanceWithStriped.refreshNodes(this.cluster.getNamesystem(nnIndex), this.conf);
        for (DatanodeInfo dn : maintenancedNodes) {
            DatanodeDescriptor ret = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(nnIndex), (DatanodeID)dn);
            LOG.info("Waiting for node " + ret + " to change state to " + waitForState + " current state: " + ret.getAdminState());
            GenericTestUtils.waitFor(() -> TestMaintenanceWithStriped.lambda$maintenanceNode$1((DatanodeInfo)ret, waitForState), (long)100L, (long)60000L);
            LOG.info("node " + ret + " reached the state " + waitForState);
        }
    }

    private static void refreshNodes(FSNamesystem ns, Configuration conf) throws IOException {
        ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
    }

    private static /* synthetic */ Boolean lambda$maintenanceNode$1(DatanodeInfo ret, DatanodeInfo.AdminStates waitForState) {
        return ret.getAdminState() == waitForState;
    }
}

