/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeRpcServer;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.test.TestName;
import org.apache.hadoop.util.Sets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHDFSPolicyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestHDFSPolicyProvider.class);
    private static Set<Class<?>> policyProviderProtocols;
    private static final Comparator<Class<?>> CLASS_NAME_COMPARATOR;
    @RegisterExtension
    private TestName methodName = new TestName();
    private Class<?> rpcServerClass;

    @BeforeAll
    public static void initialize() {
        Service[] services = new HDFSPolicyProvider().getServices();
        policyProviderProtocols = new HashSet(services.length);
        for (Service service : services) {
            policyProviderProtocols.add(service.getProtocol());
        }
    }

    public void initTestHDFSPolicyProvider(Class<?> pRpcServerClass) {
        this.rpcServerClass = pRpcServerClass;
        TestHDFSPolicyProvider.initialize();
    }

    public static List<Class<?>[]> data() {
        return Arrays.asList({NameNodeRpcServer.class}, {DataNode.class}, {JournalNodeRpcServer.class});
    }

    @ParameterizedTest(name="protocolsForServer-{0}")
    @MethodSource(value={"data"})
    public void testPolicyProviderForServer(Class<?> pRpcServerClass) {
        this.initTestHDFSPolicyProvider(pRpcServerClass);
        List ifaces = ClassUtils.getAllInterfaces(this.rpcServerClass);
        HashSet<Class> serverProtocols = new HashSet<Class>(ifaces.size());
        for (Object obj : ifaces) {
            Class iface = (Class)obj;
            if (!iface.getSimpleName().endsWith("Protocol")) continue;
            serverProtocols.add(iface);
        }
        LOG.info("Running test {} for RPC server {}.  Found server protocols {} and policy provider protocols {}.", new Object[]{this.methodName.getMethodName(), this.rpcServerClass.getName(), serverProtocols, policyProviderProtocols});
        Assertions.assertFalse((boolean)serverProtocols.isEmpty(), (String)"Expected to find at least one protocol in server.");
        Set differenceSet = Sets.difference(serverProtocols, policyProviderProtocols);
        Assertions.assertTrue((boolean)differenceSet.isEmpty(), (String)String.format("Following protocols for server %s are not defined in %s: %s", this.rpcServerClass.getName(), HDFSPolicyProvider.class.getName(), Arrays.toString(differenceSet.toArray())));
    }

    static {
        CLASS_NAME_COMPARATOR = new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> lhs, Class<?> rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        };
    }
}

