/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGetFileChecksum {
    private static final int BLOCKSIZE = 1024;
    private static final short REPLICATION = 3;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    public void testGetFileChecksum(Path foo, int appendLength) throws Exception {
        int i;
        int appendRounds = 16;
        FileChecksum[] fc = new FileChecksum[17];
        DFSTestUtil.createFile((FileSystem)this.dfs, foo, appendLength, (short)3, 0L);
        fc[0] = this.dfs.getFileChecksum(foo);
        for (i = 0; i < 16; ++i) {
            DFSTestUtil.appendFile((FileSystem)this.dfs, foo, appendLength);
            fc[i + 1] = this.dfs.getFileChecksum(foo);
        }
        for (i = 0; i < 17; ++i) {
            FileChecksum checksum = this.dfs.getFileChecksum(foo, (long)(appendLength * (i + 1)));
            Assertions.assertTrue((boolean)checksum.equals((Object)fc[i]));
        }
    }

    @Test
    public void testGetFileChecksumForBlocksUnderConstruction() {
        try {
            FSDataOutputStream file = this.dfs.create(new Path("/testFile"));
            file.write("Performance Testing".getBytes());
            this.dfs.getFileChecksum(new Path("/testFile"));
            Assertions.fail((String)"getFileChecksum should fail for files with blocks under construction");
        }
        catch (IOException ie) {
            Assertions.assertTrue((boolean)ie.getMessage().contains("Fail to get checksum, since file /testFile is under construction."));
        }
    }

    @Test
    public void testGetFileChecksum() throws Exception {
        this.testGetFileChecksum(new Path("/foo"), 256);
        this.testGetFileChecksum(new Path("/bar"), 255);
    }
}

