/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFsShellPermission {
    private static final String TEST_ROOT = "/testroot";

    static UserGroupInformation createUGI(String ownername, String groupName) {
        return UserGroupInformation.createUserForTesting((String)ownername, (String[])new String[]{groupName});
    }

    private void createFiles(FileSystem fs, String topdir, FileEntry[] entries) throws IOException {
        for (FileEntry entry : entries) {
            String newPathStr = topdir + "/" + entry.getPath();
            Path newPath = new Path(newPathStr);
            if (entry.isDirectory()) {
                fs.mkdirs(newPath);
            } else {
                FileSystemTestHelper.createFile((FileSystem)fs, (Path)newPath);
            }
            fs.setPermission(newPath, new FsPermission(entry.getPermission()));
            fs.setOwner(newPath, entry.getOwner(), entry.getGroup());
        }
    }

    private static void deldir(FileSystem fs, String topdir) throws IOException {
        fs.delete(new Path(topdir), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String execCmd(FsShell shell, String[] args) throws Exception {
        int ret;
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baout, true);
        PrintStream old = System.out;
        try {
            System.setOut(out);
            ret = shell.run(args);
            out.close();
        }
        finally {
            System.setOut(old);
        }
        return String.valueOf(ret);
    }

    private TestDeleteHelper genDeleteEmptyDirHelper(String cmdOpts, String targetPerm, String asUser, boolean expectedToDelete) {
        FileEntry[] files = new FileEntry[]{new FileEntry("userA", true, "userA", "users", "755"), new FileEntry("userA/userB", true, "userB", "users", targetPerm)};
        FileEntry deleteEntry = files[1];
        return new TestDeleteHelper(files, deleteEntry, cmdOpts, asUser, expectedToDelete);
    }

    private TestDeleteHelper genRmrEmptyDirWithReadPerm() {
        return this.genDeleteEmptyDirHelper("-rm -r", "744", "userA", true);
    }

    private TestDeleteHelper genRmrEmptyDirWithNoPerm() {
        return this.genDeleteEmptyDirHelper("-rm -r", "700", "userA", true);
    }

    private TestDeleteHelper genRmrfEmptyDirWithNoPerm() {
        return this.genDeleteEmptyDirHelper("-rm -r -f", "700", "userA", true);
    }

    private TestDeleteHelper genDeleteNonEmptyDirHelper(String cmd, String targetPerm, String asUser, boolean expectedToDelete) {
        FileEntry[] files = new FileEntry[]{new FileEntry("userA", true, "userA", "users", "755"), new FileEntry("userA/userB", true, "userB", "users", targetPerm), new FileEntry("userA/userB/xyzfile", false, "userB", "users", targetPerm)};
        FileEntry deleteEntry = files[1];
        return new TestDeleteHelper(files, deleteEntry, cmd, asUser, expectedToDelete);
    }

    private TestDeleteHelper genRmrNonEmptyDirWithReadPerm() {
        return this.genDeleteNonEmptyDirHelper("-rm -r", "744", "userA", false);
    }

    private TestDeleteHelper genRmrNonEmptyDirWithNoPerm() {
        return this.genDeleteNonEmptyDirHelper("-rm -r", "700", "userA", false);
    }

    private TestDeleteHelper genRmrNonEmptyDirWithAllPerm() {
        return this.genDeleteNonEmptyDirHelper("-rm -r", "777", "userA", true);
    }

    private TestDeleteHelper genRmrfNonEmptyDirWithNoPerm() {
        return this.genDeleteNonEmptyDirHelper("-rm -r -f", "700", "userA", false);
    }

    public TestDeleteHelper genDeleteSingleFileNotAsOwner() throws Exception {
        FileEntry[] files = new FileEntry[]{new FileEntry("userA", true, "userA", "users", "755"), new FileEntry("userA/userB", false, "userB", "users", "700")};
        FileEntry deleteEntry = files[1];
        return new TestDeleteHelper(files, deleteEntry, "-rm -r", "userA", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        Configuration conf = null;
        MiniDFSCluster cluster = null;
        try {
            conf = new Configuration();
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
            String nnUri = FileSystem.getDefaultUri((Configuration)conf).toString();
            FileSystem fs = FileSystem.get((URI)URI.create(nnUri), (Configuration)conf);
            ArrayList<TestDeleteHelper> ta = new ArrayList<TestDeleteHelper>();
            ta.add(this.genRmrEmptyDirWithReadPerm());
            ta.add(this.genRmrEmptyDirWithNoPerm());
            ta.add(this.genRmrfEmptyDirWithNoPerm());
            ta.add(this.genRmrNonEmptyDirWithReadPerm());
            ta.add(this.genRmrNonEmptyDirWithNoPerm());
            ta.add(this.genRmrNonEmptyDirWithAllPerm());
            ta.add(this.genRmrfNonEmptyDirWithNoPerm());
            ta.add(this.genDeleteSingleFileNotAsOwner());
            for (TestDeleteHelper t : ta) {
                t.execute(conf, fs);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private class TestDeleteHelper {
        private FileEntry[] fileEntries;
        private FileEntry deleteEntry;
        private String cmdAndOptions;
        private boolean expectedToDelete;
        final String doAsGroup;
        final UserGroupInformation userUgi;

        public TestDeleteHelper(FileEntry[] fileEntries, FileEntry deleteEntry, String cmdAndOptions, String doAsUser, boolean expectedToDelete) {
            this.fileEntries = fileEntries;
            this.deleteEntry = deleteEntry;
            this.cmdAndOptions = cmdAndOptions;
            this.expectedToDelete = expectedToDelete;
            this.doAsGroup = doAsUser.equals("hdfs") ? "supergroup" : "users";
            this.userUgi = TestFsShellPermission.createUGI(doAsUser, this.doAsGroup);
        }

        public void execute(Configuration conf, FileSystem fs) throws Exception {
            fs.mkdirs(new Path(TestFsShellPermission.TEST_ROOT));
            TestFsShellPermission.this.createFiles(fs, TestFsShellPermission.TEST_ROOT, this.fileEntries);
            final FsShell fsShell = new FsShell(conf);
            String deletePath = "/testroot/" + this.deleteEntry.getPath();
            String[] tmpCmdOpts = StringUtils.split((String)this.cmdAndOptions);
            ArrayList<String> tmpArray = new ArrayList<String>(Arrays.asList(tmpCmdOpts));
            tmpArray.add(deletePath);
            final String[] cmdOpts = tmpArray.toArray(new String[tmpArray.size()]);
            this.userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return TestFsShellPermission.execCmd(fsShell, cmdOpts);
                }
            });
            boolean deleted = !fs.exists(new Path(deletePath));
            Assertions.assertEquals((Object)this.expectedToDelete, (Object)deleted);
            TestFsShellPermission.deldir(fs, TestFsShellPermission.TEST_ROOT);
        }
    }

    private class FileEntry {
        private String path;
        private boolean isDir;
        private String owner;
        private String group;
        private String permission;

        public FileEntry(String path, boolean isDir, String owner, String group, String permission) {
            this.path = path;
            this.isDir = isDir;
            this.owner = owner;
            this.group = group;
            this.permission = permission;
        }

        String getPath() {
            return this.path;
        }

        boolean isDirectory() {
            return this.isDir;
        }

        String getOwner() {
            return this.owner;
        }

        String getGroup() {
            return this.group;
        }

        String getPermission() {
            return this.permission;
        }
    }
}

