/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=300L)
public class TestFileStatusWithDefaultECPolicy {
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DFSClient client;

    @BeforeEach
    public void before() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        this.fs.enableErasureCodingPolicy(this.getEcPolicy().getName());
    }

    @AfterEach
    public void after() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    public ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Test
    public void testFileStatusWithECPolicy() throws Exception {
        Path dir = new Path("/foo");
        Assertions.assertTrue((boolean)this.fs.mkdir(dir, FsPermission.getDirDefault()));
        ContractTestUtils.assertNotErasureCoded((FileSystem)this.fs, (Path)dir);
        Assertions.assertNull((Object)this.client.getFileInfo(dir.toString()).getErasureCodingPolicy());
        Path file = new Path(dir, "foo");
        this.fs.create(file).close();
        Assertions.assertNull((Object)this.client.getFileInfo(file.toString()).getErasureCodingPolicy());
        ContractTestUtils.assertNotErasureCoded((FileSystem)this.fs, (Path)file);
        this.fs.delete(file, true);
        ErasureCodingPolicy ecPolicy1 = this.getEcPolicy();
        this.fs.setErasureCodingPolicy(dir, ecPolicy1.getName());
        ContractTestUtils.assertErasureCoded((FileSystem)this.fs, (Path)dir);
        ErasureCodingPolicy ecPolicy2 = this.client.getFileInfo(dir.toUri().getPath()).getErasureCodingPolicy();
        Assertions.assertNotNull((Object)ecPolicy2);
        Assertions.assertTrue((boolean)ecPolicy1.equals((Object)ecPolicy2));
        this.fs.create(file).close();
        ErasureCodingPolicy ecPolicy3 = this.fs.getClient().getFileInfo(file.toUri().getPath()).getErasureCodingPolicy();
        Assertions.assertNotNull((Object)ecPolicy3);
        Assertions.assertTrue((boolean)ecPolicy1.equals((Object)ecPolicy3));
        ContractTestUtils.assertErasureCoded((FileSystem)this.fs, (Path)file);
        FileStatus status = this.fs.getFileStatus(file);
        Assertions.assertTrue((boolean)status.toString().contains("isErasureCoded=true"), (String)(file + " should have erasure coding set in FileStatus#toString(): " + status));
    }
}

