/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestFileStatus {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static FileSystem fs;
    private static FileContext fc;
    private static DFSClient dfsClient;
    private static Path file1;

    public TestFileStatus() {
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)FileSystem.LOG, (Level)Level.TRACE);
    }

    @BeforeAll
    public static void testSetUp() throws Exception {
        conf = new HdfsConfiguration();
        conf.setInt("dfs.ls.limit", 2);
        cluster = new MiniDFSCluster.Builder(conf).build();
        fs = cluster.getFileSystem();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)conf);
        dfsClient = new DFSClient(DFSUtilClient.getNNAddress((Configuration)conf), conf);
        file1 = new Path("filestatus.dat");
        DFSTestUtil.createFile(fs, file1, 16384, 16384L, 8192L, (short)1, 3735928559L);
    }

    @AfterAll
    public static void testTearDown() throws Exception {
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private void checkFile(FileSystem fileSys, Path name, int repl) throws IOException, InterruptedException, TimeoutException {
        DFSTestUtil.waitReplication(fileSys, name, (short)repl);
    }

    @Test
    public void testGetFileInfo() throws IOException {
        Path path = new Path("/");
        Assertions.assertTrue((boolean)fs.getFileStatus(path).isDirectory(), (String)"/ should be a directory");
        ContractTestUtils.assertNotErasureCoded((FileSystem)fs, (Path)path);
        HdfsFileStatus fileInfo = dfsClient.getFileInfo("/noSuchFile");
        Assertions.assertEquals(null, (Object)fileInfo, (String)"Non-existant file should result in null");
        Path path1 = new Path("/name1");
        Path path2 = new Path("/name1/name2");
        Assertions.assertTrue((boolean)fs.mkdirs(path1));
        FSDataOutputStream out = fs.create(path2, false);
        out.close();
        fileInfo = dfsClient.getFileInfo(path1.toString());
        Assertions.assertEquals((int)1, (int)fileInfo.getChildrenNum());
        fileInfo = dfsClient.getFileInfo(path2.toString());
        Assertions.assertEquals((int)0, (int)fileInfo.getChildrenNum());
        try {
            dfsClient.getFileInfo("non-absolute");
            Assertions.fail((String)"getFileInfo for a non-absolute path did not throw IOException");
        }
        catch (RemoteException re) {
            Assertions.assertTrue((boolean)re.toString().contains("Absolute path required"), (String)("Wrong exception for invalid file name: " + (Object)((Object)re)));
        }
    }

    @Test
    public void testGetFileStatusOnFile() throws Exception {
        this.checkFile(fs, file1, 1);
        FileStatus status = fs.getFileStatus(file1);
        Assertions.assertFalse((boolean)status.isDirectory(), (String)(file1 + " should be a file"));
        Assertions.assertEquals((long)8192L, (long)status.getBlockSize());
        Assertions.assertEquals((int)1, (int)status.getReplication());
        Assertions.assertEquals((long)16384L, (long)status.getLen());
        ContractTestUtils.assertNotErasureCoded((FileSystem)fs, (Path)file1);
        Assertions.assertEquals((Object)file1.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), (Object)status.getPath().toString());
        Assertions.assertTrue((boolean)status.toString().contains("isErasureCoded=false"), (String)(file1 + " should have erasure coding unset in FileStatus#toString(): " + status));
    }

    @Test
    public void testListStatusOnFile() throws IOException {
        FileStatus[] stats = fs.listStatus(file1);
        Assertions.assertEquals((int)1, (int)stats.length);
        FileStatus status = stats[0];
        Assertions.assertFalse((boolean)status.isDirectory(), (String)(file1 + " should be a file"));
        Assertions.assertEquals((long)8192L, (long)status.getBlockSize());
        Assertions.assertEquals((int)1, (int)status.getReplication());
        Assertions.assertEquals((long)16384L, (long)status.getLen());
        ContractTestUtils.assertNotErasureCoded((FileSystem)fs, (Path)file1);
        Assertions.assertEquals((Object)file1.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), (Object)status.getPath().toString());
        RemoteIterator itor = fc.listStatus(file1);
        status = (FileStatus)itor.next();
        Assertions.assertEquals((Object)stats[0], (Object)status);
        Assertions.assertFalse((boolean)status.isDirectory(), (String)(file1 + " should be a file"));
    }

    @Test
    public void testGetFileStatusOnNonExistantFileDir() throws IOException {
        Path dir = new Path("/test/mkdirs");
        try {
            fs.listStatus(dir);
            Assertions.fail((String)"listStatus of non-existent path should fail");
        }
        catch (FileNotFoundException fe) {
            Assertions.assertEquals((Object)("File " + dir + " does not exist."), (Object)fe.getMessage());
        }
        try {
            fc.listStatus(dir);
            Assertions.fail((String)"listStatus of non-existent path should fail");
        }
        catch (FileNotFoundException fe) {
            Assertions.assertEquals((Object)("File " + dir + " does not exist."), (Object)fe.getMessage());
        }
        try {
            fs.getFileStatus(dir);
            Assertions.fail((String)"getFileStatus of non-existent path should fail");
        }
        catch (FileNotFoundException fe) {
            Assertions.assertTrue((boolean)fe.getMessage().startsWith("File does not exist"), (String)"Exception doesn't indicate non-existant path");
        }
    }

    @Test
    public void testGetFileStatusOnDir() throws Exception {
        Path dir = new Path("/test/mkdirs");
        Assertions.assertTrue((boolean)fs.mkdirs(dir), (String)"mkdir failed");
        Assertions.assertTrue((boolean)fs.exists(dir), (String)"mkdir failed");
        FileStatus status = fs.getFileStatus(dir);
        Assertions.assertTrue((boolean)status.isDirectory(), (String)(dir + " should be a directory"));
        Assertions.assertTrue((status.getLen() == 0L ? 1 : 0) != 0, (String)(dir + " should be zero size "));
        ContractTestUtils.assertNotErasureCoded((FileSystem)fs, (Path)dir);
        Assertions.assertEquals((Object)dir.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), (Object)status.getPath().toString());
        FileStatus[] stats = fs.listStatus(dir);
        Assertions.assertEquals((int)0, (int)stats.length, (String)(dir + " should be empty"));
        Assertions.assertEquals((long)0L, (long)fs.getContentSummary(dir).getLength(), (String)(dir + " should be zero size "));
        RemoteIterator itor = fc.listStatus(dir);
        Assertions.assertFalse((boolean)itor.hasNext(), (String)(dir + " should be empty"));
        itor = fs.listStatusIterator(dir);
        Assertions.assertFalse((boolean)itor.hasNext(), (String)(dir + " should be empty"));
        Path file2 = new Path(dir, "filestatus2.dat");
        DFSTestUtil.createFile(fs, file2, 2048, 2048L, 8192L, (short)1, 3735928559L);
        this.checkFile(fs, file2, 1);
        status = fs.getFileStatus(file2);
        Assertions.assertEquals((long)8192L, (long)status.getBlockSize());
        Assertions.assertEquals((int)1, (int)status.getReplication());
        file2 = fs.makeQualified(file2);
        Assertions.assertEquals((Object)file2.toString(), (Object)status.getPath().toString());
        Path file3 = new Path(dir, "filestatus3.dat");
        DFSTestUtil.createFile(fs, file3, 2048, 2048L, 8192L, (short)1, 3735928559L);
        this.checkFile(fs, file3, 1);
        file3 = fs.makeQualified(file3);
        int expected = 4096;
        Assertions.assertEquals((long)4096L, (long)fs.getContentSummary(dir).getLength(), (String)(dir + " size should be " + 4096));
        stats = fs.listStatus(dir);
        Assertions.assertEquals((int)2, (int)stats.length, (String)(dir + " should have two entries"));
        Assertions.assertEquals((Object)file2.toString(), (Object)stats[0].getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)stats[1].getPath().toString());
        itor = fc.listStatus(dir);
        Assertions.assertEquals((Object)file2.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertFalse((boolean)itor.hasNext(), (String)"Unexpected addtional file");
        itor = fs.listStatusIterator(dir);
        Assertions.assertEquals((Object)file2.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertFalse((boolean)itor.hasNext(), (String)"Unexpected addtional file");
        Path dir3 = fs.makeQualified(new Path(dir, "dir3"));
        fs.mkdirs(dir3);
        dir3 = fs.makeQualified(dir3);
        stats = fs.listStatus(dir);
        Assertions.assertEquals((int)3, (int)stats.length, (String)(dir + " should have three entries"));
        Assertions.assertEquals((Object)dir3.toString(), (Object)stats[0].getPath().toString());
        Assertions.assertEquals((Object)file2.toString(), (Object)stats[1].getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)stats[2].getPath().toString());
        itor = fc.listStatus(dir);
        Assertions.assertEquals((Object)dir3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file2.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertFalse((boolean)itor.hasNext(), (String)"Unexpected addtional file");
        itor = fs.listStatusIterator(dir);
        Assertions.assertEquals((Object)dir3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file2.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertFalse((boolean)itor.hasNext(), (String)"Unexpected addtional file");
        Path dir4 = fs.makeQualified(new Path(dir, "dir4"));
        fs.mkdirs(dir4);
        dir4 = fs.makeQualified(dir4);
        Path dir5 = fs.makeQualified(new Path(dir, "dir5"));
        fs.mkdirs(dir5);
        dir5 = fs.makeQualified(dir5);
        stats = fs.listStatus(dir);
        Assertions.assertEquals((int)5, (int)stats.length, (String)(dir + " should have five entries"));
        Assertions.assertEquals((Object)dir3.toString(), (Object)stats[0].getPath().toString());
        Assertions.assertEquals((Object)dir4.toString(), (Object)stats[1].getPath().toString());
        Assertions.assertEquals((Object)dir5.toString(), (Object)stats[2].getPath().toString());
        Assertions.assertEquals((Object)file2.toString(), (Object)stats[3].getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)stats[4].getPath().toString());
        itor = fc.listStatus(dir);
        Assertions.assertEquals((Object)dir3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)dir4.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)dir5.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file2.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertFalse((boolean)itor.hasNext());
        itor = fs.listStatusIterator(dir);
        Assertions.assertEquals((Object)dir3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)dir4.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)dir5.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file2.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)file3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertFalse((boolean)itor.hasNext());
        itor = fs.listStatusIterator(dir);
        Assertions.assertEquals((Object)dir3.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        Assertions.assertEquals((Object)dir4.toString(), (Object)((FileStatus)itor.next()).getPath().toString());
        fs.delete(dir.getParent(), true);
        try {
            itor.hasNext();
            Assertions.fail((String)"FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(file2);
        fs.mkdirs(dir3);
        fs.mkdirs(dir4);
        fs.mkdirs(dir5);
        itor = fs.listStatusIterator(dir);
        int count = 0;
        try {
            fs.delete(dir.getParent(), true);
            while (itor.next() != null) {
                ++count;
            }
            Assertions.fail((String)"FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Assertions.assertEquals((int)2, (int)count);
    }
}

